/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IItemWithTier
extends ItemLike {
    @OnlyIn(value=Dist.CLIENT)
    default public void addTierInformation(List<Component> tooltip) {
        TIER t = this.getVampirismTier();
        if (t != TIER.NORMAL) {
            ChatFormatting format = t == TIER.ENHANCED ? ChatFormatting.YELLOW : ChatFormatting.AQUA;
            tooltip.add((Component)new TranslatableComponent("item.vampirism.item.tier." + t.m_7912_().toLowerCase()).m_130940_(format));
        }
    }

    public String getBaseRegName();

    public TIER getVampirismTier();

    public static enum TIER implements StringRepresentable
    {
        NORMAL("normal"),
        ENHANCED("enhanced"),
        ULTIMATE("ultimate");

        private final String name;

        private TIER(String name) {
            this.name = name;
        }

        public String getName() {
            return this.m_7912_();
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }
}

