/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.general;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.VReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BloodConversionRegistry {
    @Nonnull
    private static final Map<ResourceLocation, Integer> items = Maps.newHashMap();
    @Nonnull
    private static final Map<ResourceLocation, Integer> fluids = Maps.newHashMap();
    @Nonnull
    private static final Map<ResourceLocation, Integer> items_calculated = Maps.newHashMap();
    @Nonnull
    private static final Set<ResourceLocation> items_blacklist = Sets.newHashSet();
    private static int fluidDivider = 100;
    private static int itemMultiplier = 100;

    public static void applyNewFluidResources(Map<ResourceLocation, Integer> values, int divider) {
        fluids.clear();
        fluidDivider = divider;
        fluids.putAll(values);
    }

    public static void applyNewItemResources(Map<ResourceLocation, Integer> values, int multiplier) {
        items.clear();
        itemMultiplier = multiplier;
        for (Map.Entry<ResourceLocation, Integer> value : values.entrySet()) {
            if (value.getValue() != 0) {
                items.put(value.getKey(), value.getValue());
                continue;
            }
            items_blacklist.add(value.getKey());
        }
    }

    public static void applyNewItemCalculated(Map<ResourceLocation, Integer> values) {
        items_calculated.putAll(values);
    }

    public static Map<ResourceLocation, Integer> getItemValues() {
        return new ConcurrentHashMap<ResourceLocation, Integer>(items);
    }

    public static Map<ResourceLocation, Integer> getFluidValues() {
        return new ConcurrentHashMap<ResourceLocation, Integer>(fluids);
    }

    public static Map<ResourceLocation, Integer> getItemValuesCalculated() {
        return new ConcurrentHashMap<ResourceLocation, Integer>(items_calculated);
    }

    public static int getFluidDivider() {
        return fluidDivider;
    }

    public static int getItemMultiplier() {
        return itemMultiplier;
    }

    public static int getImpureBloodValue(@Nonnull Item item) {
        if (items.containsKey(item.getRegistryName()) || items_calculated.containsKey(item.getRegistryName())) {
            return items.containsKey(item.getRegistryName()) ? items.get(item.getRegistryName()) * itemMultiplier : items_calculated.get(item.getRegistryName()) * itemMultiplier;
        }
        return 0;
    }

    public static boolean canBeConverted(@Nonnull Item item) {
        int value;
        if (items.containsKey(item.getRegistryName()) || items_calculated.containsKey(item.getRegistryName())) {
            return true;
        }
        if (items_blacklist.contains(item.getRegistryName())) {
            return false;
        }
        if (item.m_41472_() && item.m_41473_().m_38746_() && (value = Mth.m_14045_((int)(item.getRegistryName() != null && item.getRegistryName().m_135815_().contains("cooked") ? 0 : item.m_41473_().m_38744_() / 2), (int)0, (int)5)) > 0) {
            items_calculated.put(item.getRegistryName(), value);
            return true;
        }
        items_blacklist.add(item.getRegistryName());
        return false;
    }

    public static float getBloodValue(@Nonnull FluidStack fluid) {
        if (fluids.containsKey(fluid.getFluid().getRegistryName())) {
            return (float)fluids.get(fluid.getFluid().getRegistryName()).intValue() / (float)fluidDivider;
        }
        return 0.0f;
    }

    public static boolean existsBloodValue(@Nonnull Fluid fluid) {
        return fluids.containsKey(fluid.getRegistryName());
    }

    public static FluidStack getBloodFromFluid(@Nonnull FluidStack fluid) {
        if (fluid.getFluid().m_6212_(VReference.blood_fluid)) {
            return fluid;
        }
        return new FluidStack(VReference.blood_fluid, (int)(BloodConversionRegistry.getBloodValue(fluid) * (float)fluid.getAmount()));
    }
}

