/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class PlayerFactionEvent
extends Event {
    @Nullable
    private final IPlayableFaction<?> currentFaction;
    @Nonnull
    private final IFactionPlayerHandler player;

    private PlayerFactionEvent(@Nonnull IFactionPlayerHandler player, @Nullable IPlayableFaction<?> currentFaction) {
        this.currentFaction = currentFaction;
        this.player = player;
    }

    @Nullable
    public IPlayableFaction<?> getCurrentFaction() {
        return this.currentFaction;
    }

    @Nonnull
    public IFactionPlayerHandler getPlayer() {
        return this.player;
    }

    @Event.HasResult
    public static class CanJoinFaction
    extends PlayerFactionEvent {
        private final IPlayableFaction<?> toJoin;

        public CanJoinFaction(@Nonnull IFactionPlayerHandler player, @Nullable IPlayableFaction<?> currentFaction, IPlayableFaction<?> toJoin) {
            super(player, currentFaction);
            this.toJoin = toJoin;
        }

        public IPlayableFaction<?> getFactionToJoin() {
            return this.toJoin;
        }
    }

    public static class FactionLevelChanged
    extends PlayerFactionEvent {
        private final int oldLevel;
        private final int newLevel;
        @Nullable
        private final IPlayableFaction<?> oldFaction;

        public FactionLevelChanged(@Nonnull IFactionPlayerHandler player, @Nullable IPlayableFaction<?> oldFaction, int oldLevel, @Nullable IPlayableFaction<?> newFaction, int newLevel) {
            super(player, newFaction);
            this.oldLevel = oldLevel;
            this.newLevel = newLevel;
            this.oldFaction = oldFaction;
        }

        public int getOldLevel() {
            return this.oldLevel;
        }

        @Nullable
        public IPlayableFaction<?> getOldFaction() {
            return this.oldFaction;
        }

        public int getNewLevel() {
            return this.newLevel;
        }
    }

    @Cancelable
    public static class FactionLevelChangePre
    extends PlayerFactionEvent {
        private final int currentLevel;
        private final int newLevel;
        @Nullable
        private final IPlayableFaction<?> newFaction;

        public FactionLevelChangePre(@Nonnull IFactionPlayerHandler player, @Nullable IPlayableFaction<?> currentFaction, int currentLevel, @Nullable IPlayableFaction<?> newFaction, int newLevel) {
            super(player, currentFaction);
            this.currentLevel = currentLevel;
            this.newLevel = newLevel;
            this.newFaction = newFaction;
        }

        public int getCurrentLevel() {
            return this.currentLevel;
        }

        @Nullable
        public IPlayableFaction<?> getNewFaction() {
            return this.newFaction;
        }

        public int getNewLevel() {
            return this.newLevel;
        }
    }
}

