/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class DefaultSkill<T extends IFactionPlayer<T>>
extends ForgeRegistryEntry<ISkill<?>>
implements ISkill<T> {
    private final Map<Attribute, LazyOptional<AttributeModifier>> attributeModifierMap = new HashMap<Attribute, LazyOptional<AttributeModifier>>();
    private int renderRow;
    private int renderColumn;
    private Component name;

    @Override
    public Component getName() {
        return this.name == null ? (this.name = new TranslatableComponent(this.getTranslationKey())) : this.name;
    }

    public DefaultSkill<T> setName(Component name) {
        this.name = name;
        return this;
    }

    @Override
    public int getRenderColumn() {
        return this.renderColumn;
    }

    @Override
    public int getRenderRow() {
        return this.renderRow;
    }

    @Override
    @Deprecated
    public String getTranslationKey() {
        return "skill." + this.getRegistryName().m_135827_() + "." + this.getRegistryName().m_135815_();
    }

    @Override
    public final void onDisable(T player) {
        this.removeAttributesModifiersFromEntity(player.getRepresentingPlayer());
        player.getActionHandler().relockActions(this.getActions());
        if (!this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
        }
        this.onDisabled(player);
    }

    @Override
    public final void onEnable(T player) {
        this.applyAttributesModifiersToEntity(player.getRepresentingPlayer());
        player.getActionHandler().unlockActions(this.getActions());
        if (!this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
        }
        this.onEnabled(player);
    }

    public DefaultSkill<T> registerAttributeModifier(Attribute attribute, String uuid, double amount, AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this.getRegistryName().toString(), amount, operation);
        this.attributeModifierMap.put(attribute, (LazyOptional<AttributeModifier>)LazyOptional.of(() -> attributemodifier));
        return this;
    }

    public DefaultSkill<T> registerAttributeModifier(Attribute attribute, String uuid, Supplier<Double> amountSupplier, AttributeModifier.Operation operation) {
        this.attributeModifierMap.put(attribute, (LazyOptional<AttributeModifier>)LazyOptional.of(() -> new AttributeModifier(UUID.fromString(uuid), this.getRegistryName().toString(), ((Double)amountSupplier.get()).doubleValue(), operation)));
        return this;
    }

    @Override
    public void setRenderPos(int row, int column) {
        this.renderRow = row;
        this.renderColumn = column;
    }

    public String toString() {
        return this.getRegistryName() + "(" + this.getClass().getSimpleName() + ")";
    }

    protected void getActions(Collection<IAction<T>> list) {
    }

    protected void onDisabled(T player) {
    }

    protected void onEnabled(T player) {
    }

    private void applyAttributesModifiersToEntity(Player player) {
        for (Map.Entry<Attribute, LazyOptional<AttributeModifier>> entry : this.attributeModifierMap.entrySet()) {
            AttributeInstance instance = player.m_21051_(entry.getKey());
            if (instance == null) continue;
            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue().orElseThrow(IllegalStateException::new);
            instance.m_22130_(attributemodifier);
            instance.m_22125_(new AttributeModifier(attributemodifier.m_22209_(), this.getRegistryName().toString(), attributemodifier.m_22218_(), attributemodifier.m_22217_()));
        }
    }

    private Collection<IAction<T>> getActions() {
        ArrayList<IAction<IAction>> collection = new ArrayList<IAction<IAction>>();
        this.getActions(collection);
        collection.forEach(iAction -> {
            if (!iAction.getFaction().equals(this.getFaction())) {
                throw new IllegalArgumentException("Can't register action of faction " + iAction.getFaction() + " for skill of faction" + this.getFaction());
            }
        });
        return collection;
    }

    private void removeAttributesModifiersFromEntity(Player player) {
        for (Map.Entry<Attribute, LazyOptional<AttributeModifier>> entry : this.attributeModifierMap.entrySet()) {
            AttributeInstance attribute = player.m_21051_(entry.getKey());
            if (attribute == null) continue;
            attribute.m_22130_((AttributeModifier)entry.getValue().orElseThrow(IllegalStateException::new));
        }
    }
}

