/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public enum EntityClassType {
    None(0.0, 0.0, 0.0),
    Tank(0.3, 0.0, 0.0),
    Fighter(0.0, 0.1, 0.0),
    Support(0.0, 0.0, 0.0),
    Caster(0.0, 0.1, 0.0),
    Assassin(0.0, 0.0, 0.08);

    public static final Map<EntityClassType, Integer> ENTITY_CLASS_TYPES;
    public static final Map<Integer, EntityClassType> ID;
    private final AttributeModifier healthModifier;
    private final AttributeModifier damageModifier;
    private final AttributeModifier speedModifier;

    public static EntityClassType getRandomClass(Random rand) {
        return EntityClassType.values()[rand.nextInt(EntityClassType.values().length - 1)];
    }

    public static int getID(EntityClassType entityclasstype) {
        return ENTITY_CLASS_TYPES.get((Object)entityclasstype);
    }

    @Nullable
    public static EntityClassType getEntityClassType(int id) {
        return id >= ID.size() || id < 0 ? null : ID.get(id);
    }

    private EntityClassType(double healthModifier, double damageModifier, double speedModifier) {
        this.healthModifier = new AttributeModifier("entity_class_health", healthModifier, AttributeModifier.Operation.MULTIPLY_BASE);
        this.damageModifier = new AttributeModifier("entity_class_damage", damageModifier, AttributeModifier.Operation.MULTIPLY_BASE);
        this.speedModifier = new AttributeModifier("entity_class_speed", speedModifier, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public AttributeModifier getDamageModifier() {
        return this.damageModifier;
    }

    public AttributeModifier getHealthModifier() {
        return this.healthModifier;
    }

    public AttributeModifier getSpeedModifier() {
        return this.speedModifier;
    }

    static {
        ENTITY_CLASS_TYPES = Maps.newHashMap();
        ID = Maps.newHashMap();
        for (EntityClassType entityclasstype : EntityClassType.values()) {
            ENTITY_CLASS_TYPES.put(entityclasstype, ENTITY_CLASS_TYPES.size());
            ID.put(ID.size(), entityclasstype);
        }
    }
}

