/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.gson.JsonObject;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TriggerFaction
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "faction");
    private static final Logger LOGGER = LogManager.getLogger();

    public static Instance level(@Nullable IPlayableFaction<?> faction, int level) {
        return new Instance(Type.LEVEL, faction, level);
    }

    public static Instance lord(@Nullable IPlayableFaction<?> faction, int lordLevel) {
        return new Instance(Type.LORD, faction, lordLevel);
    }

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer playerMP, IPlayableFaction<?> faction, int level, int lordLevel) {
        this.m_66234_(playerMP, instance -> instance.test(faction, level, lordLevel));
    }

    @Nonnull
    protected Instance createInstance(JsonObject json, @Nonnull EntityPredicate.Composite entityPredicate, @Nonnull DeserializationContext conditionsParser) {
        String idStr;
        Type type;
        IPlayableFaction faction = null;
        Type type2 = type = json.has("type") ? Type.valueOf(json.get("type").getAsString()) : Type.LEVEL;
        if (json.has("faction") && !"null".equals(idStr = json.get("faction").getAsString())) {
            ResourceLocation id = new ResourceLocation(json.get("faction").getAsString());
            IFaction<?> faction1 = VampirismAPI.factionRegistry().getFactionByID(id);
            if (!(faction1 instanceof IPlayableFaction)) {
                LOGGER.warn("Given faction name does not exist or is not a playable faction: {}", (Object)id);
            } else {
                faction = (IPlayableFaction)faction1;
            }
        }
        int level = json.has("level") ? json.get("level").getAsInt() : 1;
        return new Instance(type, faction, level);
    }

    static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nonnull
        private final Type type;
        @Nullable
        private final IPlayableFaction<?> faction;
        private final int level;

        Instance(@Nonnull Type type, @Nullable IPlayableFaction<?> faction, int level) {
            super(ID, EntityPredicate.Composite.f_36667_);
            this.type = type;
            this.faction = faction;
            this.level = level;
        }

        @Nonnull
        public JsonObject m_7683_(@Nonnull SerializationContext serializer) {
            JsonObject json = super.m_7683_(serializer);
            json.addProperty("type", this.type.name());
            json.addProperty("faction", this.faction == null ? "null" : this.faction.getID().toString());
            json.addProperty("level", (Number)this.level);
            return json;
        }

        public boolean test(IPlayableFaction<?> faction, int level, int lordLevel) {
            if (this.faction == null || this.faction.equals(faction)) {
                if (this.type == Type.LEVEL) {
                    return level >= this.level;
                }
                if (this.type == Type.LORD) {
                    return lordLevel >= this.level;
                }
            }
            return false;
        }
    }

    public static enum Type {
        LEVEL,
        LORD;

    }
}

