/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.mojang.brigadier.CommandDispatcher;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.config.BloodValueLoaderDynamic;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.ModCompatLoader;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.lib.util.Color;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.GeneralEventHandler;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.world.IVampirismWorld;
import de.teamlapen.vampirism.client.core.ClientEventHandler;
import de.teamlapen.vampirism.client.core.ModBlocksRender;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.config.BloodValues;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModCommands;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.core.RegistryManager;
import de.teamlapen.vampirism.data.AdvancementGenerator;
import de.teamlapen.vampirism.data.BlockStateGenerator;
import de.teamlapen.vampirism.data.ItemModelGenerator;
import de.teamlapen.vampirism.data.LootTablesGenerator;
import de.teamlapen.vampirism.data.RecipesGenerator;
import de.teamlapen.vampirism.data.SkillNodeGenerator;
import de.teamlapen.vampirism.data.TagGenerator;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.ModEntityEventHandler;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import de.teamlapen.vampirism.entity.VampirismEntitySelectors;
import de.teamlapen.vampirism.entity.action.ActionManagerEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import de.teamlapen.vampirism.inventory.recipes.ExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.modcompat.terrablender.TerraBlenderCompat;
import de.teamlapen.vampirism.network.ModPacketDispatcher;
import de.teamlapen.vampirism.player.ModPlayerEventHandler;
import de.teamlapen.vampirism.player.actions.ActionManager;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.skills.SkillManager;
import de.teamlapen.vampirism.player.skills.SkillTreeManager;
import de.teamlapen.vampirism.player.vampire.BloodVision;
import de.teamlapen.vampirism.player.vampire.NightVision;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.proxy.IProxy;
import de.teamlapen.vampirism.proxy.ServerProxy;
import de.teamlapen.vampirism.tests.Tests;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.HunterVillage;
import de.teamlapen.vampirism.util.LordTitles;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.SupporterManager;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.util.VampireVillage;
import de.teamlapen.vampirism.world.biome.OverworldModifications;
import de.teamlapen.vampirism.world.biome.VampirismBiomes;
import de.teamlapen.vampirism.world.gen.VampirismFeatures;
import de.teamlapen.vampirism.world.gen.VanillaStructureModifications;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vampirism")
public class VampirismMod {
    public static final AbstractPacketDispatcher dispatcher = new ModPacketDispatcher();
    public static final CreativeModeTab creativeTab = new CreativeModeTab("vampirism"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModItems.vampire_fang);
        }
    };
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MobCategory HUNTER_CREATURE_TYPE = MobCategory.create((String)"vampirism_hunter", (String)"vampirism_hunter", (int)25, (boolean)false, (boolean)false, (int)128);
    private static final MobCategory VAMPIRE_CREATURE_TYPE = MobCategory.create((String)"vampirism_vampire", (String)"vampirism_vampire", (int)30, (boolean)false, (boolean)false, (int)128);
    private static final MobType VAMPIRE_CREATURE_ATTRIBUTE = new MobType();
    public static VampirismMod instance;
    public static IProxy proxy;
    public static boolean inDev;
    public static boolean inDataGen;
    public final ModCompatLoader modCompatLoader = new ModCompatLoader();
    private final RegistryManager registryManager;
    private VersionChecker.VersionInfo versionInfo;

    public static boolean isRealism() {
        return false;
    }

    public VampirismMod() {
        instance = this;
        this.checkEnv();
        Optional opt = ModList.get().getModContainerById("vampirism");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherData);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapabilities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::finalizeConfiguration);
        VampirismFeatures.register(FMLJavaModLoadingContext.get().getModEventBus());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientEventHandler::onModelBakeEvent);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntitiesRender::onRegisterRenderers);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntitiesRender::onRegisterLayers);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEntitiesRender::onAddLayers);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ModBlocksRender::registerBlockEntityRenderers);
        });
        VampirismConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.addModCompats();
        this.registryManager = new RegistryManager();
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.register((Object)this.registryManager);
        MinecraftForge.EVENT_BUS.register(Permissions.class);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, VampirismBiomes::onBiomeLoadingEventAdditions);
        this.prepareAPI();
        if (OptifineHandler.isOptifineLoaded()) {
            LOGGER.warn("Using Optifine. Expect visual glitches and reduces blood vision functionality if using shaders.");
        }
        VanillaStructureModifications.createJigsawPool();
    }

    public VersionChecker.VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @SubscribeEvent
    public void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        SkillTreeManager.getInstance().getSkillTree().initRootSkills();
        event.addListener((PreparableReloadListener)SkillTreeManager.getInstance());
        event.addListener((PreparableReloadListener)BloodValues.ENTITIES);
        event.addListener((PreparableReloadListener)BloodValues.ITEMS);
        event.addListener((PreparableReloadListener)BloodValues.FLUIDS);
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        ModCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
    }

    @SubscribeEvent
    public void onServerStart(ServerStartingEvent event) {
        for (BloodValueLoaderDynamic loader : BloodValues.getDynamicLoader()) {
            loader.onServerStarting(event.getServer());
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        int missing = ModLootTables.checkAndResetInsertedAll();
        if (missing > 0) {
            LOGGER.warn("LootTables Failed to inject {} loottables", (Object)missing);
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        for (BloodValueLoaderDynamic loader : BloodValues.getDynamicLoader()) {
            loader.onServerStopping();
        }
    }

    private void addModCompats() {
    }

    private void checkEnv() {
        String launchTarget = System.getProperty("vampirism_target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
        if (launchTarget != null && launchTarget.contains("data")) {
            inDataGen = true;
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        this.onInitStep(IInitListener.Step.ENQUEUE_IMC, (ParallelDispatchEvent)event);
        HelperRegistry.registerPlayerEventReceivingCapability(VampirePlayer.CAP, VampirePlayer.class);
        HelperRegistry.registerPlayerEventReceivingCapability(HunterPlayer.CAP, HunterPlayer.class);
        HelperRegistry.registerSyncableEntityCapability(ExtendedCreature.CAP, REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.class);
        HelperRegistry.registerSyncablePlayerCapability(VampirePlayer.CAP, REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(HunterPlayer.CAP, REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.class);
        HelperRegistry.registerSyncablePlayerCapability(FactionPlayerHandler.CAP, REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.class);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IExtendedCreatureVampirism.class);
        event.register(IFactionPlayerHandler.class);
        event.register(IHunterPlayer.class);
        event.register(IVampirePlayer.class);
        event.register(IVampirismWorld.class);
    }

    private void finalizeConfiguration(RegistryEvent<Block> event) {
        VampirismConfig.finalizeAndRegisterConfig();
    }

    private void finishAPI() {
        ((FactionRegistry)VampirismAPI.factionRegistry()).finish();
        ((VampirismEntityRegistry)VampirismAPI.entityRegistry()).finishRegistration();
    }

    private void gatherData(GatherDataEvent event) {
        this.registryManager.onGatherData(event);
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            TagGenerator.register(gen, event.getExistingFileHelper());
            gen.m_123914_((DataProvider)new LootTablesGenerator(gen));
            gen.m_123914_((DataProvider)new AdvancementGenerator(gen));
            gen.m_123914_((DataProvider)new RecipesGenerator(gen));
            gen.m_123914_((DataProvider)new SkillNodeGenerator(gen));
        }
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new BlockStateGenerator(event.getGenerator(), event.getExistingFileHelper()));
            gen.m_123914_((DataProvider)new ItemModelGenerator(event.getGenerator(), event.getExistingFileHelper()));
        }
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
        event.enqueueWork(OverworldModifications::addBiomesToOverworldUnsafe);
    }

    private void prepareAPI() {
        FactionRegistry factionRegistry = new FactionRegistry();
        SundamageRegistry sundamageRegistry = new SundamageRegistry();
        VampirismEntityRegistry biteableRegistry = new VampirismEntityRegistry();
        ActionManager actionManager = new ActionManager();
        SkillManager skillManager = new SkillManager();
        GeneralRegistryImpl generalRegistry = new GeneralRegistryImpl();
        ActionManagerEntity entityActionManager = new ActionManagerEntity();
        ExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry = new ExtendedBrewingRecipeRegistry();
        biteableRegistry.setDefaultConvertingHandlerCreator(DefaultConvertingHandler::new);
        VampirismAPI.setUpRegistries(factionRegistry, sundamageRegistry, biteableRegistry, actionManager, skillManager, generalRegistry, entityActionManager, extendedBrewingRecipeRegistry);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> proxy::setupAPIClient);
        VReference.VAMPIRE_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.VAMPIRE_PLAYER_KEY, IVampirePlayer.class, () -> VampirePlayer.CAP).color(Color.MAGENTA_DARK.getRGB()).chatColor(ChatFormatting.DARK_PURPLE).name("text.vampirism.vampire").namePlural("text.vampirism.vampires").hostileTowardsNeutral().highestLevel(14).lordLevel(5).lordTitle(LordTitles::getVampireTitle).village(VampireVillage::vampireVillage).refinementItems(VampireRefinementItem::getItemForType).register();
        VReference.HUNTER_FACTION = VampirismAPI.factionRegistry().createPlayableFaction(REFERENCE.HUNTER_PLAYER_KEY, IHunterPlayer.class, () -> HunterPlayer.CAP).color(Color.BLUE.getRGB()).chatColor(ChatFormatting.BLUE).name("text.vampirism.hunter").namePlural("text.vampirism.hunters").highestLevel(14).lordLevel(5).lordTitle(LordTitles::getHunterTitle).village(HunterVillage::hunterVillage).register();
        VReference.HUNTER_CREATURE_TYPE = HUNTER_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_TYPE = VAMPIRE_CREATURE_TYPE;
        VReference.VAMPIRE_CREATURE_ATTRIBUTE = VAMPIRE_CREATURE_ATTRIBUTE;
        VReference.vision_nightVision = VampirismAPI.vampireVisionRegistry().registerVision("nightVision", new NightVision());
        VReference.vision_bloodVision = VampirismAPI.vampireVisionRegistry().registerVision("bloodVision", new BloodVision());
        VampirismAPI.onSetupComplete();
    }

    private void processIMC(InterModProcessEvent event) {
        this.finishAPI();
        this.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
        IMCHandler.handleInterModMessage(event);
        if (inDev) {
            Tests.runBackgroundTests();
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        dispatcher.registerPackets();
        this.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        proxy.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        this.versionInfo = (Boolean)VampirismConfig.COMMON.versionCheck.get() == false ? new VersionChecker.VersionInfo(REFERENCE.VERSION) : VersionChecker.executeVersionCheck("https://maxanier.de/projects/vampirism/versions.json", REFERENCE.VERSION, !inDev && (Boolean)VampirismConfig.COMMON.collectStats.get() != false);
        GeneralEventHandler eventHandler = new GeneralEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ModPlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModEntityEventHandler());
        MinecraftForge.EVENT_BUS.addListener(ModLootTables::onLootLoad);
        SupporterManager.getInstance().initAsync();
        VampireBookManager.getInstance().init();
        VampirismEntitySelectors.registerSelectors();
        event.enqueueWork(TerraBlenderCompat::registerBiomeProviderIfPresentUnsafe);
        VanillaStructureModifications.addVillageStructures(BuiltinRegistries.f_206379_);
    }

    private void setupClient(FMLClientSetupEvent event) {
        this.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    private void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        this.registryManager.onInitStep(step, event);
        proxy.onInitStep(step, event);
        this.modCompatLoader.onInitStep(step, event);
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        inDev = false;
        inDataGen = false;
    }
}

