/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.modcompat.IntegrationsNotifier;
import de.teamlapen.vampirism.network.BloodValuePacket;
import de.teamlapen.vampirism.network.SkillTreePacket;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.lang.reflect.Array;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneralEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public void onAttachCapabilityWorld(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(REFERENCE.WORLD_CAP_KEY, VampirismWorld.createNewCapability((Level)event.getObject()));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean isAdminLikePlayer;
        VersionChecker.VersionInfo versionInfo = VampirismMod.instance.getVersionInfo();
        if (!versionInfo.isChecked()) {
            LOGGER.warn("Version check is not finished yet");
        }
        Player player = event.getPlayer();
        boolean bl = isAdminLikePlayer = !ServerLifecycleHooks.getCurrentServer().m_6982_() || UtilLib.isPlayerOp(player);
        if (((Boolean)VampirismConfig.COMMON.versionCheck.get()).booleanValue() && versionInfo.isNewVersionAvailable() && (isAdminLikePlayer || player.m_21187_().nextInt(5) == 0) && player.m_21187_().nextInt(4) == 0) {
            VersionChecker.Version newVersion = versionInfo.getNewVersion();
            player.m_6352_((Component)new TranslatableComponent("text.vampirism.outdated", new Object[]{versionInfo.getCurrentVersion().name, newVersion.name}), Util.f_137441_);
            MutableComponent download = new TranslatableComponent("text.vampirism.update_message.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? versionInfo.getHomePage() : newVersion.getUrl())).setUnderlined(Boolean.valueOf(true)).m_131157_(ChatFormatting.BLUE));
            MutableComponent changelog = new TranslatableComponent("text.vampirism.update_message.changelog").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism changelog")).setUnderlined(Boolean.valueOf(true)));
            MutableComponent modpage = new TranslatableComponent("text.vampirism.update_message.modpage").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, versionInfo.getHomePage())).setUnderlined(Boolean.valueOf(true)).m_131157_(ChatFormatting.BLUE));
            player.m_6352_((Component)new TextComponent("").m_7220_((Component)download).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)changelog).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)modpage), Util.f_137441_);
        }
        if (isAdminLikePlayer) {
            List<String> mods = IntegrationsNotifier.shouldNotifyAboutIntegrations();
            if (!mods.isEmpty()) {
                player.m_6352_((Component)new TranslatableComponent("text.vampirism.integrations_available.first"), Util.f_137441_);
                player.m_6352_((Component)new TextComponent(ChatFormatting.BLUE + ChatFormatting.ITALIC.toString() + StringUtils.join(mods, (String)", ") + ChatFormatting.RESET), Util.f_137441_);
                player.m_6352_((Component)new TranslatableComponent("text.vampirism.integrations_available.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/vampirism-integrations")).setUnderlined(Boolean.valueOf(true))), Util.f_137441_);
            }
            if (!ModList.get().isLoaded("guideapi_vp") && ((Boolean)VampirismConfig.SERVER.infoAboutGuideAPI.get()).booleanValue()) {
                player.m_6352_((Component)new TranslatableComponent("text.vampirism.guideapi_available.first"), Util.f_137441_);
                player.m_6352_((Component)new TranslatableComponent("text.vampirism.guideapi_available.download").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/guide-api-village-and-pillage")).setUnderlined(Boolean.valueOf(true))), Util.f_137441_);
                VampirismConfig.SERVER.infoAboutGuideAPI.set((Object)false);
            }
        }
        if (player instanceof ServerPlayer) {
            VampirismMod.dispatcher.sendTo(new SkillTreePacket(VampirismMod.proxy.getSkillTree(false).getCopy()), (ServerPlayer)player);
        }
        Pair[] bloodValues = (Pair[])Array.newInstance(Pair.class, 3);
        bloodValues[0] = new Pair(((VampirismEntityRegistry)VampirismAPI.entityRegistry()).getBloodValues(), (Object)((VampirismEntityRegistry)VampirismAPI.entityRegistry()).getBloodMultiplier());
        bloodValues[1] = new Pair(BloodConversionRegistry.getItemValues(), (Object)BloodConversionRegistry.getItemMultiplier());
        bloodValues[2] = new Pair(BloodConversionRegistry.getFluidValues(), (Object)BloodConversionRegistry.getFluidDivider());
        if (player instanceof ServerPlayer) {
            VampirismMod.dispatcher.sendTo(new BloodValuePacket(bloodValues), (ServerPlayer)player);
        }
        FactionPlayerHandler.getOpt(player).ifPresent(FactionPlayerHandler::onPlayerLoggedIn);
        if (player instanceof ServerPlayer && !((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), Permissions.GENERAL_CHECK, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
            player.m_6352_((Component)new TextComponent("[" + ChatFormatting.DARK_PURPLE + "Vampirism" + ChatFormatting.RESET + "] It seems like the permission plugin used is not properly set up. Make sure all players have 'vampirism.*' for the mod to work (or at least '" + Permissions.GENERAL_CHECK.getNodeName() + "' to suppress this warning)."), Util.f_137441_);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer()).tick();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof Level) {
            VampirismWorld.getOpt((Level)event.getWorld()).ifPresent(VampirismWorld::clearCaches);
        }
    }
}

