/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.util;

import java.util.Arrays;

public class Color {
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color MAGENTA = new Color(255, 0, 255);
    public static final Color MAGENTA_DARK = new Color(124, 0, 124);
    public static final Color GRAY = new Color(128, 128, 128);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color BLACK = new Color(0, 0, 0);
    private final int value;
    private final float[] frgbvalue;

    public Color(int red, int green, int blue, int alpha) {
        this(Color.getRgb(red, green, blue, alpha), true);
    }

    public Color(int rgb) {
        this(rgb, false);
    }

    public Color(int rgb, boolean hasAlpha) {
        if (!hasAlpha) {
            rgb = 0xFF000000 | rgb;
        }
        this.value = rgb;
        this.frgbvalue = new float[4];
        this.frgbvalue[0] = (float)this.getRed() / 255.0f;
        this.frgbvalue[1] = (float)this.getGreen() / 255.0f;
        this.frgbvalue[2] = (float)this.getBlue() / 255.0f;
        this.frgbvalue[3] = (float)this.getAlpha() / 255.0f;
    }

    public Color(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public Color(float red, float green, float blue, float alpha) {
        this((int)red * 255, (int)green * 255, (int)blue * 255, (int)alpha * 255);
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public static int getRgb(int red, int green, int blue) {
        return Color.getRgb(red, green, blue, 255);
    }

    public int getRed() {
        return this.value >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.value & 0xFF;
    }

    public int getAlpha() {
        return this.value >> 24 & 0xFF;
    }

    public float getRedF() {
        return this.frgbvalue[0];
    }

    public float getGreenF() {
        return this.frgbvalue[1];
    }

    public float getBlueF() {
        return this.frgbvalue[2];
    }

    public float getAlphaF() {
        return this.frgbvalue[3];
    }

    public int getRGB() {
        return this.value;
    }

    public float[] getRGBComponents() {
        return Arrays.copyOf(this.frgbvalue, 4);
    }

    public float[] getRGBColorComponents() {
        return Arrays.copyOf(this.frgbvalue, 3);
    }

    public static int getRgb(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return this.value == color.value;
    }

    public int hashCode() {
        return this.value;
    }
}

