/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import de.teamlapen.lib.lib.util.ItemStackUtil;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryHelper {
    public static ItemStack checkItems(Container inventory, Item[] items, int[] amounts, BiPredicate<Item, Item> compareFunction) {
        if (inventory.m_6643_() < amounts.length || items.length != amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack and amount value for each item");
        }
        for (int i = 0; i < items.length; ++i) {
            int actual;
            ItemStack stack = inventory.m_8020_(i);
            int n = actual = !stack.m_41619_() && compareFunction.test(stack.m_41720_(), items[i]) ? stack.m_41613_() : 0;
            if (actual >= amounts[i]) continue;
            return new ItemStack((ItemLike)items[i], amounts[i] - actual);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack checkItems(Container inventory, Item[] items, int[] amounts) {
        return InventoryHelper.checkItems(inventory, items, amounts, Object::equals);
    }

    public static void removeItems(Container inventory, int[] amounts) {
        if (inventory.m_6643_() < amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack value for each amount");
        }
        for (int i = 0; i < amounts.length; ++i) {
            inventory.m_7407_(i, amounts[i]);
        }
    }

    @Nonnull
    public static Optional<Pair<IItemHandler, BlockEntity>> tryGetItemHandler(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        BlockEntity tile;
        BlockState state = world.m_8055_(pos);
        if (state.m_155947_() && (tile = world.m_7702_(pos)) != null) {
            return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(capability -> ImmutablePair.of((Object)capability, (Object)tile));
        }
        return Optional.empty();
    }

    public static void writeInventoryToTag(CompoundTag tag, SimpleContainer inventory) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            listTag.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_("inventory", (Tag)listTag);
    }

    public static void readInventoryFromTag(CompoundTag tag, SimpleContainer inventory) {
        ListTag list = tag.m_128437_("inventory", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            inventory.m_19173_(itemstack);
        }
    }

    public static boolean canMergeStacks(ItemStack stack1, ItemStack stack2, int invLimit) {
        return !stack1.m_41619_() && ItemStackUtil.stackEqualExact(stack1, stack2) && stack1.m_41753_() && stack1.m_41613_() < stack1.m_41741_() && stack1.m_41613_() < invLimit;
    }

    public static void addStackToSlotWithoutCheck(Container inv, int slot, ItemStack addStack) {
        int newCount = addStack.m_41613_();
        ItemStack existingStack = inv.m_8020_(slot);
        int oldCount = existingStack.m_41613_();
        int addAmount = Math.min(newCount, Math.min(inv.m_6893_() - oldCount, addStack.m_41741_() - oldCount));
        if (addAmount == 0) {
            return;
        }
        if (existingStack.m_41619_()) {
            existingStack = addStack.m_41777_();
            existingStack.m_41764_(0);
            if (addStack.m_41782_()) {
                existingStack.m_41751_(addStack.m_41783_().m_6426_());
            }
            inv.m_6836_(slot, existingStack);
        }
        existingStack.m_41769_(addAmount);
        addStack.m_41774_(addAmount);
    }

    public static int getFirstSuitableSlotToAdd(NonNullList<ItemStack> inventory, ItemStack stack, int invLimit) {
        return InventoryHelper.getFirstSuitableSlotToAdd(inventory, inventory.size(), stack, invLimit);
    }

    public static int getFirstSuitableSlotToAdd(NonNullList<ItemStack> inventory, int inventorySize, ItemStack stack, int invLimit) {
        int i;
        assert (inventory.size() >= inventorySize);
        if (!stack.m_41768_() && stack.m_41753_()) {
            for (i = 0; i < inventorySize; ++i) {
                if (!InventoryHelper.canMergeStacks((ItemStack)inventory.get(i), stack, invLimit)) continue;
                return i;
            }
        }
        for (i = 0; i < inventorySize; ++i) {
            if (!((ItemStack)inventory.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public static boolean removeItemFromInventory(Container inventory, ItemStack item) {
        int i = item.m_41613_();
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack itemstack = inventory.m_8020_(j);
            if (!itemstack.m_41720_().equals(item.m_41720_())) continue;
            if (itemstack.m_41613_() >= i) {
                itemstack.m_41774_(i);
                return true;
            }
            int l = itemstack.m_41613_();
            itemstack.m_41774_(i);
            i -= l;
        }
        return i <= 0;
    }

    public static ItemStack getFirst(Container inventory, Item set) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (set != itemstack.m_41720_() || itemstack.m_41613_() <= 0) continue;
            return itemstack;
        }
        return null;
    }
}

