/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class BasicAreaParticleCloud
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.m_135353_(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ParticleOptions> PARTICLE = SynchedEntityData.m_135353_(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final EntityDataAccessor<Float> SPAWN_RATE = SynchedEntityData.m_135353_(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(BasicAreaParticleCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int duration = 60;
    private int waitTime = 0;
    private float radiusPerTick = 0.0f;

    public BasicAreaParticleCloud(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.f_19794_ = true;
        this.setRadius(3.0f);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setColor(int colorIn) {
        this.m_20088_().m_135381_(COLOR, (Object)colorIn);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.m_20088_().m_135370_(PARTICLE);
    }

    public void setParticle(ParticleOptions particleData) {
        this.m_20088_().m_135381_(PARTICLE, (Object)particleData);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        this.f_19815_ = new EntityDimensions(radius * 2.0f, this.m_20206_(), this.f_19815_.f_20379_);
        this.m_6034_(d0, d1, d2);
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(radius));
        }
    }

    public float getSpawnRate() {
        return ((Float)this.m_20088_().m_135370_(SPAWN_RATE)).floatValue();
    }

    public void setSpawnRate(float rate) {
        this.m_20088_().m_135381_(SPAWN_RATE, (Object)Float.valueOf(rate));
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public boolean m_20223_(@Nonnull CompoundTag compound) {
        return false;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public boolean m_20086_(@Nonnull CompoundTag compound) {
        return false;
    }

    public void setHeight(float height) {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        this.f_19815_ = new EntityDimensions(this.getRadius() * 2.0f, height, this.f_19815_.f_20379_);
        this.m_6034_(d0, d1, d2);
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(HEIGHT, (Object)Float.valueOf(height));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        float radius = this.getRadius();
        if (this.f_19853_.f_46443_) {
            ParticleOptions particle = this.getParticle();
            float amount = (float)(Math.PI * (double)radius * (double)radius) * this.getSpawnRate();
            int i = 0;
            while ((float)i < amount) {
                float phi = this.f_19796_.nextFloat() * (float)Math.PI * 2.0f;
                float r = Mth.m_14116_((float)this.f_19796_.nextFloat()) * radius;
                float dx = Mth.m_14089_((float)phi) * r;
                float dz = Mth.m_14031_((float)phi) * r;
                float dy = this.f_19796_.nextFloat() * this.m_20206_();
                if (particle.m_6012_() == ParticleTypes.f_123811_) {
                    int rgb = this.getColor();
                    int cr = rgb >> 16 & 0xFF;
                    int cg = rgb >> 8 & 0xFF;
                    int cb = rgb & 0xFF;
                    this.f_19853_.m_7106_(particle, this.m_20185_() + (double)dx, this.m_20186_() + (double)dy, this.m_20189_() + (double)dz, (double)((float)cr / 255.0f), (double)((float)cg / 255.0f), (double)((float)cb / 255.0f));
                } else {
                    this.f_19853_.m_7106_(particle, this.m_20185_() + (double)dx, this.m_20186_() + (double)dy, this.m_20189_() + (double)dz, (0.5 - this.f_19796_.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.f_19796_.nextDouble()) * 0.15);
                }
                ++i;
            }
        } else {
            if (this.f_19797_ >= this.waitTime + this.duration) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (this.f_19797_ < this.waitTime) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.3f) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                this.setRadius(radius);
            }
        }
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(COLOR, (Object)0);
        this.m_20088_().m_135372_(RADIUS, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(HEIGHT, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(PARTICLE, (Object)ParticleTypes.f_123811_);
        this.m_20088_().m_135372_(SPAWN_RATE, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
    }
}

