/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import de.teamlapen.lib.lib.config.BloodValueLoader;
import de.teamlapen.lib.lib.util.LogUtil;
import de.teamlapen.lib.lib.util.ResourceLocationTypeAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodValueLoaderDynamic
extends BloodValueLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<BloodValueLoaderDynamic> LOADER = Lists.newArrayList();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(new TypeToken<ResourceLocation>(){}.getType(), (Object)new ResourceLocationTypeAdapter()).create();
    private final Consumer<Map<ResourceLocation, Integer>> addCalculatedValues;
    private final Supplier<Map<ResourceLocation, Integer>> getCalculatedValues;
    private final String name;
    private final String modId;
    private final LevelResource worldSubFolder;
    @Nullable
    private File bloodValueWorldFile;

    private static void writeBloodValues(Writer w, Map<ResourceLocation, Integer> values, String comment) throws IOException, JsonIOException {
        try (BufferedWriter bw = new BufferedWriter(w);){
            bw.write(35);
            bw.write(comment);
            bw.newLine();
            bw.write(GSON.toJson(values));
            bw.flush();
        }
    }

    private static Optional<Map<ResourceLocation, Integer>> loadBloodValues(Reader r) throws IOException, JsonSyntaxException {
        try (BufferedReader br = new BufferedReader(r);){
            br.readLine();
            Type s = new TypeToken<Map<ResourceLocation, Integer>>(){}.getType();
            Optional<Map<ResourceLocation, Integer>> optional = Optional.ofNullable((Map)GSON.fromJson((Reader)br, s));
            return optional;
        }
    }

    public static List<BloodValueLoaderDynamic> getDynamicBloodLoader() {
        return ImmutableList.copyOf(LOADER);
    }

    public BloodValueLoaderDynamic(@Nonnull String modIdIn, @Nonnull String nameIn, @Nonnull BiConsumer<Map<ResourceLocation, Integer>, Integer> consumerIn, @Nullable ResourceLocation multiplierNameIn, @Nonnull Consumer<Map<ResourceLocation, Integer>> addCalculatedValuesIn, @Nonnull Supplier<Map<ResourceLocation, Integer>> getCalculatedValuesIn) {
        super(nameIn, consumerIn, multiplierNameIn);
        this.addCalculatedValues = addCalculatedValuesIn;
        this.getCalculatedValues = getCalculatedValuesIn;
        this.name = nameIn;
        this.modId = modIdIn;
        this.worldSubFolder = new LevelResource(this.modId);
        LOADER.add(this);
    }

    public void onServerStarting(MinecraftServer server) {
        this.bloodValueWorldFile = new File(server.m_129843_(this.worldSubFolder).toFile(), "calculated-" + this.name + "-blood-values.txt");
        if (this.bloodValueWorldFile.exists()) {
            this.loadDynamicBloodValues(this.bloodValueWorldFile);
        }
    }

    public void onServerStopping() {
        if (this.bloodValueWorldFile != null) {
            this.saveDynamicBloodValues(this.bloodValueWorldFile);
        } else {
            LOGGER.warn("Can't save {} blood values. File does not exist", (Object)this.name);
        }
    }

    private void loadDynamicBloodValues(File f) {
        try {
            Optional<Map<ResourceLocation, Integer>> saved = BloodValueLoaderDynamic.loadBloodValues(new InputStreamReader(new FileInputStream(f)));
            saved.ifPresent(this.addCalculatedValues);
        }
        catch (JsonIOException | IOException e) {
            LOGGER.error(LogUtil.CONFIG, "Could not read saved " + this.name + " blood values from world from file " + f, e);
        }
    }

    private void saveDynamicBloodValues(File f) {
        Map<ResourceLocation, Integer> values = this.getCalculatedValues.get();
        if (!f.exists() && values.isEmpty()) {
            return;
        }
        if (!f.exists() && f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        try {
            BloodValueLoaderDynamic.writeBloodValues(new FileWriter(f), values, "Dynamically calculated blood values - DON'T EDIT");
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.warn(LogUtil.CONFIG, "Could not write calculated " + this.name + " values to file", e);
        }
    }
}

