/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScrollableListWithDummyWidget<T>
extends ScrollableListWidget<T> {
    @Nonnull
    private final ItemCreator<T> itemCreator;
    @Nullable
    private ListItem<T> dummyItem;

    public ScrollableListWithDummyWidget(int xPos, int yPos, int width, int height, int itemHeight, Supplier<Collection<T>> baseValueSupplier, @Nonnull ItemCreator<T> itemSupplier) {
        super(xPos, yPos, width, height, itemHeight, baseValueSupplier, (T item, ScrollableListWidget<T> list) -> itemSupplier.apply(item, (ScrollableListWithDummyWidget)list, false));
        this.itemCreator = itemSupplier;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.dummyItem != null) {
            this.listItems.stream().filter(l -> l.item.equals(this.dummyItem.item)).findAny().ifPresent(a -> this.addItem(this.dummyItem, a));
        }
    }

    protected void clickItem(@Nonnull ListItem<T> listItem) {
        boolean flag = false;
        if (this.dummyItem != null) {
            flag = listItem.item.equals(this.dummyItem.item);
            this.removeItem(this.dummyItem);
            this.dummyItem = null;
        }
        if (!flag) {
            this.dummyItem = this.itemCreator.apply(listItem.item, this, true);
            this.addItem(this.dummyItem, listItem);
        }
    }

    @FunctionalInterface
    public static interface ItemCreator<T> {
        public ListItem<T> apply(T var1, ScrollableListWithDummyWidget<T> var2, boolean var3);
    }

    public static abstract class ListItem<T>
    extends ScrollableListWidget.ListItem<T> {
        protected final boolean isDummy;

        public ListItem(T item, ScrollableListWithDummyWidget<T> list, boolean isDummy) {
            super(item, list);
            this.isDummy = isDummy;
        }

        @Override
        public boolean onClick(double mouseX, double mouseY) {
            if (this.isDummy) {
                return this.onDummyClick(mouseX, mouseY);
            }
            ((ScrollableListWithDummyWidget)this.list).clickItem(this);
            return true;
        }

        public boolean onDummyClick(double mouseX, double mouseY) {
            return super.onClick(mouseX, mouseY);
        }

        @Override
        public void render(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            if (this.isDummy) {
                this.renderDummy(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, partialTicks, zLevel);
            } else {
                this.renderItem(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, partialTicks, zLevel);
            }
        }

        public abstract void renderDummy(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9, float var10);

        public abstract void renderDummyToolTip(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9);

        public abstract void renderItem(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9, float var10);

        public abstract void renderItemToolTip(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9);

        @Override
        public void renderToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float zLevel) {
            if (this.isDummy) {
                this.renderDummyToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, zLevel);
            } else {
                this.renderItemToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, mouseX, mouseY, zLevel);
            }
        }
    }
}

