/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.tuple.Pair;

public class ScrollableArrayTextComponentList
extends ScrollableListWidget<Pair<Integer, Component>> {
    private static Collection<Pair<Integer, Component>> getItems(Supplier<Component[]> baseValueSupplier) {
        ArrayList<Pair<Integer, Component>> items = new ArrayList<Pair<Integer, Component>>();
        Component[] baseValues = baseValueSupplier.get();
        for (int i = 0; i < baseValues.length; ++i) {
            items.add((Pair<Integer, Component>)Pair.of((Object)i, (Object)baseValues[i]));
        }
        return items;
    }

    private static Supplier<Component[]> createTextArray(int amount, BaseComponent baseName) {
        Component[] array = new Component[amount];
        for (int i = 0; i < array.length; ++i) {
            array[i] = baseName.m_6879_().m_130946_(" " + (i + 1));
        }
        return () -> array;
    }

    public ScrollableArrayTextComponentList(int xPos, int yPos, int width, int height, int itemHeight, @Nonnull Supplier<Component[]> baseValueSupplier, @Nonnull Consumer<Integer> buttonPressed) {
        super(xPos, yPos, width, height, itemHeight, () -> ScrollableArrayTextComponentList.getItems(baseValueSupplier), (T item, ScrollableListWidget<T> list) -> new TextComponentItem(item, list, buttonPressed));
    }

    public ScrollableArrayTextComponentList(int xPos, int yPos, int width, int height, int itemHeight, int valueAmount, BaseComponent baseName, @Nonnull Consumer<Integer> buttonPressed) {
        super(xPos, yPos, width, height, itemHeight, () -> ScrollableArrayTextComponentList.getItems(ScrollableArrayTextComponentList.createTextArray(valueAmount, baseName)), (T item, ScrollableListWidget<T> list) -> new TextComponentItem(item, list, buttonPressed), (Component)baseName);
    }

    public ScrollableArrayTextComponentList(int xPos, int yPos, int width, int height, int itemHeight, int valueAmount, BaseComponent baseName, @Nonnull Consumer<Integer> buttonPressed, @Nullable BiConsumer<Integer, Boolean> onHover) {
        super(xPos, yPos, width, height, itemHeight, () -> ScrollableArrayTextComponentList.getItems(ScrollableArrayTextComponentList.createTextArray(valueAmount, baseName)), (T item, ScrollableListWidget<T> list) -> new TextComponentItem(item, list, buttonPressed, onHover), (Component)baseName);
    }

    public ScrollableArrayTextComponentList scrollSpeed(double scrollSpeed) {
        return (ScrollableArrayTextComponentList)super.scrollSpeed(scrollSpeed);
    }

    public static class TextComponentItem<T>
    extends ScrollableListWidget.ListItem<Pair<T, Component>> {
        @Nonnull
        private final Consumer<T> onClick;
        @Nullable
        private final BiConsumer<T, Boolean> onHover;
        private boolean hovered;

        public TextComponentItem(@Nonnull Pair<T, Component> item, @Nonnull ScrollableListWidget<Pair<T, Component>> list, @Nonnull Consumer<T> onClick) {
            super(item, list);
            this.onClick = onClick;
            this.onHover = null;
        }

        public TextComponentItem(@Nonnull Pair<T, Component> item, @Nonnull ScrollableListWidget<Pair<T, Component>> list, @Nonnull Consumer<T> onClick, @Nullable BiConsumer<T, Boolean> onHover) {
            super(item, list);
            this.onClick = onClick;
            this.onHover = onHover;
        }

        @Override
        public boolean onClick(double mouseX, double mouseY) {
            this.onClick.accept(((Pair)this.item).getLeft());
            return true;
        }

        @Override
        public void render(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.render(matrixStack, x - 1, y, listWidth + 1, listHeight, itemHeight, mouseX, mouseY, partialTicks, zLevel);
            Font font = Minecraft.m_91087_().f_91062_;
            int width = font.m_92852_((FormattedText)((Pair)this.item).getRight());
            if (width > listWidth) {
                width = listWidth;
            }
            Minecraft.m_91087_().f_91062_.m_92763_(matrixStack, (Component)((Pair)this.item).getRight(), (float)x + (float)listWidth / 2.0f - (float)width / 2.0f, (float)(y + 7), -1);
            if (this.onHover != null) {
                boolean newHovered;
                boolean bl = newHovered = mouseX >= x && mouseX < x + listWidth && mouseY >= y && mouseY < y + itemHeight;
                if (newHovered != this.hovered) {
                    this.hovered = newHovered;
                    this.onHover(this.hovered);
                }
            }
        }

        protected void onHover(boolean hovered) {
            this.onHover.accept(((Pair)this.item).getLeft(), hovered);
        }
    }
}

