/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import io.netty.util.internal.ConcurrentSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelperRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncablePlayerCaps = new ConcurrentHashMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>>();
    private static Map<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncableEntityCaps = new ConcurrentHashMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>>();
    private static Set<Capability<IPlayerEventListener>> playerEventListenerCaps = new ConcurrentSet();
    private static Capability<IPlayerEventListener>[] playerEventListenerCapsFinal;
    private static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncablePlayerCapsFinal;
    private static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> syncableEntityCapsFinal;

    static Capability<IPlayerEventListener>[] getEventListenerCaps() {
        return playerEventListenerCapsFinal;
    }

    public static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> getSyncablePlayerCaps() {
        return syncablePlayerCapsFinal;
    }

    public static ImmutableMap<ResourceLocation, Capability<ISyncable.ISyncableEntityCapabilityInst>> getSyncableEntityCaps() {
        return syncableEntityCapsFinal;
    }

    public static void registerSyncableEntityCapability(Capability<ISyncable.ISyncableEntityCapabilityInst> capability, ResourceLocation key, Class<? extends ISyncable.ISyncableEntityCapabilityInst> clz) {
        if (syncableEntityCaps == null) {
            LOGGER.error("You have to register the syncable property {} ({}) during InterModEnqueueEvent", clz, capability);
            return;
        }
        syncableEntityCaps.put(key, capability);
    }

    public static void registerSyncablePlayerCapability(Capability<ISyncable.ISyncableEntityCapabilityInst> capability, ResourceLocation key, Class<? extends ISyncable.ISyncableEntityCapabilityInst> clz) {
        if (syncablePlayerCaps == null) {
            LOGGER.error("You have to register the syncable property {} ({}) before post init", clz, capability);
            return;
        }
        syncablePlayerCaps.put(key, capability);
    }

    public static void registerPlayerEventReceivingCapability(Capability<IPlayerEventListener> capability, Class<? extends IPlayerEventListener> clz) {
        if (playerEventListenerCaps == null) {
            LOGGER.error("You have to register PlayerEventReceiver BEFORE post init. (" + capability + ")");
        } else {
            playerEventListenerCaps.add(capability);
        }
    }

    static void finish() {
        syncableEntityCapsFinal = ImmutableMap.copyOf(syncableEntityCaps);
        syncableEntityCaps = null;
        syncablePlayerCapsFinal = ImmutableMap.copyOf(syncablePlayerCaps);
        syncablePlayerCaps = null;
        playerEventListenerCapsFinal = playerEventListenerCaps.toArray(new Capability[0]);
        playerEventListenerCaps = null;
    }
}

