/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.common.misc;

import at.petrak.paucal.PaucalConfig;
import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.common.Contributors;
import at.petrak.paucal.common.ModStats;
import at.petrak.paucal.xplat.IXplatAbstractions;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PatPat {
    public static InteractionResult onPat(Player player, Level world, InteractionHand hand, Entity entity, @Nullable EntityHitResult hitResult) {
        if (!PaucalConfig.common().allowPats()) {
            return InteractionResult.PASS;
        }
        if (player.m_21120_(hand).m_41619_() && player.m_20163_() && hand == InteractionHand.MAIN_HAND && entity instanceof Player) {
            Player target = (Player)entity;
            Level level = player.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)level;
                Vec3 pos = target.m_146892_();
                sworld.m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
            } else {
                player.m_6674_(hand);
            }
            PatPat.tryPlayPatSound(target.m_142081_(), target.m_146892_(), player, world);
            player.m_36220_(ModStats.PLAYERS_PATTED);
            target.m_36220_(ModStats.HEADPATS_GOTTEN);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean tryPlayPatSound(UUID pattee, Vec3 patteePos, @Nullable Player patter, Level world) {
        ResourceLocation soundKey;
        SoundEvent sound;
        String soundKeyStr;
        Contributor contributor = Contributors.getContributor(pattee);
        if (contributor != null && (soundKeyStr = contributor.getString("paucal:patSound")) != null && (sound = IXplatAbstractions.INSTANCE.getSoundByID(soundKey = new ResourceLocation(soundKeyStr))) != null) {
            Float pitchCenter = Objects.requireNonNullElse(contributor.getFloat("paucal:patPitchCenter"), Float.valueOf(1.0f));
            Float pitchVariance = Objects.requireNonNullElse(contributor.getFloat("paucal:patPitchVariance"), Float.valueOf(0.5f));
            world.m_6263_(patter, patteePos.f_82479_, patteePos.f_82480_, patteePos.f_82481_, sound, SoundSource.PLAYERS, 1.0f, pitchCenter.floatValue() + (float)(Math.random() - 0.5) * pitchVariance.floatValue());
            return true;
        }
        return false;
    }
}

