/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.common.blocks.behavior.HexComposting;
import at.petrak.hexcasting.common.blocks.behavior.HexStrippables;
import at.petrak.hexcasting.common.casting.RegisterPatterns;
import at.petrak.hexcasting.common.casting.operators.spells.great.OpFlight;
import at.petrak.hexcasting.common.command.PatternResLocArgument;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemJewelerHammer;
import at.petrak.hexcasting.common.items.ItemLens;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexCommands;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexLootFunctions;
import at.petrak.hexcasting.common.lib.HexParticles;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.common.misc.AkashicTreeGrower;
import at.petrak.hexcasting.common.misc.Brainsweeping;
import at.petrak.hexcasting.common.misc.PlayerPositionRecorder;
import at.petrak.hexcasting.common.recipe.HexRecipeSerializers;
import at.petrak.hexcasting.forge.ForgeHexClientInitializer;
import at.petrak.hexcasting.forge.ForgeHexConfig;
import at.petrak.hexcasting.forge.cap.CapSyncers;
import at.petrak.hexcasting.forge.cap.ForgeCapabilityHandler;
import at.petrak.hexcasting.forge.datagen.HexForgeDataGenerators;
import at.petrak.hexcasting.forge.interop.curios.CuriosApiInterop;
import at.petrak.hexcasting.forge.interop.curios.CuriosRenderers;
import at.petrak.hexcasting.forge.network.ForgePacketHandler;
import at.petrak.hexcasting.forge.network.MsgBrainsweepAck;
import at.petrak.hexcasting.forge.recipe.ForgeModConditionalIngredient;
import at.petrak.hexcasting.forge.recipe.ForgeUnsealedIngredient;
import at.petrak.hexcasting.interop.HexInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="hexcasting")
public class ForgeHexInitializer {
    public ForgeHexInitializer() {
        ForgeHexInitializer.initConfig();
        ForgeHexInitializer.initRegistry();
        ForgeHexInitializer.initListeners();
    }

    private static void initConfig() {
        Pair config = new ForgeConfigSpec.Builder().configure(ForgeHexConfig::new);
        Pair clientConfig = new ForgeConfigSpec.Builder().configure(ForgeHexConfig.Client::new);
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(ForgeHexConfig.Server::new);
        HexConfig.setCommon((HexConfig.CommonConfigAccess)config.getLeft());
        HexConfig.setClient((HexConfig.ClientConfigAccess)clientConfig.getLeft());
        HexConfig.setServer((HexConfig.ServerConfigAccess)serverConfig.getLeft());
        ModLoadingContext mlc = ModLoadingContext.get();
        mlc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getRight());
        mlc.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfig.getRight());
        mlc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfig.getRight());
    }

    private static void initRegistry() {
        ForgeHexInitializer.bind(ForgeRegistries.SOUND_EVENTS, HexSounds::registerSounds);
        ForgeHexInitializer.bind(ForgeRegistries.BLOCKS, HexBlocks::registerBlocks);
        ForgeHexInitializer.bind(ForgeRegistries.ITEMS, HexBlocks::registerBlockItems);
        ForgeHexInitializer.bind(ForgeRegistries.BLOCK_ENTITIES, HexBlockEntities::registerTiles);
        ForgeHexInitializer.bind(ForgeRegistries.ITEMS, HexItems::registerItems);
        ForgeHexInitializer.bind(ForgeRegistries.RECIPE_SERIALIZERS, HexRecipeSerializers::registerSerializers);
        ForgeHexInitializer.bind(ForgeRegistries.ENTITIES, HexEntities::registerEntities);
        ForgeHexInitializer.bind(ForgeRegistries.PARTICLE_TYPES, HexParticles::registerParticles);
        ArgumentTypes.m_121601_((String)"hexcasting:pattern", PatternResLocArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(PatternResLocArgument::id));
        HexAdvancementTriggers.registerTriggers();
    }

    private static <T extends IForgeRegistryEntry<T>> void bind(IForgeRegistry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        ForgeHexInitializer.getModEventBus().addGenericListener(registry.getRegistrySuperType(), event -> {
            IForgeRegistry forgeRegistry = event.getRegistry();
            source.accept((t, rl) -> {
                t.setRegistryName(rl);
                forgeRegistry.register(t);
            });
        });
    }

    private static void initListeners() {
        IEventBus modBus = ForgeHexInitializer.getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        modBus.register(ForgeHexClientInitializer.class);
        modBus.addListener(evt -> evt.enqueueWork(() -> {
            ForgePacketHandler.init();
            HexComposting.setup();
            HexStrippables.init();
            RegisterPatterns.registerPatterns();
            AkashicTreeGrower.init();
            HexInterop.init();
        }));
        modBus.addGenericListener(Item.class, evt -> {
            HexRecipeSerializers.registerTypes();
            CraftingHelper.register((ResourceLocation)ForgeUnsealedIngredient.ID, (IIngredientSerializer)ForgeUnsealedIngredient.Serializer.INSTANCE);
            CraftingHelper.register((ResourceLocation)ForgeModConditionalIngredient.ID, (IIngredientSerializer)ForgeModConditionalIngredient.Serializer.INSTANCE);
            HexStatistics.register();
            HexLootFunctions.registerSerializers((lift, id) -> Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)id, (Object)lift));
        });
        modBus.addListener(evt -> HexAPI.LOGGER.info(PatternRegistry.getPatternCountInfo()));
        evBus.addListener(evt -> {
            InteractionResult res = Brainsweeping.tradeWithVillager(evt.getPlayer(), evt.getWorld(), evt.getHand(), evt.getTarget(), null);
            if (res.m_19077_()) {
                evt.setCanceled(true);
                evt.setCancellationResult(res);
            }
        });
        evBus.addListener(evt -> Brainsweeping.copyBrainsweepFromVillager(evt.getEntityLiving(), evt.getOutcome()));
        evBus.addListener(evt -> {
            OpFlight.INSTANCE.tickDownFlight(evt.getEntityLiving());
            ItemLens.tickLens((Entity)evt.getEntityLiving());
        });
        evBus.addListener(evt -> {
            Level patt8897$temp;
            if (evt.phase == TickEvent.Phase.END && (patt8897$temp = evt.world) instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)patt8897$temp;
                PlayerPositionRecorder.updateAllPlayers(world);
            }
        });
        evBus.addListener(evt -> HexCommands.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher()));
        evBus.addListener(evt -> evt.setCanceled(ItemJewelerHammer.shouldFailToBreak(evt.getPlayer(), evt.getState(), evt.getPos())));
        evBus.addListener(evt -> HexLootHandler.lootLoad(evt.getName(), arg_0 -> ((LootTable)evt.getTable()).addPool(arg_0)));
        evBus.addListener(evt -> {
            Entity target = evt.getTarget();
            Player patt9688$temp = evt.getPlayer();
            if (patt9688$temp instanceof ServerPlayer) {
                Mob mob;
                ServerPlayer serverPlayer = (ServerPlayer)patt9688$temp;
                if (target instanceof Mob && IXplatAbstractions.INSTANCE.isBrainswept(mob = (Mob)target)) {
                    ForgePacketHandler.getNetwork().send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)MsgBrainsweepAck.of((Entity)mob));
                }
            }
        });
        evBus.addListener(evt -> {
            BlockState bs;
            Block output;
            if (!evt.isSimulated() && evt.getToolAction() == ToolActions.AXE_STRIP && (output = HexStrippables.STRIPPABLES.get((bs = evt.getState()).m_60734_())) != null) {
                evt.setFinalState(output.m_152465_(bs));
            }
        });
        modBus.addListener(ForgeCapabilityHandler::registerCaps);
        evBus.addGenericListener(ItemStack.class, ForgeCapabilityHandler::attachItemCaps);
        evBus.addGenericListener(BlockEntity.class, ForgeCapabilityHandler::attachBlockEntityCaps);
        evBus.addGenericListener(Entity.class, ForgeCapabilityHandler::attachEntityCaps);
        modBus.register(HexForgeDataGenerators.class);
        modBus.register(ForgeCapabilityHandler.class);
        evBus.register(CapSyncers.class);
        if (ModList.get().isLoaded("curios")) {
            modBus.addListener(CuriosApiInterop::onInterModEnqueue);
            modBus.addListener(CuriosApiInterop::onClientSetup);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(CuriosRenderers::onLayerRegister));
        }
    }

    private static IEventBus getModEventBus() {
        return KotlinModLoadingContext.Companion.get().getKEventBus();
    }
}

