/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.common.recipe.SealFocusRecipe;
import at.petrak.hexcasting.common.recipe.SealSpellbookRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class HexRecipeSerializers {
    private static final Map<ResourceLocation, RecipeSerializer<?>> SERIALIZERS = new LinkedHashMap();
    public static final RecipeSerializer<?> BRAINSWEEP = HexRecipeSerializers.register("brainsweep", new BrainsweepRecipe.Serializer());
    public static RecipeType<BrainsweepRecipe> BRAINSWEEP_TYPE;
    public static final RecipeSerializer<SealFocusRecipe> SEAL_FOCUS;
    public static final RecipeSerializer<SealSpellbookRecipe> SEAL_SPELLBOOK;

    public static void registerSerializers(BiConsumer<RecipeSerializer<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, RecipeSerializer<?>> e : SERIALIZERS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <T extends Recipe<?>> RecipeSerializer<T> register(String name, RecipeSerializer<T> rs) {
        RecipeSerializer<T> old = SERIALIZERS.put(HexAPI.modLoc(name), rs);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return rs;
    }

    public static void registerTypes() {
        BRAINSWEEP_TYPE = RecipeType.m_44119_((String)"hexcasting:brainsweep");
    }

    static {
        SEAL_FOCUS = HexRecipeSerializers.register("seal_focus", SealFocusRecipe.SERIALIZER);
        SEAL_SPELLBOOK = HexRecipeSerializers.register("seal_spellbook", SealSpellbookRecipe.SERIALIZER);
    }
}

