/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.operators.spells.great;

import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.SpellOperator;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.SpellContinuation;
import at.petrak.hexcasting.api.spell.mishaps.MishapImmuneEntity;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.spell.mishaps.MishapLocationTooFarAway;
import at.petrak.hexcasting.api.spell.mishaps.MishapNotEnoughArgs;
import at.petrak.hexcasting.common.lib.HexEntityTags;
import at.petrak.hexcasting.common.network.MsgBlinkAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/great/OpTeleport;", "Lat/petrak/hexcasting/api/spell/SpellOperator;", "()V", "argc", "", "getArgc", "()I", "isGreat", "", "()Z", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "teleportRespectSticky", "", "teleportee", "Lnet/minecraft/world/entity/Entity;", "delta", "Lnet/minecraft/world/phys/Vec3;", "Spell", "hexcasting-forge-1.18.2"})
public final class OpTeleport
implements SpellOperator {
    @NotNull
    public static final OpTeleport INSTANCE = new OpTeleport();
    private static final int argc = 2;
    private static final boolean isGreat = true;

    private OpTeleport() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    public boolean isGreat() {
        return isGreat;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends SpellDatum<?>> args, @NotNull CastingContext ctx) {
        int idx$iv;
        void $this$getChecked$iv;
        int idx$iv22;
        void $this$getChecked$iv2;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List<? extends SpellDatum<?>> list = args;
        boolean bl = false;
        int argc$iv = this.getArgc();
        boolean $i$f$getChecked = false;
        void var8_10 = $this$getChecked$iv2;
        if (idx$iv22 > CollectionsKt.getLastIndex((List)var8_10)) {
            void it$iv = idx$iv22;
            boolean bl2 = false;
            throw new MishapNotEnoughArgs((int)(idx$iv22 + true), $this$getChecked$iv2.size());
        }
        SpellDatum x$iv = (SpellDatum)var8_10.get(idx$iv22);
        if (!(x$iv.getPayload() instanceof Entity)) {
            throw MishapInvalidIota.Companion.ofClass(x$iv, argc$iv == 0 ? idx$iv22 : argc$iv - (idx$iv22 + true), Entity.class);
        }
        Entity teleportee = (Entity)x$iv.getPayload();
        List<? extends SpellDatum<?>> idx$iv22 = args;
        argc$iv = 1;
        int argc$iv2 = this.getArgc();
        boolean $i$f$getChecked2 = false;
        void var9_13 = $this$getChecked$iv;
        if (idx$iv > CollectionsKt.getLastIndex((List)var9_13)) {
            void it$iv = idx$iv;
            boolean bl3 = false;
            throw new MishapNotEnoughArgs((int)(idx$iv + true), $this$getChecked$iv.size());
        }
        SpellDatum x$iv2 = (SpellDatum)var9_13.get(idx$iv);
        if (!(x$iv2.getPayload() instanceof Vec3)) {
            throw MishapInvalidIota.Companion.ofClass(x$iv2, argc$iv2 == 0 ? idx$iv : argc$iv2 - (idx$iv + true), Vec3.class);
        }
        Vec3 delta = (Vec3)x$iv2.getPayload();
        ctx.assertEntityInRange(teleportee);
        if (!teleportee.m_6072_() || teleportee.m_6095_().m_204039_(HexEntityTags.CANNOT_TELEPORT)) {
            throw new MishapImmuneEntity(teleportee);
        }
        Vec3 targetPos = teleportee.m_20182_().m_82549_(delta);
        Intrinsics.checkNotNullExpressionValue((Object)targetPos, (String)"targetPos");
        ctx.assertVecInWorld(targetPos);
        Vec3 vec3 = targetPos.m_82492_(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"targetPos.subtract(0.0, 1.0, 0.0)");
        if (!ctx.isVecInWorld(vec3)) {
            throw new MishapLocationTooFarAway(targetPos, "too_close_to_out");
        }
        Vec3 targetMiddlePos = teleportee.m_20182_().m_82520_(0.0, (double)teleportee.m_20192_() / 2.0, 0.0);
        Spell spell = new Spell(teleportee, delta);
        Integer n = 1000000;
        Object[] objectArray = new ParticleSpray[2];
        Intrinsics.checkNotNullExpressionValue((Object)targetMiddlePos, (String)"targetMiddlePos");
        objectArray[0] = ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, targetMiddlePos, 2.0, 0, 4, null);
        Vec3 vec32 = targetMiddlePos.m_82549_(delta);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"targetMiddlePos.add(delta)");
        objectArray[1] = ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec32, 2.0, 0, 4, null);
        return new Triple((Object)spell, (Object)n, (Object)CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public final void teleportRespectSticky(@NotNull Entity teleportee, @NotNull Vec3 delta) {
        boolean cannotSticky;
        boolean sticky;
        Iterable indirect;
        List playersToUpdate;
        Entity base;
        block15: {
            boolean bl;
            block14: {
                Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
                Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
                base = teleportee.m_20201_();
                playersToUpdate = new ArrayList();
                indirect = base.m_146897_();
                Intrinsics.checkNotNullExpressionValue((Object)indirect, (String)"indirect");
                Iterable $this$any$iv = indirect;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl2 = false;
                        if (!it.m_6095_().m_204039_(HexEntityTags.STICKY_TELEPORTERS)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            sticky = bl;
            Iterable $this$none$iv = indirect;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v1 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl3 = false;
                    if (!it.m_6095_().m_204039_(HexEntityTags.CANNOT_TELEPORT)) continue;
                    v1 = false;
                    break block15;
                }
                v1 = cannotSticky = true;
            }
        }
        if (sticky && cannotSticky) {
            return;
        }
        if (sticky) {
            void $this$forEach$iv;
            Iterator $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Object element$iv;
            Vec3 target = base.m_20182_().m_82549_(delta);
            base.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
            Iterable $i$f$none = indirect;
            boolean $i$f$filterIsInstance = false;
            element$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                if (!(element$iv$iv instanceof ServerPlayer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ServerPlayer p0 = (ServerPlayer)element$iv2;
                boolean bl = false;
                playersToUpdate.add(p0);
            }
        } else {
            teleportee.m_8127_();
            List list = teleportee.m_20197_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"teleportee.passengers");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity p0 = (Entity)element$iv;
                boolean bl = false;
                p0.m_8127_();
            }
            teleportee.m_146884_(teleportee.m_20182_().m_82549_(delta));
            if (teleportee instanceof ServerPlayer) {
                playersToUpdate.add(teleportee);
            }
        }
        for (ServerPlayer player : playersToUpdate) {
            player.f_8906_.m_9953_();
            IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgBlinkAck(delta));
        }
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<SpellDatum<?>> stack, @NotNull SpellDatum<?> local, @NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.operate(this, continuation, stack, local, ctx);
    }

    @Override
    public boolean getAlwaysProcessGreatSpell() {
        return SpellOperator.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    @Override
    public boolean getCausesBlindDiversion() {
        return SpellOperator.DefaultImpls.getCausesBlindDiversion(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return SpellOperator.DefaultImpls.getDisplayName(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/great/OpTeleport$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "teleportee", "Lnet/minecraft/world/entity/Entity;", "delta", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;)V", "getDelta", "()Lnet/minecraft/world/phys/Vec3;", "getTeleportee", "()Lnet/minecraft/world/entity/Entity;", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Entity teleportee;
        @NotNull
        private final Vec3 delta;

        public Spell(@NotNull Entity teleportee, @NotNull Vec3 delta) {
            Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
            Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
            this.teleportee = teleportee;
            this.delta = delta;
        }

        @NotNull
        public final Entity getTeleportee() {
            return this.teleportee;
        }

        @NotNull
        public final Vec3 getDelta() {
            return this.delta;
        }

        @Override
        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            double distance = this.delta.m_82553_();
            if (distance < 32768.0) {
                INSTANCE.teleportRespectSticky(this.teleportee, this.delta);
            }
            if (this.teleportee instanceof ServerPlayer && Intrinsics.areEqual((Object)this.teleportee, (Object)ctx.getCaster())) {
                double baseDropChance = distance / 10000.0;
                for (ItemStack armorItem : ((ServerPlayer)this.teleportee).m_150109_().f_35975_) {
                    if (EnchantmentHelper.m_44920_((ItemStack)armorItem) || !(Math.random() < baseDropChance * 0.25)) continue;
                    ((ServerPlayer)this.teleportee).m_7197_(armorItem.m_41777_(), true, false);
                    armorItem.m_41774_(armorItem.m_41613_());
                }
                Iterator iterator = ((ServerPlayer)this.teleportee).m_150109_().f_35974_.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    double dropChance;
                    int pos = n++;
                    ItemStack invItem = (ItemStack)iterator.next();
                    if (Intrinsics.areEqual((Object)invItem, (Object)((ServerPlayer)this.teleportee).m_21205_())) continue;
                    double d = dropChance = pos < 9 ? baseDropChance * 0.5 : baseDropChance;
                    if (!(Math.random() < dropChance)) continue;
                    ((ServerPlayer)this.teleportee).m_7197_(invItem.m_41777_(), true, false);
                    invItem.m_41774_(invItem.m_41613_());
                }
            }
        }

        @NotNull
        public final Entity component1() {
            return this.teleportee;
        }

        @NotNull
        public final Vec3 component2() {
            return this.delta;
        }

        @NotNull
        public final Spell copy(@NotNull Entity teleportee, @NotNull Vec3 delta) {
            Intrinsics.checkNotNullParameter((Object)teleportee, (String)"teleportee");
            Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
            return new Spell(teleportee, delta);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Entity entity, Vec3 vec3, int n, Object object) {
            if ((n & 1) != 0) {
                entity = spell.teleportee;
            }
            if ((n & 2) != 0) {
                vec3 = spell.delta;
            }
            return spell.copy(entity, vec3);
        }

        @NotNull
        public String toString() {
            return "Spell(teleportee=" + this.teleportee + ", delta=" + this.delta + ")";
        }

        public int hashCode() {
            int result = this.teleportee.hashCode();
            result = result * 31 + this.delta.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.teleportee, (Object)spell.teleportee)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.delta, (Object)spell.delta);
        }
    }
}

