/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.item;

import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.OverrideOnly
public interface ManaHolderItem {
    public int getMana(ItemStack var1);

    public int getMaxMana(ItemStack var1);

    public void setMana(ItemStack var1, int var2);

    public boolean manaProvider(ItemStack var1);

    public boolean canRecharge(ItemStack var1);

    default public float getManaFullness(ItemStack stack) {
        int max = this.getMaxMana(stack);
        if (max == 0) {
            return 0.0f;
        }
        return (float)this.getMana(stack) / (float)max;
    }

    default public int withdrawMana(ItemStack stack, int cost, boolean simulate) {
        int manaHere = this.getMana(stack);
        if (cost < 0) {
            cost = manaHere;
        }
        if (!simulate) {
            int manaLeft = manaHere - cost;
            this.setMana(stack, manaLeft);
        }
        return Math.min(cost, manaHere);
    }

    default public int insertMana(ItemStack stack, int amount, boolean simulate) {
        int manaHere = this.getMana(stack);
        int emptySpace = this.getMaxMana(stack) - manaHere;
        if (emptySpace <= 0) {
            return 0;
        }
        if (amount < 0) {
            amount = emptySpace;
        }
        int inserting = Math.min(amount, emptySpace);
        if (!simulate) {
            int newMana = manaHere + inserting;
            this.setMana(stack, newMana);
        }
        return inserting;
    }
}

