/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api;

import at.petrak.hexcasting.api.spell.Operator;
import at.petrak.hexcasting.api.spell.math.EulerPathFinder;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007/012345B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0018H\u0007J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u0004H\u0007J(\u0010\u001c\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d2\u0006\u0010 \u001a\u00020!H\u0007J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\tH\u0007J\u0010\u0010\"\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0007J*\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010)\u001a\u00020\t2\b\b\u0002\u0010*\u001a\u00020+H\u0007J\u0018\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0007J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u001e2\u0006\u0010-\u001a\u00020(2\u0006\u0010 \u001a\u00020!H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry;", "", "()V", "TAG_OP_ID", "", "TAG_SAVED_DATA", "TAG_START_DIR", "keyLookup", "Ljava/util/concurrent/ConcurrentHashMap;", "Lat/petrak/hexcasting/api/spell/Operator;", "Lnet/minecraft/resources/ResourceLocation;", "operatorLookup", "perWorldPatternLookup", "Ljava/util/concurrent/ConcurrentMap;", "Lat/petrak/hexcasting/api/PatternRegistry$PerWorldEntry;", "regularPatternLookup", "Lat/petrak/hexcasting/api/PatternRegistry$RegularEntry;", "specialHandlers", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lat/petrak/hexcasting/api/PatternRegistry$SpecialHandlerEntry;", "addSpecialHandler", "", "handler", "id", "Lat/petrak/hexcasting/api/PatternRegistry$SpecialHandler;", "getAllPerWorldPatternNames", "", "getPatternCountInfo", "getPerWorldPatterns", "", "Lkotlin/Pair;", "Lat/petrak/hexcasting/api/spell/math/HexDir;", "overworld", "Lnet/minecraft/server/level/ServerLevel;", "lookupPattern", "op", "Lat/petrak/hexcasting/api/PatternRegistry$PatternEntry;", "opId", "mapPattern", "pattern", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "operator", "isPerWorld", "", "matchPattern", "pat", "matchPatternAndID", "PatternEntry", "PerWorldEntry", "RegisterPatternException", "RegularEntry", "Save", "SpecialHandler", "SpecialHandlerEntry", "hexcasting-forge-1.18.2"})
public final class PatternRegistry {
    @NotNull
    public static final PatternRegistry INSTANCE = new PatternRegistry();
    @NotNull
    private static final ConcurrentHashMap<ResourceLocation, Operator> operatorLookup = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<Operator, ResourceLocation> keyLookup = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentLinkedDeque<SpecialHandlerEntry> specialHandlers = new ConcurrentLinkedDeque();
    @NotNull
    private static final ConcurrentMap<String, RegularEntry> regularPatternLookup = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentMap<ResourceLocation, PerWorldEntry> perWorldPatternLookup = new ConcurrentHashMap();
    @NotNull
    public static final String TAG_SAVED_DATA = "hex.per-world-patterns";
    @NotNull
    private static final String TAG_OP_ID = "op_id";
    @NotNull
    private static final String TAG_START_DIR = "start_dir";

    private PatternRegistry() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void mapPattern(@NotNull HexPattern pattern, @NotNull ResourceLocation id, @NotNull Operator operator, boolean isPerWorld) throws RegisterPatternException {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Operator operator2 = operatorLookup.get(id);
        if (operator2 != null) {
            Operator it = operator2;
            boolean bl = false;
            throw new RegisterPatternException("The operator with id `" + id + "` was already registered to: " + it);
        }
        ((Map)operatorLookup).put(id, operator);
        ((Map)keyLookup).put(operator, id);
        if (isPerWorld) {
            ((Map)perWorldPatternLookup).put(id, new PerWorldEntry(pattern, id));
        } else {
            ((Map)regularPatternLookup).put(pattern.anglesSignature(), new RegularEntry(pattern.getStartDir(), id));
        }
    }

    public static /* synthetic */ void mapPattern$default(HexPattern hexPattern, ResourceLocation resourceLocation, Operator operator, boolean bl, int n, Object object) throws RegisterPatternException {
        if ((n & 8) != 0) {
            bl = false;
        }
        PatternRegistry.mapPattern(hexPattern, resourceLocation, operator, bl);
    }

    @JvmStatic
    public static final void addSpecialHandler(@NotNull SpecialHandlerEntry handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        specialHandlers.add(handler);
    }

    @JvmStatic
    public static final void addSpecialHandler(@NotNull ResourceLocation id, @NotNull SpecialHandler handler) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        PatternRegistry.addSpecialHandler(new SpecialHandlerEntry(id, handler));
    }

    @JvmStatic
    @NotNull
    public static final Operator matchPattern(@NotNull HexPattern pat, @NotNull ServerLevel overworld) {
        Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
        Intrinsics.checkNotNullParameter((Object)overworld, (String)"overworld");
        return (Operator)PatternRegistry.matchPatternAndID(pat, overworld).getFirst();
    }

    @JvmStatic
    @NotNull
    public static final Pair<Operator, ResourceLocation> matchPatternAndID(@NotNull HexPattern pat, @NotNull ServerLevel overworld) {
        Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
        Intrinsics.checkNotNullParameter((Object)overworld, (String)"overworld");
        String sig = pat.anglesSignature();
        RegularEntry regularEntry = (RegularEntry)regularPatternLookup.get(sig);
        if (regularEntry != null) {
            RegularEntry it = regularEntry;
            boolean bl = false;
            Operator operator = operatorLookup.get(it.getOpId());
            if (operator == null) {
                throw new MishapInvalidPattern();
            }
            Intrinsics.checkNotNullExpressionValue((Object)operator, (String)"this.operatorLookup[it.o\u2026ow MishapInvalidPattern()");
            Operator op = operator;
            return TuplesKt.to((Object)op, (Object)it.getOpId());
        }
        DimensionDataStorage ds = overworld.m_8895_();
        SavedData savedData = ds.m_164861_(Save.Companion::load, () -> PatternRegistry.matchPatternAndID$lambda-2(overworld), TAG_SAVED_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"ds.computeIfAbsent(Save.\u2026.seed) }, TAG_SAVED_DATA)");
        Save perWorldPatterns = (Save)savedData;
        perWorldPatterns.fillMissingEntries(overworld.m_7328_());
        Pair<ResourceLocation, HexDir> pair = perWorldPatterns.getLookup().get(sig);
        if (pair != null) {
            Pair<ResourceLocation, HexDir> it = pair;
            boolean bl = false;
            Operator operator = operatorLookup.get(it.getFirst());
            Intrinsics.checkNotNull((Object)operator);
            Operator op = operator;
            return TuplesKt.to((Object)op, (Object)it.getFirst());
        }
        for (SpecialHandlerEntry handler : specialHandlers) {
            Operator op;
            Operator operator = op = handler.getHandler().handlePattern(pat);
            if (operator == null) continue;
            return TuplesKt.to((Object)operator, (Object)handler.getId());
        }
        throw new MishapInvalidPattern();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Pair<ResourceLocation, HexDir>> getPerWorldPatterns(@NotNull ServerLevel overworld) {
        Intrinsics.checkNotNullParameter((Object)overworld, (String)"overworld");
        DimensionDataStorage ds = overworld.m_8895_();
        SavedData savedData = ds.m_164861_(Save.Companion::load, () -> PatternRegistry.getPerWorldPatterns$lambda-4(overworld), TAG_SAVED_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"ds.computeIfAbsent(Save.\u2026.seed) }, TAG_SAVED_DATA)");
        Save perWorldPatterns = (Save)savedData;
        return perWorldPatterns.getLookup();
    }

    @JvmStatic
    @Nullable
    public static final ResourceLocation lookupPattern(@NotNull Operator op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return keyLookup.get(op);
    }

    @JvmStatic
    @NotNull
    public static final PatternEntry lookupPattern(@NotNull ResourceLocation opId) {
        Intrinsics.checkNotNullParameter((Object)opId, (String)"opId");
        PerWorldEntry perWorldEntry = (PerWorldEntry)perWorldPatternLookup.get(opId);
        if (perWorldEntry != null) {
            PerWorldEntry it = perWorldEntry;
            boolean bl = false;
            HexPattern hexPattern = it.getPrototype();
            Operator operator = operatorLookup.get(it.getOpId());
            Intrinsics.checkNotNull((Object)operator);
            return new PatternEntry(hexPattern, operator, true);
        }
        for (Map.Entry entry : ((Map)regularPatternLookup).entrySet()) {
            String sig = (String)entry.getKey();
            RegularEntry entry2 = (RegularEntry)entry.getValue();
            if (!Intrinsics.areEqual((Object)entry2.getOpId(), (Object)opId)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)sig, (String)"sig");
            HexPattern pattern = HexPattern.Companion.fromAngles(sig, entry2.getPreferredStart());
            Operator operator = operatorLookup.get(entry2.getOpId());
            Intrinsics.checkNotNull((Object)operator);
            return new PatternEntry(pattern, operator, false);
        }
        throw new IllegalArgumentException("could not find a pattern for " + opId);
    }

    @JvmStatic
    @NotNull
    public static final Set<ResourceLocation> getAllPerWorldPatternNames() {
        return CollectionsKt.toSet((Iterable)perWorldPatternLookup.keySet());
    }

    @JvmStatic
    @NotNull
    public static final String getPatternCountInfo() {
        return "Loaded " + regularPatternLookup.size() + " regular patterns, " + perWorldPatternLookup.size() + " per-world patterns, and " + specialHandlers.size() + " special handlers.";
    }

    @JvmStatic
    @JvmOverloads
    public static final void mapPattern(@NotNull HexPattern pattern, @NotNull ResourceLocation id, @NotNull Operator operator) throws RegisterPatternException {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        PatternRegistry.mapPattern$default(pattern, id, operator, false, 8, null);
    }

    private static final Save matchPatternAndID$lambda-2(ServerLevel $overworld) {
        Intrinsics.checkNotNullParameter((Object)$overworld, (String)"$overworld");
        return Save.Companion.create($overworld.m_7328_());
    }

    private static final Save getPerWorldPatterns$lambda-4(ServerLevel $overworld) {
        Intrinsics.checkNotNullParameter((Object)$overworld, (String)"$overworld");
        return Save.Companion.create($overworld.m_7328_());
    }

    public static final /* synthetic */ ConcurrentMap access$getRegularPatternLookup$p() {
        return regularPatternLookup;
    }

    public static final /* synthetic */ ConcurrentLinkedDeque access$getSpecialHandlers$p() {
        return specialHandlers;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$SpecialHandler;", "", "handlePattern", "Lat/petrak/hexcasting/api/spell/Operator;", "pattern", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "hexcasting-forge-1.18.2"})
    public static interface SpecialHandler {
        @Nullable
        public Operator handlePattern(@NotNull HexPattern var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$SpecialHandlerEntry;", "", "id", "Lnet/minecraft/resources/ResourceLocation;", "handler", "Lat/petrak/hexcasting/api/PatternRegistry$SpecialHandler;", "(Lnet/minecraft/resources/ResourceLocation;Lat/petrak/hexcasting/api/PatternRegistry$SpecialHandler;)V", "getHandler", "()Lat/petrak/hexcasting/api/PatternRegistry$SpecialHandler;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    public static final class SpecialHandlerEntry {
        @NotNull
        private final ResourceLocation id;
        @NotNull
        private final SpecialHandler handler;

        public SpecialHandlerEntry(@NotNull ResourceLocation id, @NotNull SpecialHandler handler) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            this.id = id;
            this.handler = handler;
        }

        @NotNull
        public final ResourceLocation getId() {
            return this.id;
        }

        @NotNull
        public final SpecialHandler getHandler() {
            return this.handler;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.id;
        }

        @NotNull
        public final SpecialHandler component2() {
            return this.handler;
        }

        @NotNull
        public final SpecialHandlerEntry copy(@NotNull ResourceLocation id, @NotNull SpecialHandler handler) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            return new SpecialHandlerEntry(id, handler);
        }

        public static /* synthetic */ SpecialHandlerEntry copy$default(SpecialHandlerEntry specialHandlerEntry, ResourceLocation resourceLocation, SpecialHandler specialHandler, int n, Object object) {
            if ((n & 1) != 0) {
                resourceLocation = specialHandlerEntry.id;
            }
            if ((n & 2) != 0) {
                specialHandler = specialHandlerEntry.handler;
            }
            return specialHandlerEntry.copy(resourceLocation, specialHandler);
        }

        @NotNull
        public String toString() {
            return "SpecialHandlerEntry(id=" + this.id + ", handler=" + this.handler + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.handler.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpecialHandlerEntry)) {
                return false;
            }
            SpecialHandlerEntry specialHandlerEntry = (SpecialHandlerEntry)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)specialHandlerEntry.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.handler, (Object)specialHandlerEntry.handler);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$RegisterPatternException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "hexcasting-forge-1.18.2"})
    public static final class RegisterPatternException
    extends Exception {
        public RegisterPatternException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$RegularEntry;", "", "preferredStart", "Lat/petrak/hexcasting/api/spell/math/HexDir;", "opId", "Lnet/minecraft/resources/ResourceLocation;", "(Lat/petrak/hexcasting/api/spell/math/HexDir;Lnet/minecraft/resources/ResourceLocation;)V", "getOpId", "()Lnet/minecraft/resources/ResourceLocation;", "getPreferredStart", "()Lat/petrak/hexcasting/api/spell/math/HexDir;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    private static final class RegularEntry {
        @NotNull
        private final HexDir preferredStart;
        @NotNull
        private final ResourceLocation opId;

        public RegularEntry(@NotNull HexDir preferredStart, @NotNull ResourceLocation opId) {
            Intrinsics.checkNotNullParameter((Object)((Object)preferredStart), (String)"preferredStart");
            Intrinsics.checkNotNullParameter((Object)opId, (String)"opId");
            this.preferredStart = preferredStart;
            this.opId = opId;
        }

        @NotNull
        public final HexDir getPreferredStart() {
            return this.preferredStart;
        }

        @NotNull
        public final ResourceLocation getOpId() {
            return this.opId;
        }

        @NotNull
        public final HexDir component1() {
            return this.preferredStart;
        }

        @NotNull
        public final ResourceLocation component2() {
            return this.opId;
        }

        @NotNull
        public final RegularEntry copy(@NotNull HexDir preferredStart, @NotNull ResourceLocation opId) {
            Intrinsics.checkNotNullParameter((Object)((Object)preferredStart), (String)"preferredStart");
            Intrinsics.checkNotNullParameter((Object)opId, (String)"opId");
            return new RegularEntry(preferredStart, opId);
        }

        public static /* synthetic */ RegularEntry copy$default(RegularEntry regularEntry, HexDir hexDir, ResourceLocation resourceLocation, int n, Object object) {
            if ((n & 1) != 0) {
                hexDir = regularEntry.preferredStart;
            }
            if ((n & 2) != 0) {
                resourceLocation = regularEntry.opId;
            }
            return regularEntry.copy(hexDir, resourceLocation);
        }

        @NotNull
        public String toString() {
            return "RegularEntry(preferredStart=" + this.preferredStart + ", opId=" + this.opId + ")";
        }

        public int hashCode() {
            int result = this.preferredStart.hashCode();
            result = result * 31 + this.opId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegularEntry)) {
                return false;
            }
            RegularEntry regularEntry = (RegularEntry)other;
            if (this.preferredStart != regularEntry.preferredStart) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.opId, (Object)regularEntry.opId);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$PerWorldEntry;", "", "prototype", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "opId", "Lnet/minecraft/resources/ResourceLocation;", "(Lat/petrak/hexcasting/api/spell/math/HexPattern;Lnet/minecraft/resources/ResourceLocation;)V", "getOpId", "()Lnet/minecraft/resources/ResourceLocation;", "getPrototype", "()Lat/petrak/hexcasting/api/spell/math/HexPattern;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    private static final class PerWorldEntry {
        @NotNull
        private final HexPattern prototype;
        @NotNull
        private final ResourceLocation opId;

        public PerWorldEntry(@NotNull HexPattern prototype, @NotNull ResourceLocation opId) {
            Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
            Intrinsics.checkNotNullParameter((Object)opId, (String)"opId");
            this.prototype = prototype;
            this.opId = opId;
        }

        @NotNull
        public final HexPattern getPrototype() {
            return this.prototype;
        }

        @NotNull
        public final ResourceLocation getOpId() {
            return this.opId;
        }

        @NotNull
        public final HexPattern component1() {
            return this.prototype;
        }

        @NotNull
        public final ResourceLocation component2() {
            return this.opId;
        }

        @NotNull
        public final PerWorldEntry copy(@NotNull HexPattern prototype, @NotNull ResourceLocation opId) {
            Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
            Intrinsics.checkNotNullParameter((Object)opId, (String)"opId");
            return new PerWorldEntry(prototype, opId);
        }

        public static /* synthetic */ PerWorldEntry copy$default(PerWorldEntry perWorldEntry, HexPattern hexPattern, ResourceLocation resourceLocation, int n, Object object) {
            if ((n & 1) != 0) {
                hexPattern = perWorldEntry.prototype;
            }
            if ((n & 2) != 0) {
                resourceLocation = perWorldEntry.opId;
            }
            return perWorldEntry.copy(hexPattern, resourceLocation);
        }

        @NotNull
        public String toString() {
            return "PerWorldEntry(prototype=" + this.prototype + ", opId=" + this.opId + ")";
        }

        public int hashCode() {
            int result = this.prototype.hashCode();
            result = result * 31 + this.opId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PerWorldEntry)) {
                return false;
            }
            PerWorldEntry perWorldEntry = (PerWorldEntry)other;
            if (!Intrinsics.areEqual((Object)this.prototype, (Object)perWorldEntry.prototype)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.opId, (Object)perWorldEntry.opId);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$PatternEntry;", "", "prototype", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "operator", "Lat/petrak/hexcasting/api/spell/Operator;", "isPerWorld", "", "(Lat/petrak/hexcasting/api/spell/math/HexPattern;Lat/petrak/hexcasting/api/spell/Operator;Z)V", "()Z", "getOperator", "()Lat/petrak/hexcasting/api/spell/Operator;", "getPrototype", "()Lat/petrak/hexcasting/api/spell/math/HexPattern;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    public static final class PatternEntry {
        @NotNull
        private final HexPattern prototype;
        @NotNull
        private final Operator operator;
        private final boolean isPerWorld;

        public PatternEntry(@NotNull HexPattern prototype, @NotNull Operator operator, boolean isPerWorld) {
            Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            this.prototype = prototype;
            this.operator = operator;
            this.isPerWorld = isPerWorld;
        }

        @NotNull
        public final HexPattern getPrototype() {
            return this.prototype;
        }

        @NotNull
        public final Operator getOperator() {
            return this.operator;
        }

        public final boolean isPerWorld() {
            return this.isPerWorld;
        }

        @NotNull
        public final HexPattern component1() {
            return this.prototype;
        }

        @NotNull
        public final Operator component2() {
            return this.operator;
        }

        public final boolean component3() {
            return this.isPerWorld;
        }

        @NotNull
        public final PatternEntry copy(@NotNull HexPattern prototype, @NotNull Operator operator, boolean isPerWorld) {
            Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            return new PatternEntry(prototype, operator, isPerWorld);
        }

        public static /* synthetic */ PatternEntry copy$default(PatternEntry patternEntry, HexPattern hexPattern, Operator operator, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                hexPattern = patternEntry.prototype;
            }
            if ((n & 2) != 0) {
                operator = patternEntry.operator;
            }
            if ((n & 4) != 0) {
                bl = patternEntry.isPerWorld;
            }
            return patternEntry.copy(hexPattern, operator, bl);
        }

        @NotNull
        public String toString() {
            return "PatternEntry(prototype=" + this.prototype + ", operator=" + this.operator + ", isPerWorld=" + this.isPerWorld + ")";
        }

        public int hashCode() {
            int result = this.prototype.hashCode();
            result = result * 31 + this.operator.hashCode();
            int n = this.isPerWorld ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatternEntry)) {
                return false;
            }
            PatternEntry patternEntry = (PatternEntry)other;
            if (!Intrinsics.areEqual((Object)this.prototype, (Object)patternEntry.prototype)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operator, (Object)patternEntry.operator)) {
                return false;
            }
            return this.isPerWorld == patternEntry.isPerWorld;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\b\u0016\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u00a2\u0006\u0002\u0010\bB-\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$Save;", "Lnet/minecraft/world/level/saveddata/SavedData;", "lookup", "", "", "Lkotlin/Pair;", "Lnet/minecraft/resources/ResourceLocation;", "Lat/petrak/hexcasting/api/spell/math/HexDir;", "(Ljava/util/Map;)V", "missingEntries", "", "(Ljava/util/Map;Z)V", "getLookup", "()Ljava/util/Map;", "getMissingEntries", "()Z", "setMissingEntries", "(Z)V", "fillMissingEntries", "", "seed", "", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Companion", "hexcasting-forge-1.18.2"})
    public static final class Save
    extends SavedData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, Pair<ResourceLocation, HexDir>> lookup;
        private boolean missingEntries;

        public Save(@NotNull Map<String, Pair<ResourceLocation, HexDir>> lookup, boolean missingEntries) {
            Intrinsics.checkNotNullParameter(lookup, (String)"lookup");
            this.lookup = lookup;
            this.missingEntries = missingEntries;
        }

        @NotNull
        public final Map<String, Pair<ResourceLocation, HexDir>> getLookup() {
            return this.lookup;
        }

        public final boolean getMissingEntries() {
            return this.missingEntries;
        }

        public final void setMissingEntries(boolean bl) {
            this.missingEntries = bl;
        }

        public Save(@NotNull Map<String, Pair<ResourceLocation, HexDir>> lookup) {
            Intrinsics.checkNotNullParameter(lookup, (String)"lookup");
            this(lookup, Companion.missingAny(lookup));
        }

        @NotNull
        public CompoundTag m_7176_(@NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            for (Map.Entry<String, Pair<ResourceLocation, HexDir>> entry : this.lookup.entrySet()) {
                String sig = entry.getKey();
                Pair<ResourceLocation, HexDir> rhs = entry.getValue();
                ResourceLocation id = (ResourceLocation)rhs.component1();
                HexDir startDir = (HexDir)((Object)rhs.component2());
                CompoundTag entry2 = new CompoundTag();
                entry2.m_128359_(PatternRegistry.TAG_OP_ID, id.toString());
                entry2.m_128344_(PatternRegistry.TAG_START_DIR, (byte)startDir.ordinal());
                tag.m_128365_(sig, (Tag)entry2);
            }
            return tag;
        }

        /*
         * WARNING - void declaration
         */
        public final void fillMissingEntries(long seed) {
            if (this.missingEntries) {
                void $this$mapTo$iv$iv;
                boolean doneAny = false;
                Iterable $this$map$iv = this.lookup.values();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((ResourceLocation)it.getFirst());
                }
                List allIds = (List)destination$iv$iv;
                for (PerWorldEntry perWorldEntry : perWorldPatternLookup.values()) {
                    HexPattern prototype = perWorldEntry.component1();
                    ResourceLocation opId = perWorldEntry.component2();
                    if (allIds.contains(opId)) continue;
                    Companion.scrungle(this.lookup, prototype, opId, seed);
                    doneAny = true;
                }
                if (doneAny) {
                    this.m_77762_();
                    this.missingEntries = false;
                }
            }
        }

        @JvmStatic
        @NotNull
        public static final Save create(long seed) {
            return Companion.create(seed);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ&\u0010\n\u001a\u00020\u000b2\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\rJ>\u0010\u0012\u001a\u00020\u00132\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0017"}, d2={"Lat/petrak/hexcasting/api/PatternRegistry$Save$Companion;", "", "()V", "create", "Lat/petrak/hexcasting/api/PatternRegistry$Save;", "seed", "", "load", "tag", "Lnet/minecraft/nbt/CompoundTag;", "missingAny", "", "lookup", "", "", "Lkotlin/Pair;", "Lnet/minecraft/resources/ResourceLocation;", "Lat/petrak/hexcasting/api/spell/math/HexDir;", "scrungle", "", "prototype", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "opId", "hexcasting-forge-1.18.2"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            public final boolean missingAny(@NotNull Map<String, Pair<ResourceLocation, HexDir>> lookup) {
                boolean bl;
                block4: {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(lookup, (String)"lookup");
                    Iterable $this$map$iv = lookup.values();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add((ResourceLocation)it.getFirst());
                    }
                    List allIds = (List)destination$iv$iv;
                    Iterable $this$any$iv = perWorldPatternLookup.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PerWorldEntry it = (PerWorldEntry)element$iv;
                            boolean bl3 = false;
                            if (!(!allIds.contains(it.getOpId()))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            @NotNull
            public final Save load(@NotNull CompoundTag tag) {
                boolean bl;
                HashMap map;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                    map = new HashMap();
                    Set allIds = new LinkedHashSet();
                    for (String sig : tag.m_128431_()) {
                        ResourceLocation opId;
                        CompoundTag entry = tag.m_128469_(sig);
                        if (ResourceLocation.m_135820_((String)entry.m_128461_(PatternRegistry.TAG_OP_ID)) == null) continue;
                        allIds.add(opId);
                        HexDir startDir = (HexDir)HexUtils.getSafe$default((Enum[])HexDir.values(), entry.m_128445_(PatternRegistry.TAG_START_DIR), null, 2, null);
                        Map map2 = map;
                        Intrinsics.checkNotNullExpressionValue((Object)sig, (String)"sig");
                        map2.put(sig, TuplesKt.to((Object)opId, (Object)((Object)startDir)));
                    }
                    Iterable $this$any$iv = perWorldPatternLookup.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PerWorldEntry it = (PerWorldEntry)element$iv;
                            boolean bl2 = false;
                            if (!(!allIds.contains(it.getOpId()))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                boolean missingEntries = bl;
                return new Save(map, missingEntries);
            }

            public final void scrungle(@NotNull Map<String, Pair<ResourceLocation, HexDir>> lookup, @NotNull HexPattern prototype, @NotNull ResourceLocation opId, long seed) {
                Intrinsics.checkNotNullParameter(lookup, (String)"lookup");
                Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
                Intrinsics.checkNotNullParameter((Object)opId, (String)"opId");
                HexPattern scrungled2 = EulerPathFinder.findAltDrawing(prototype, seed, (Function1<? super HexPattern, Boolean>)((Function1)new Function1<HexPattern, Boolean>(lookup){
                    final /* synthetic */ Map<String, Pair<ResourceLocation, HexDir>> $lookup;
                    {
                        this.$lookup = $lookup;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull HexPattern it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String sig = it.anglesSignature();
                        if (!this.$lookup.containsKey(sig) && !((Map)PatternRegistry.access$getRegularPatternLookup$p()).containsKey(sig)) {
                            boolean bl2;
                            block5: {
                                Iterable $this$none$iv = PatternRegistry.access$getSpecialHandlers$p();
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl2 = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        SpecialHandlerEntry handler = (SpecialHandlerEntry)element$iv;
                                        boolean bl3 = false;
                                        if (!(handler.getHandler().handlePattern(it) != null)) continue;
                                        bl2 = false;
                                        break block5;
                                    }
                                    bl2 = true;
                                }
                            }
                            if (bl2) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                }));
                lookup.put(scrungled2.anglesSignature(), (Pair<ResourceLocation, HexDir>)TuplesKt.to((Object)opId, (Object)((Object)scrungled2.getStartDir())));
            }

            @JvmStatic
            @NotNull
            public final Save create(long seed) {
                Map map = new LinkedHashMap();
                for (PerWorldEntry perWorldEntry : perWorldPatternLookup.values()) {
                    HexPattern prototype = perWorldEntry.component1();
                    ResourceLocation opId = perWorldEntry.component2();
                    this.scrungle(map, prototype, opId, seed);
                }
                Save save = new Save(map);
                save.m_77762_();
                return save;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

