/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player.display;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ParticleIndicators;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class ClaimDisplay {
    private int displayTime;
    private final int height;
    private final DisplayBox display;
    public final EnumDisplayType type;
    private int[][] corners;
    private int[][] middlePoss;
    private DisplayBox.Box prevDims;
    private final DustParticleOptions corner;
    private final DustParticleOptions middle;

    public ClaimDisplay(Claim claim, EnumDisplayType type, int y) {
        this(claim.display(), (Level)claim.getWorld(), type, y);
    }

    public ClaimDisplay(DisplayBox display, Level level, EnumDisplayType type, int y) {
        this.display = display;
        this.displayTime = ConfigHandler.config.claimDisplayTime;
        this.prevDims = display.box();
        this.type = type;
        this.height = Math.max(1 + level.m_141937_(), y);
        switch (type) {
            case SUB: {
                this.corner = ParticleIndicators.SUBCLAIMCORNER;
                this.middle = ParticleIndicators.SUBCLAIMMIDDLE;
                break;
            }
            case CONFLICT: {
                this.corner = ParticleIndicators.OVERLAPCLAIM;
                this.middle = ParticleIndicators.OVERLAPCLAIM;
                break;
            }
            case EDIT: {
                this.corner = ParticleIndicators.EDITCLAIMCORNER;
                this.middle = ParticleIndicators.EDITCLAIMMIDDLE;
                break;
            }
            default: {
                this.corner = ParticleIndicators.CLAIMCORNER;
                this.middle = ParticleIndicators.CLAIMMIDDLE;
            }
        }
    }

    public boolean display(ServerPlayer player, boolean remove) {
        if (--this.displayTime % 2 == 0) {
            return this.display.isRemoved();
        }
        DisplayBox.Box dims = this.display.box();
        if (this.corners == null || this.changed(dims)) {
            this.middlePoss = ClaimDisplay.calculateDisplayPos(player.m_183503_(), dims, this.height, this.display.excludedSides());
            this.corners = new int[][]{ClaimDisplay.getPosFrom(player.m_183503_(), dims.minX(), dims.minZ(), this.height), ClaimDisplay.getPosFrom(player.m_183503_(), dims.maxX(), dims.minZ(), this.height), ClaimDisplay.getPosFrom(player.m_183503_(), dims.minX(), dims.maxZ(), this.height), ClaimDisplay.getPosFrom(player.m_183503_(), dims.maxX(), dims.maxZ(), this.height)};
        }
        for (int[] pos : this.corners) {
            if (pos[1] != pos[2]) {
                player.f_8906_.m_141995_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.corner, true, (double)pos[0] + 0.5, (double)pos[2] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
            }
            player.f_8906_.m_141995_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.corner, true, (double)pos[0] + 0.5, (double)pos[1] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
        }
        if (this.middlePoss != null) {
            for (int[] pos : this.middlePoss) {
                if (pos[1] != pos[2]) {
                    player.f_8906_.m_141995_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.middle, true, (double)pos[0] + 0.5, (double)pos[2] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
                }
                player.f_8906_.m_141995_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)this.middle, true, (double)pos[0] + 0.5, (double)pos[1] + 0.25, (double)pos[3] + 0.5, 0.0f, 0.5f, 0.0f, 0.0f, 1));
            }
        }
        this.prevDims = dims;
        return this.display.isRemoved() || remove && this.displayTime < 0;
    }

    private boolean changed(DisplayBox.Box dims) {
        return !this.prevDims.equals(dims);
    }

    public static int[][] calculateDisplayPos(ServerLevel world, DisplayBox.Box from, int height, Set<Direction> exclude) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        HashSet<Integer> xs = new HashSet<Integer>();
        ClaimDisplay.addEvenly(from.minX(), from.maxX(), 10, xs);
        xs.add(from.minX() + 1);
        xs.add(from.maxX() - 1);
        HashSet<Integer> zs = new HashSet<Integer>();
        ClaimDisplay.addEvenly(from.minZ(), from.maxZ(), 10, zs);
        zs.add(from.minZ() + 1);
        zs.add(from.maxZ() - 1);
        Iterator iterator = xs.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            if (!exclude.contains(Direction.NORTH)) {
                l.add(ClaimDisplay.getPosFrom(world, x, from.minZ(), height));
            }
            if (exclude.contains(Direction.SOUTH)) continue;
            l.add(ClaimDisplay.getPosFrom(world, x, from.maxZ(), height));
        }
        iterator = zs.iterator();
        while (iterator.hasNext()) {
            int z = (Integer)iterator.next();
            if (!exclude.contains(Direction.WEST)) {
                l.add(ClaimDisplay.getPosFrom(world, from.minX(), z, height));
            }
            if (exclude.contains(Direction.EAST)) continue;
            l.add(ClaimDisplay.getPosFrom(world, from.maxX(), z, height));
        }
        return (int[][])l.toArray((T[])new int[0][]);
    }

    private static void addEvenly(int min, int max, int step, Set<Integer> l) {
        if ((double)(max - min) < (double)step * 1.5) {
            return;
        }
        if (max - min > 0 && (double)(max - min) <= (double)step * 0.5) {
            l.add(max - step + 1);
            l.add(min + step - 1);
            return;
        }
        l.add(max - step);
        l.add(min + step);
        ClaimDisplay.addEvenly(min + step, max - step, step, l);
    }

    public static int[] getPosFrom(ServerLevel world, int x, int z, int maxY) {
        LevelChunk chunk = world.m_6325_(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z));
        int[] y = ClaimDisplay.nextAirAndWaterBlockFrom(chunk, x, maxY, z);
        return new int[]{x, y[0], y[1], z};
    }

    private static int[] nextAirAndWaterBlockFrom(LevelChunk chunk, int x, int y, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState state = chunk.m_8055_((BlockPos)pos);
        if (state.m_60767_().m_76336_()) {
            boolean startedInLiquid = state.m_60767_().m_76332_();
            boolean liquidCheck = false;
            int liquidHeight = pos.m_123342_();
            while (state.m_60767_().m_76336_() && !chunk.m_151570_((BlockPos)pos)) {
                pos.m_122184_(0, -1, 0);
                state = chunk.m_8055_((BlockPos)pos);
                if (startedInLiquid || liquidCheck || !state.m_60767_().m_76332_()) continue;
                liquidCheck = true;
                liquidHeight = pos.m_123342_();
            }
            int[] yRet = new int[]{pos.m_123342_() + 1, (liquidCheck ? liquidHeight : pos.m_123342_()) + 1};
            if (startedInLiquid) {
                pos.m_122178_(pos.m_123341_(), liquidHeight + 1, pos.m_123343_());
                state = chunk.m_8055_((BlockPos)pos);
                while (state.m_60767_().m_76332_() && !chunk.m_151570_((BlockPos)pos)) {
                    pos.m_122184_(0, 1, 0);
                    state = chunk.m_8055_((BlockPos)pos);
                }
                if (state.m_60767_().m_76336_()) {
                    yRet[1] = pos.m_123342_();
                }
            }
            return yRet;
        }
        while (!state.m_60767_().m_76336_() && !chunk.m_151570_((BlockPos)pos)) {
            pos.m_122184_(0, 1, 0);
            state = chunk.m_8055_((BlockPos)pos);
        }
        int[] yRet = new int[]{pos.m_123342_(), pos.m_123342_()};
        while (state.m_60767_().m_76332_() && !chunk.m_151570_((BlockPos)pos)) {
            pos.m_122184_(0, 1, 0);
            state = chunk.m_8055_((BlockPos)pos);
        }
        if (state.m_60767_().m_76336_()) {
            yRet[1] = pos.m_123342_();
        }
        return yRet;
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClaimDisplay) {
            return this.display.equals(((ClaimDisplay)obj).display);
        }
        return false;
    }
}

