/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ServerScreenHelper {
    public static ItemStack emptyFiller() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42183_);
        stack.m_41714_((Component)PermHelper.simpleColoredText("", new ChatFormatting[0]));
        return stack;
    }

    public static ItemStack fromPermission(Claim claim, ClaimPermission perm, String group) {
        ItemStack stack = perm.getItem();
        stack.m_41714_(ServerScreenHelper.coloredGuiText(perm.id, ChatFormatting.GOLD));
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String pdesc : ConfigHandler.langManager.getArray(perm.id + ".desc")) {
            Component trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add(trans);
        }
        Config.GlobalType global = ConfigHandler.config.getGlobal(claim.getWorld(), perm);
        if (!claim.isAdminClaim() && !global.canModify()) {
            Component text = ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenUneditable"), ChatFormatting.DARK_RED);
            lore.add(text);
            String permFlag = global.getValue() ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse");
            Component text2 = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenEnableText"), permFlag), permFlag.equals(ConfigHandler.langManager.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add(text2);
        } else {
            Object permFlag;
            if (group == null) {
                if (claim.parentClaim() == null) {
                    permFlag = "" + (claim.permEnabled(perm) == 1);
                } else {
                    permFlag = switch (claim.permEnabled(perm)) {
                        case -1 -> ConfigHandler.langManager.get("screenDefault");
                        case 1 -> ConfigHandler.langManager.get("screenTrue");
                        default -> ConfigHandler.langManager.get("screenFalse");
                    };
                }
            } else {
                permFlag = switch (claim.groupHasPerm(group, perm)) {
                    case -1 -> ConfigHandler.langManager.get("screenDefault");
                    case 1 -> ConfigHandler.langManager.get("screenTrue");
                    default -> ConfigHandler.langManager.get("screenFalse");
                };
            }
            Component text = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenEnableText"), permFlag), ((String)permFlag).equals(ConfigHandler.langManager.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add(text);
        }
        ServerScreenHelper.addLore(stack, lore);
        return stack;
    }

    public static ItemStack getFromPersonal(ServerPlayer player, ClaimPermission perm, String group) {
        ItemStack stack = perm.getItem();
        stack.m_41714_(ServerScreenHelper.coloredGuiText(perm.id, ChatFormatting.GOLD));
        ListTag lore = new ListTag();
        for (String pdesc : ConfigHandler.langManager.getArray(perm.id + ".desc")) {
            Component trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)trans)));
        }
        Config.GlobalType global = ConfigHandler.config.getGlobal(player.m_183503_(), perm);
        if (!global.canModify()) {
            Component text = ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenUneditable"), ChatFormatting.DARK_RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
            String permFlag = String.valueOf(global.getValue());
            Component text2 = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenEnableText"), permFlag), permFlag.equals(ConfigHandler.langManager.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text2)));
        } else {
            Map map = PlayerClaimData.get(player).playerDefaultGroups().getOrDefault(group, new HashMap());
            String permFlag = map.containsKey(perm) ? ((Boolean)map.get(perm) != false ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")) : ConfigHandler.langManager.get("screenDefault");
            Component text = ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenEnableText"), permFlag), permFlag.equals(ConfigHandler.langManager.get("screenTrue")) ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
        }
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
        return stack;
    }

    public static void playSongToPlayer(ServerPlayer player, SoundEvent event, float vol, float pitch) {
        player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(event, SoundSource.PLAYERS, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, vol, pitch));
    }

    public static Component coloredGuiText(String text, ChatFormatting ... formattings) {
        return new TextComponent(text).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131152_(formattings));
    }

    public static void addLore(ItemStack stack, Component text) {
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
    }

    public static void addLore(ItemStack stack, List<Component> texts) {
        ListTag lore = new ListTag();
        texts.forEach(text -> lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text))));
        stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
    }
}

