/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.PersonalGroupScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PersonalPermissionScreenHandler
extends ServerOnlyScreenHandler<String> {
    private final String group;
    private int page;
    private final Player player;

    private PersonalPermissionScreenHandler(int syncId, Inventory playerInventory, String group) {
        super(syncId, playerInventory, 6, group);
        this.group = group;
        this.player = playerInventory.f_35978_;
    }

    public static void openClaimMenu(Player player, final String group) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new PersonalPermissionScreenHandler(syncId, inv, group);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("screenPersonalPermissions"), group), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, String group) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ArrayList<ClaimPermission> perms = new ArrayList<ClaimPermission>(PermissionRegistry.getPerms());
        if (this.group != null) {
            perms.removeAll(PermissionRegistry.globalPerms());
        }
        for (int i = 0; i < 54; ++i) {
            int page = 0;
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), ChatFormatting.DARK_RED));
                inv.updateStack(i, close);
                continue;
            }
            if (page == 1 && i == 47) {
                ItemStack close = new ItemStack((ItemLike)Items.f_42412_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenPrevious"), ChatFormatting.WHITE));
                inv.updateStack(i, close);
                continue;
            }
            if (page == 0 && i == 51) {
                ItemStack close = new ItemStack((ItemLike)Items.f_42412_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNext"), ChatFormatting.WHITE));
                inv.updateStack(i, close);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + page * 28;
            if (id >= perms.size()) continue;
            inv.updateStack(i, ServerScreenHelper.getFromPersonal((ServerPlayer)player, (ClaimPermission)perms.get(id), group));
        }
    }

    private void flipPage() {
        if (!(this.player instanceof ServerPlayer)) {
            return;
        }
        ArrayList<ClaimPermission> perms = new ArrayList<ClaimPermission>(PermissionRegistry.getPerms());
        if (this.group != null) {
            perms.removeAll(PermissionRegistry.globalPerms());
        }
        int maxPages = perms.size() / 28;
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(close);
                continue;
            }
            if (i == 47) {
                ItemStack stack = ServerScreenHelper.emptyFiller();
                if (this.page >= 1) {
                    stack = new ItemStack((ItemLike)Items.f_42412_);
                    stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenPrevious"), ChatFormatting.WHITE));
                }
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i == 51) {
                ItemStack stack = ServerScreenHelper.emptyFiller();
                if (this.page < maxPages) {
                    stack = new ItemStack((ItemLike)Items.f_42412_);
                    stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNext"), ChatFormatting.WHITE));
                }
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.page * 28;
            if (id < perms.size()) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.getFromPersonal((ServerPlayer)this.player, (ClaimPermission)perms.get(id), this.group));
                continue;
            }
            ((Slot)this.f_38839_.get(i)).m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        ClaimPermission perm;
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> PersonalGroupScreenHandler.openGroupMenu((Player)player));
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 47) {
            this.page = 0;
            this.flipPage();
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
        }
        if (index == 51) {
            this.page = 1;
            this.flipPage();
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
        }
        ItemStack stack = slot.m_7993_();
        String name = stack.m_41786_().m_6111_();
        try {
            perm = PermissionRegistry.get(name);
        }
        catch (NullPointerException e) {
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        Map perms = data.playerDefaultGroups().getOrDefault(this.group, new HashMap());
        boolean success = data.editDefaultPerms(this.group, perm, (perms.containsKey(perm) ? (((Boolean)perms.get(perm)).booleanValue() ? 1 : 0) : -1) + 1);
        slot.m_5852_(ServerScreenHelper.getFromPersonal(player, perm, this.group));
        if (success) {
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12216_, 1.0f, 1.2f);
        } else {
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || this.page == 1 && slot == 47 || this.page == 0 && slot == 51 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }
}

