/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimTextHandler;
import io.github.flemmli97.flan.gui.ConfirmScreenHandler;
import io.github.flemmli97.flan.gui.FakePlayerScreenHandler;
import io.github.flemmli97.flan.gui.GroupScreenHandler;
import io.github.flemmli97.flan.gui.PermissionScreenHandler;
import io.github.flemmli97.flan.gui.PotionEditScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import io.github.flemmli97.flan.player.PlayerClaimData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ClaimMenuScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private final Claim claim;

    private ClaimMenuScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 1, claim);
        this.claim = claim;
    }

    public static void openClaimMenu(ServerPlayer player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new ClaimMenuScreenHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(claim.parentClaim() != null ? ConfigHandler.langManager.get("screenMenuSub") : ConfigHandler.langManager.get("screenMenu"), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, Claim claim) {
        block9: for (int i = 0; i < 9; ++i) {
            switch (i) {
                case 0: {
                    ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                    close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenClose"), ChatFormatting.DARK_RED));
                    inv.updateStack(i, close);
                    continue block9;
                }
                case 2: {
                    ItemStack perm = new ItemStack((ItemLike)Items.f_42065_);
                    perm.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenMenuGlobal"), ChatFormatting.GOLD));
                    if (player instanceof ServerPlayer && !this.hasEditPerm(claim, (ServerPlayer)player)) {
                        ServerScreenHelper.addLore(perm, ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNoPerm"), ChatFormatting.DARK_RED));
                    }
                    inv.updateStack(i, perm);
                    continue block9;
                }
                case 3: {
                    ItemStack group = new ItemStack((ItemLike)Items.f_42614_);
                    group.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenMenuGroup"), ChatFormatting.GOLD));
                    if (player instanceof ServerPlayer && !this.hasEditPerm(claim, (ServerPlayer)player)) {
                        ServerScreenHelper.addLore(group, ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNoPerm"), ChatFormatting.DARK_RED));
                    }
                    inv.updateStack(i, group);
                    continue block9;
                }
                case 4: {
                    ItemStack potions = new ItemStack((ItemLike)Items.f_42589_);
                    potions.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenMenuPotion"), ChatFormatting.GOLD));
                    if (player instanceof ServerPlayer && !this.hasPerm(claim, (ServerPlayer)player, PermissionRegistry.EDITPOTIONS)) {
                        ServerScreenHelper.addLore(potions, ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNoPerm"), ChatFormatting.DARK_RED));
                    }
                    inv.updateStack(i, potions);
                    continue block9;
                }
                case 5: {
                    ItemStack sign = new ItemStack((ItemLike)Items.f_42438_);
                    sign.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenMenuClaimText"), ChatFormatting.GOLD));
                    if (player instanceof ServerPlayer && !this.hasPerm(claim, (ServerPlayer)player, PermissionRegistry.EDITCLAIM)) {
                        ServerScreenHelper.addLore(sign, ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNoPerm"), ChatFormatting.DARK_RED));
                    }
                    inv.updateStack(i, sign);
                    continue block9;
                }
                case 6: {
                    ItemStack head = new ItemStack((ItemLike)Items.f_42681_);
                    head.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenMenuFakePlayers"), ChatFormatting.GOLD));
                    if (player instanceof ServerPlayer && !this.hasPerm(claim, (ServerPlayer)player, PermissionRegistry.EDITPERMS)) {
                        ServerScreenHelper.addLore(head, ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNoPerm"), ChatFormatting.DARK_RED));
                    }
                    inv.updateStack(i, head);
                    continue block9;
                }
                case 8: {
                    ItemStack delete = new ItemStack((ItemLike)Items.f_42127_);
                    delete.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenMenuDelete"), ChatFormatting.RED));
                    if (player instanceof ServerPlayer && !this.hasPerm(claim, (ServerPlayer)player, PermissionRegistry.EDITCLAIM)) {
                        ServerScreenHelper.addLore(delete, ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNoPerm"), ChatFormatting.DARK_RED));
                    }
                    inv.updateStack(i, delete);
                    continue block9;
                }
                default: {
                    inv.updateStack(i, ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 2 || slot == 3 || slot == 4 || slot == 5 || slot == 6 || slot == 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        switch (index) {
            case 0: {
                player.m_6915_();
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
                break;
            }
            case 2: {
                if (this.hasEditPerm(this.claim, player)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> PermissionScreenHandler.openClaimMenu((Player)player, this.claim, null));
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 3: {
                if (this.hasEditPerm(this.claim, player)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, this.claim));
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 4: {
                if (this.hasPerm(this.claim, player, PermissionRegistry.EDITPOTIONS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> PotionEditScreenHandler.openPotionMenu((Player)player, this.claim));
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 5: {
                if (this.hasPerm(this.claim, player, PermissionRegistry.CLAIMMESSAGE)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> ClaimTextHandler.openClaimMenu(player, this.claim));
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 6: {
                if (this.hasPerm(this.claim, player, PermissionRegistry.EDITPERMS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> FakePlayerScreenHandler.open((Player)player, this.claim));
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 8: {
                if (this.hasPerm(this.claim, player, PermissionRegistry.EDITCLAIM)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> ConfirmScreenHandler.openConfirmScreen(player, bool -> {
                        if (bool.booleanValue()) {
                            ClaimStorage storage = ClaimStorage.get(player.m_183503_());
                            storage.deleteClaim(this.claim, true, PlayerClaimData.get(player).getEditMode(), player.m_183503_());
                            player.m_6915_();
                            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("deleteClaim"), ChatFormatting.RED), false);
                            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11669_, 1.0f, 1.0f);
                        } else {
                            player.m_6915_();
                            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
                            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                        }
                    }));
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }
        }
        return true;
    }

    private boolean hasEditPerm(Claim claim, ServerPlayer player) {
        return claim.parentClaim() != null && claim.parentClaim().canInteract(player, PermissionRegistry.EDITPERMS, player.m_142538_()) || claim.canInteract(player, PermissionRegistry.EDITPERMS, player.m_142538_());
    }

    private boolean hasPerm(Claim claim, ServerPlayer player, ClaimPermission perm) {
        if (claim.parentClaim() != null) {
            return claim.parentClaim().canInteract(player, perm, player.m_142538_());
        }
        return claim.canInteract(player, perm, player.m_142538_());
    }
}

