/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.gui.LockedLecternScreenHandler;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import io.github.flemmli97.flan.utils.BlockBreakAttemptHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockInteractEvents {
    public static InteractionResult startBreakBlocks(Player player, Level world, InteractionHand hand, BlockPos pos, Direction direction) {
        InteractionResult result;
        BlockState state = world.m_8055_(pos);
        InteractionResult interactionResult = result = BlockInteractEvents.breakBlocks(world, player, pos, state, world.m_7702_(pos), true) ? InteractionResult.PASS : InteractionResult.FAIL;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean failed = player.m_7500_() || result == InteractionResult.FAIL;
            ((BlockBreakAttemptHandler)serverPlayer.f_8941_).setBlockBreakAttemptFail((BlockPos)(failed ? pos : null), failed && state.m_60625_(player, (BlockGetter)world, pos) >= 1.0f);
        }
        return result;
    }

    public static boolean breakBlocks(Level world, Player p, BlockPos pos, BlockState state, BlockEntity tile) {
        if (!BlockInteractEvents.breakBlocks(world, p, pos, world.m_8055_(pos), world.m_7702_(pos), false)) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (p instanceof ServerPlayer) {
                Packet updatePacket;
                ServerPlayer player = (ServerPlayer)p;
                if (blockEntity != null && (updatePacket = blockEntity.m_183216_()) != null) {
                    player.f_8906_.m_141995_(updatePacket);
                }
            }
            return false;
        }
        return true;
    }

    public static boolean breakBlocks(Level world, Player p, BlockPos pos, BlockState state, BlockEntity tile, boolean attempt) {
        ServerPlayer player;
        block9: {
            block8: {
                if (!(p instanceof ServerPlayer)) break block8;
                player = (ServerPlayer)p;
                if (!p.m_5833_()) break block9;
            }
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        if (claim != null) {
            ClaimPermission perm;
            ResourceLocation id = CrossPlatformStuff.INSTANCE.registryBlocks().getIDFrom(state.m_60734_());
            if (BlockInteractEvents.contains(id, world.m_7702_(pos), ConfigHandler.config.breakBlockBlacklist, ConfigHandler.config.breakBETagBlacklist)) {
                return true;
            }
            if (attempt && (perm = ObjectToPermissionMap.getForLeftClickBlock(state.m_60734_())) != null) {
                if (!claim.canInteract(player, perm, pos, true)) {
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_142538_().m_123342_());
                    return false;
                }
                return true;
            }
            if (!claim.canInteract(player, PermissionRegistry.BREAK, pos, true)) {
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_142538_().m_123342_());
                return false;
            }
        }
        return true;
    }

    public static InteractionResult useBlocks(Player p, Level world, InteractionHand hand, BlockHitResult hitResult) {
        if (!(p instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer player = (ServerPlayer)p;
        ItemStack stack = player.m_21120_(hand);
        if (ConfigHandler.isClaimingTool(stack)) {
            ItemInteractEvents.claimLandHandling(player, hitResult.m_82425_());
            return InteractionResult.SUCCESS;
        }
        if (ConfigHandler.isInspectionTool(stack)) {
            ItemInteractEvents.inspect(player, hitResult.m_82425_());
            return InteractionResult.SUCCESS;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        IPermissionContainer claim = storage.getForPermissionCheck(hitResult.m_82425_());
        if (claim != null) {
            BlockEntity blockEntity;
            BlockState state = world.m_8055_(hitResult.m_82425_());
            ResourceLocation id = CrossPlatformStuff.INSTANCE.registryBlocks().getIDFrom(state.m_60734_());
            if (BlockInteractEvents.contains(id, blockEntity = world.m_7702_(hitResult.m_82425_()), ConfigHandler.config.interactBlockBlacklist, ConfigHandler.config.interactBETagBlacklist)) {
                return InteractionResult.PASS;
            }
            ClaimPermission perm = ObjectToPermissionMap.getFromBlock(state.m_60734_());
            if (perm == PermissionRegistry.PROJECTILES) {
                perm = PermissionRegistry.OPENCONTAINER;
            }
            if (perm != null && perm != PermissionRegistry.PRESSUREPLATE) {
                if (claim.canInteract(player, perm, hitResult.m_82425_(), true)) {
                    return InteractionResult.PASS;
                }
                if (state.m_60734_() instanceof DoorBlock) {
                    DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)DoorBlock.f_52730_);
                    if (half == DoubleBlockHalf.LOWER) {
                        BlockState other = world.m_8055_(hitResult.m_82425_().m_7494_());
                        player.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(hitResult.m_82425_().m_7494_(), other));
                    } else {
                        BlockState other = world.m_8055_(hitResult.m_82425_().m_7495_());
                        player.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(hitResult.m_82425_().m_7495_(), other));
                    }
                }
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_142538_().m_123342_());
                BlockInteractEvents.executeSignCommand(blockEntity, player);
                return InteractionResult.FAIL;
            }
            if (blockEntity != null && (!player.m_36341_() || stack.m_41619_())) {
                if (blockEntity instanceof LecternBlockEntity) {
                    if (claim.canInteract(player, PermissionRegistry.LECTERNTAKE, hitResult.m_82425_(), false)) {
                        return InteractionResult.PASS;
                    }
                    if (((Boolean)state.m_61143_((Property)LecternBlock.f_54467_)).booleanValue()) {
                        LockedLecternScreenHandler.create(player, (LecternBlockEntity)blockEntity);
                    }
                    return InteractionResult.FAIL;
                }
                if (blockEntity instanceof SignBlockEntity) {
                    if (claim.canInteract(player, PermissionRegistry.INTERACTSIGN, hitResult.m_82425_(), false)) {
                        return InteractionResult.PASS;
                    }
                    return InteractionResult.FAIL;
                }
                if (!ConfigHandler.config.lenientBlockEntityCheck || CrossPlatformStuff.INSTANCE.isInventoryTile(blockEntity)) {
                    if (claim.canInteract(player, PermissionRegistry.OPENCONTAINER, hitResult.m_82425_(), true)) {
                        return InteractionResult.PASS;
                    }
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_142538_().m_123342_());
                    return InteractionResult.FAIL;
                }
            }
            boolean shift = player.m_36341_() || stack.m_41619_();
            boolean res = claim.canInteract(player, PermissionRegistry.INTERACTBLOCK, hitResult.m_82425_(), shift);
            if (!res) {
                if (shift) {
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_142538_().m_123342_());
                }
                BlockInteractEvents.executeSignCommand(blockEntity, player);
            }
            return res ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private static void executeSignCommand(BlockEntity blockEntity, ServerPlayer player) {
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            sign.m_155709_(player);
        }
    }

    public static boolean contains(ResourceLocation id, BlockEntity blockEntity, List<String> idList, List<String> tagList) {
        if (idList.contains(id.m_135827_()) || idList.contains(id.toString())) {
            return true;
        }
        if (blockEntity != null && !tagList.isEmpty()) {
            CompoundTag nbt = blockEntity.m_187482_();
            return tagList.stream().anyMatch(tag -> CrossPlatformStuff.INSTANCE.blockDataContains(nbt, (String)tag));
        }
        return false;
    }

    public static boolean cancelEntityBlockCollision(BlockState state, Level world, BlockPos pos, Entity entity) {
        Entity owner;
        if (world.f_46443_) {
            return false;
        }
        ServerPlayer player = null;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
        } else if (entity instanceof Projectile) {
            owner = ((Projectile)entity).m_37282_();
            if (owner instanceof ServerPlayer) {
                player = (ServerPlayer)owner;
            }
        } else if (entity instanceof ItemEntity && (owner = ((ServerLevel)world).m_8791_(((ItemEntity)entity).m_32057_())) instanceof ServerPlayer) {
            player = (ServerPlayer)owner;
        }
        if (player == null) {
            return false;
        }
        ClaimPermission perm = ObjectToPermissionMap.getFromBlock(state.m_60734_());
        if (perm == null) {
            return false;
        }
        if (perm != PermissionRegistry.PRESSUREPLATE && perm != PermissionRegistry.PORTAL) {
            return false;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        if (claim != null) {
            return !claim.canInteract(player, perm, pos, false);
        }
        return false;
    }

    public static boolean preventFallOn(Entity entity, double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        Entity owner;
        if (entity.f_19853_.f_46443_) {
            return false;
        }
        if (entity instanceof ServerPlayer) {
            ClaimPermission perm = ObjectToPermissionMap.getFromBlock(landedState.m_60734_());
            if (perm != PermissionRegistry.TRAMPLE) {
                return false;
            }
            ClaimStorage storage = ClaimStorage.get((ServerLevel)entity.f_19853_);
            IPermissionContainer claim = storage.getForPermissionCheck(landedPosition);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((ServerPlayer)entity, perm, landedPosition, true);
        }
        if (entity instanceof Projectile && (owner = ((Projectile)entity).m_37282_()) instanceof ServerPlayer) {
            ClaimPermission perm = ObjectToPermissionMap.getFromBlock(landedState.m_60734_());
            if (perm != PermissionRegistry.TRAMPLE) {
                return false;
            }
            ClaimStorage storage = ClaimStorage.get((ServerLevel)entity.f_19853_);
            IPermissionContainer claim = storage.getForPermissionCheck(landedPosition);
            return !claim.canInteract((ServerPlayer)owner, perm, landedPosition, true);
        }
        return false;
    }

    public static boolean canBreakTurtleEgg(Level world, BlockPos pos, Entity entity) {
        Entity owner;
        if (world.f_46443_) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (entity instanceof ServerPlayer) {
            ClaimStorage storage = ClaimStorage.get(serverWorld);
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((ServerPlayer)entity, PermissionRegistry.TRAMPLE, pos, true);
        }
        if (entity instanceof Projectile) {
            Entity owner2 = ((Projectile)entity).m_37282_();
            if (owner2 instanceof ServerPlayer) {
                ClaimStorage storage = ClaimStorage.get(serverWorld);
                IPermissionContainer claim = storage.getForPermissionCheck(pos);
                if (claim == null) {
                    return false;
                }
                return !claim.canInteract((ServerPlayer)owner2, PermissionRegistry.TRAMPLE, pos, true);
            }
        } else if (entity instanceof ItemEntity && (owner = serverWorld.m_8791_(((ItemEntity)entity).m_32057_())) instanceof ServerPlayer) {
            ClaimStorage storage = ClaimStorage.get(serverWorld);
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((ServerPlayer)owner, PermissionRegistry.TRAMPLE, pos, true);
        }
        return false;
    }
}

