/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class BuySellHandler {
    private static int[] xpCalc;
    private Type buyType = Type.MONEY;
    private Type sellType = Type.MONEY;
    private float buyAmount = -1.0f;
    private float sellAmount = -1.0f;
    private Ingredient ingredient = Ingredient.f_43901_;

    public boolean buy(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.buyAmount == -1.0f) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyDisabled"), ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (ConfigHandler.config.maxBuyBlocks >= 0 && data.getAdditionalClaims() + blocks > ConfigHandler.config.maxBuyBlocks) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyLimit"), ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.buyType) {
            case MONEY: {
                return CommandCurrency.INSTANCE.buyClaimBlocks(player, blocks, this.buyAmount, message);
            }
            case ITEM: {
                int deduct = Mth.m_14167_((float)((float)blocks * this.buyAmount));
                ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
                int i = 0;
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!this.ingredient.test(stack) || stack.m_41763_() && stack.m_41773_() != 0 || !this.isJustRenamedItem(stack)) continue;
                    matching.add(stack);
                    i += stack.m_41613_();
                }
                if (i < deduct) {
                    message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyFailItem"), ChatFormatting.DARK_RED));
                    return false;
                }
                i = deduct;
                for (ItemStack stack : matching) {
                    if (i > stack.m_41613_()) {
                        int count = stack.m_41613_();
                        stack.m_41764_(0);
                        i -= count;
                        continue;
                    }
                    stack.m_41774_(i);
                    break;
                }
                data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("buySuccessItem"), blocks, deduct), new ChatFormatting[0]));
                return true;
            }
            case XP: {
                int deduct = Mth.m_14167_((float)((float)blocks * this.buyAmount));
                if ((float)deduct < (float)BuySellHandler.totalXpPointsForLevel(player.f_36078_) + player.f_36080_ * (float)BuySellHandler.xpForLevel(player.f_36078_ + 1)) {
                    player.m_6756_(-deduct);
                    data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                    message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("buySuccessXP"), blocks, deduct), new ChatFormatting[0]));
                    return true;
                }
                message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyFailXP"), ChatFormatting.DARK_RED));
                return false;
            }
        }
        return false;
    }

    public boolean sell(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.sellAmount == -1.0f) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("sellDisabled"), ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("sellFail"), ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.sellType) {
            case MONEY: {
                return CommandCurrency.INSTANCE.sellClaimBlocks(player, blocks, this.sellAmount, message);
            }
            case ITEM: {
                ItemStack[] stacks = this.ingredient.m_43908_();
                if (this.ingredient.m_43947_()) {
                    return false;
                }
                int amount = Mth.m_14143_((float)((float)blocks * this.sellAmount));
                ItemStack stack = stacks[0];
                while (amount > 0) {
                    ItemEntity itemEntity;
                    boolean bl;
                    ItemStack toGive = stack.m_41777_();
                    if (amount > 64) {
                        toGive.m_41764_(64);
                        amount -= 64;
                    } else {
                        toGive.m_41764_(amount);
                        amount = 0;
                    }
                    if ((bl = player.m_150109_().m_36054_(toGive)) && toGive.m_41619_() || (itemEntity = player.m_36176_(toGive, false)) == null) continue;
                    itemEntity.m_32061_();
                    itemEntity.m_32047_(player.m_142081_());
                }
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((Component)new TranslatableComponent(ConfigHandler.langManager.get("sellSuccessItem"), new Object[]{blocks, amount, new TranslatableComponent(stack.m_41778_()).m_130940_(ChatFormatting.AQUA)}));
                return true;
            }
            case XP: {
                int amount = Mth.m_14143_((float)((float)blocks * this.buyAmount));
                player.m_6756_(amount);
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("sellSuccessXP"), blocks, amount), new ChatFormatting[0]));
                return false;
            }
        }
        return false;
    }

    private boolean isJustRenamedItem(ItemStack stack) {
        if (!stack.m_41782_()) {
            return true;
        }
        if (stack.m_41783_().m_128431_().stream().allMatch(s -> s.equals("Damage") || s.equals("RepairCost") || s.equals("display"))) {
            CompoundTag tag = stack.m_41783_().m_128469_("display");
            return tag.m_128441_("Name") && tag.m_128440_() == 1;
        }
        return true;
    }

    private static int totalXpPointsForLevel(int level) {
        if (xpCalc == null || level > xpCalc.length) {
            xpCalc = new int[level + 50];
            BuySellHandler.xpCalc[0] = 0;
            for (int i = 1; i < xpCalc.length; ++i) {
                BuySellHandler.xpCalc[i] = BuySellHandler.xpForLevel(i) + xpCalc[i - 1];
            }
        }
        return xpCalc[level];
    }

    private static int xpForLevel(int level) {
        if (--level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("buyType", this.buyType.toString());
        obj.addProperty("sellType", this.sellType.toString());
        obj.addProperty("buyValue", (Number)Float.valueOf(this.buyAmount));
        obj.addProperty("sellValue", (Number)Float.valueOf(this.sellAmount));
        obj.add("ingredient", this.ingredient.m_43942_());
        return obj;
    }

    public void fromJson(JsonObject object) {
        this.buyType = Type.valueOf(ConfigHandler.fromJson(object, "buyType", this.buyType.toString()));
        this.sellType = Type.valueOf(ConfigHandler.fromJson(object, "sellType", this.sellType.toString()));
        this.buyAmount = object.has("buyValue") ? object.get("buyValue").getAsFloat() : this.buyAmount;
        this.sellAmount = object.has("sellValue") ? object.get("sellValue").getAsFloat() : this.sellAmount;
        try {
            this.ingredient = object.has("ingredient") ? Ingredient.m_43917_((JsonElement)object.get("ingredient")) : Ingredient.f_43901_;
        }
        catch (JsonParseException e) {
            this.ingredient = Ingredient.f_43901_;
        }
    }

    static enum Type {
        MONEY,
        ITEM,
        XP;

    }
}

