/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PermissionRegistry {
    private static final Map<String, ClaimPermission> permissions = new LinkedHashMap<String, ClaimPermission>();
    private static final Map<String, ClaimPermission> globalPermissions = new LinkedHashMap<String, ClaimPermission>();
    private static final Map<ResourceLocation, ClaimPermission> interactBlocks = new HashMap<ResourceLocation, ClaimPermission>();
    private static final Map<ResourceLocation, ClaimPermission> breakBlocks = new HashMap<ResourceLocation, ClaimPermission>();
    private static final Map<ResourceLocation, ClaimPermission> items = new HashMap<ResourceLocation, ClaimPermission>();
    private static boolean locked;
    public static ClaimPermission EDITCLAIM;
    public static ClaimPermission EDITPERMS;
    public static ClaimPermission EDITPOTIONS;
    public static ClaimPermission BREAK;
    public static ClaimPermission PLACE;
    public static ClaimPermission OPENCONTAINER;
    public static ClaimPermission INTERACTBLOCK;
    public static ClaimPermission INTERACTSIGN;
    public static ClaimPermission ANVIL;
    public static ClaimPermission BED;
    public static ClaimPermission BEACON;
    public static ClaimPermission DOOR;
    public static ClaimPermission FENCEGATE;
    public static ClaimPermission TRAPDOOR;
    public static ClaimPermission BUTTONLEVER;
    public static ClaimPermission PRESSUREPLATE;
    public static ClaimPermission NOTEBLOCK;
    public static ClaimPermission REDSTONE;
    public static ClaimPermission JUKEBOX;
    public static ClaimPermission ENDERCHEST;
    public static ClaimPermission ENCHANTMENTTABLE;
    public static ClaimPermission ITEMFRAMEROTATE;
    public static ClaimPermission LECTERNTAKE;
    public static ClaimPermission ENDCRYSTALPLACE;
    public static ClaimPermission TARGETBLOCK;
    public static ClaimPermission PROJECTILES;
    public static ClaimPermission TRAMPLE;
    public static ClaimPermission FROSTWALKER;
    public static ClaimPermission PORTAL;
    public static ClaimPermission RAID;
    public static ClaimPermission BOAT;
    public static ClaimPermission MINECART;
    public static ClaimPermission BUCKET;
    public static ClaimPermission ENDERPEARL;
    public static ClaimPermission CHORUSFRUIT;
    public static ClaimPermission ANIMALINTERACT;
    public static ClaimPermission HURTANIMAL;
    public static ClaimPermission XP;
    public static ClaimPermission TRADING;
    public static ClaimPermission ARMORSTAND;
    public static ClaimPermission BREAKNONLIVING;
    public static ClaimPermission DROP;
    public static ClaimPermission PICKUP;
    public static ClaimPermission FLIGHT;
    public static ClaimPermission CANSTAY;
    public static ClaimPermission TELEPORT;
    public static ClaimPermission NOHUNGER;
    public static ClaimPermission CLAIMMESSAGE;
    public static ClaimPermission HURTPLAYER;
    public static ClaimPermission EXPLOSIONS;
    public static ClaimPermission WITHER;
    public static ClaimPermission ENDERMAN;
    public static ClaimPermission SNOWGOLEM;
    public static ClaimPermission FIRESPREAD;
    public static ClaimPermission WATERBORDER;
    public static ClaimPermission PISTONBORDER;
    public static ClaimPermission MOBSPAWN;
    public static ClaimPermission ANIMALSPAWN;
    public static ClaimPermission LIGHTNING;
    public static ClaimPermission LOCKITEMS;
    public static ClaimPermission FAKEPLAYER;

    public static ClaimPermission register(ClaimPermission perm) {
        if (locked) {
            throw new IllegalStateException("Registering permissions is locked");
        }
        permissions.put(perm.id, perm);
        return perm;
    }

    public static ClaimPermission global(ClaimPermission perm) {
        if (locked) {
            throw new IllegalStateException("Registering permissions is locked");
        }
        globalPermissions.put(perm.id, perm);
        return PermissionRegistry.register(perm);
    }

    public static void lock() {
        locked = true;
    }

    public static ClaimPermission get(String id) {
        if (!permissions.containsKey(id)) {
            throw new NullPointerException("No such permission " + id + " registered");
        }
        return permissions.get(id);
    }

    public static List<ClaimPermission> getPerms() {
        return new ArrayList<ClaimPermission>(permissions.values());
    }

    public static Collection<ClaimPermission> globalPerms() {
        return globalPermissions.values();
    }

    public static ClaimPermission registerBreakPerm(ClaimPermission perm, ResourceLocation ... affectedBlocks) {
        ClaimPermission reg = PermissionRegistry.register(perm);
        for (ResourceLocation blocks : affectedBlocks) {
            breakBlocks.put(blocks, perm);
        }
        return reg;
    }

    public static ClaimPermission registerBlockInteract(ClaimPermission perm, ResourceLocation ... affectedBlocks) {
        ClaimPermission reg = PermissionRegistry.register(perm);
        for (ResourceLocation blocks : affectedBlocks) {
            interactBlocks.put(blocks, perm);
        }
        return reg;
    }

    public static ClaimPermission registerItemUse(ClaimPermission perm, ResourceLocation ... affectedBlocks) {
        ClaimPermission reg = PermissionRegistry.register(perm);
        for (ResourceLocation blocks : affectedBlocks) {
            items.put(blocks, perm);
        }
        return reg;
    }

    static {
        EDITCLAIM = PermissionRegistry.register(new ClaimPermission("EDITCLAIM", () -> new ItemStack((ItemLike)ConfigHandler.config.claimingItem), "Gives permission to edit (resize, delete...) the claim"));
        EDITPERMS = PermissionRegistry.register(new ClaimPermission("EDITPERMS", () -> new ItemStack((ItemLike)Items.f_42116_), "Gives permission to change the claims permissions"));
        EDITPOTIONS = PermissionRegistry.register(new ClaimPermission("EDITPOTIONS", () -> new ItemStack((ItemLike)Items.f_42589_), "Gives permission to edit the claims potion effect"));
        BREAK = PermissionRegistry.register(new ClaimPermission("BREAK", () -> new ItemStack((ItemLike)Items.f_42390_), "Permission to break blocks in the claim"));
        PLACE = PermissionRegistry.register(new ClaimPermission("PLACE", () -> new ItemStack((ItemLike)Items.f_42276_), "Permission to place blocks in the claim"));
        OPENCONTAINER = PermissionRegistry.register(new ClaimPermission("OPENCONTAINER", () -> new ItemStack((ItemLike)Items.f_42009_), "Permission to open containers", "(chest, furnace etc.)"));
        INTERACTBLOCK = PermissionRegistry.register(new ClaimPermission("INTERACTBLOCK", () -> new ItemStack((ItemLike)Items.f_42587_), "Generic permission for block interaction.", "Fallback to OPENCONTAINER", "Gets used for all blocks OPENCONTAINER doesn't check for"));
        INTERACTSIGN = PermissionRegistry.register(new ClaimPermission("INTERACTSIGN", () -> new ItemStack((ItemLike)Items.f_42440_), "Permission to edit signs (e.g. dyeing them)"));
        ANVIL = PermissionRegistry.register(new ClaimPermission("ANVIL", () -> new ItemStack((ItemLike)Items.f_42146_), "Permission to use anvils"));
        BED = PermissionRegistry.register(new ClaimPermission("BED", () -> new ItemStack((ItemLike)Items.f_42570_), "Permission to use beds"));
        BEACON = PermissionRegistry.register(new ClaimPermission("BEACON", () -> new ItemStack((ItemLike)Items.f_42065_), "Permission to use beacons"));
        DOOR = PermissionRegistry.register(new ClaimPermission("DOOR", () -> new ItemStack((ItemLike)Items.f_42342_), "Permission to use doors"));
        FENCEGATE = PermissionRegistry.register(new ClaimPermission("FENCEGATE", () -> new ItemStack((ItemLike)Items.f_42030_), "Permission to use fence gates"));
        TRAPDOOR = PermissionRegistry.register(new ClaimPermission("TRAPDOOR", () -> new ItemStack((ItemLike)Items.f_42056_), "Permission to use trapdoors"));
        BUTTONLEVER = PermissionRegistry.register(new ClaimPermission("BUTTONLEVER", () -> new ItemStack((ItemLike)Items.f_41966_), "Permission to trigger levers and buttons"));
        PRESSUREPLATE = PermissionRegistry.register(new ClaimPermission("PRESSUREPLATE", () -> new ItemStack((ItemLike)Items.f_41967_), "Permission to trigger pressure plates"));
        NOTEBLOCK = PermissionRegistry.register(new ClaimPermission("NOTEBLOCK", () -> new ItemStack((ItemLike)Items.f_41859_), "Permission to change noteblocks"));
        REDSTONE = PermissionRegistry.register(new ClaimPermission("REDSTONE", () -> new ItemStack((ItemLike)Items.f_42451_), "Permission to change redstone components"));
        JUKEBOX = PermissionRegistry.register(new ClaimPermission("JUKEBOX", () -> new ItemStack((ItemLike)Items.f_41984_), "Permission to insert/take music discs"));
        ENDERCHEST = PermissionRegistry.register(new ClaimPermission("ENDERCHEST", () -> new ItemStack((ItemLike)Items.f_42108_), true, "Permission to use enderchests"));
        ENCHANTMENTTABLE = PermissionRegistry.register(new ClaimPermission("ENCHANTMENT", () -> new ItemStack((ItemLike)Items.f_42100_), true, "Permission to use enchanting tables"));
        ITEMFRAMEROTATE = PermissionRegistry.register(new ClaimPermission("ITEMFRAMEROTATE", () -> new ItemStack((ItemLike)Items.f_42617_), "Permission to rotate items in item frames"));
        LECTERNTAKE = PermissionRegistry.register(new ClaimPermission("LECTERNTAKE", () -> new ItemStack((ItemLike)Items.f_42774_), "Permission to change books in a lectern"));
        ENDCRYSTALPLACE = PermissionRegistry.register(new ClaimPermission("ENDCRYSTALPLACE", () -> new ItemStack((ItemLike)Items.f_42729_), "Permission to place end crystals"));
        TARGETBLOCK = PermissionRegistry.register(new ClaimPermission("TARGETBLOCK", () -> new ItemStack((ItemLike)Items.f_42793_), "Permission to trigger target blocks"));
        PROJECTILES = PermissionRegistry.register(new ClaimPermission("PROJECTILES", () -> new ItemStack((ItemLike)Items.f_42412_), "Permission to let shot projectiles", "interact with blocks (e.g. arrow on button)"));
        TRAMPLE = PermissionRegistry.register(new ClaimPermission("TRAMPLE", () -> new ItemStack((ItemLike)Items.f_41961_), "Permission to enable block trampling", "(farmland, turtle eggs)"));
        FROSTWALKER = PermissionRegistry.register(new ClaimPermission("FROSTWALKER", () -> new ItemStack((ItemLike)Items.f_42463_), "Permission for frostwalker to activate"));
        PORTAL = PermissionRegistry.register(new ClaimPermission("PORTAL", () -> new ItemStack((ItemLike)Items.f_41999_), true, "Permission to use nether portals"));
        RAID = PermissionRegistry.register(new ClaimPermission("RAID", Raid::m_37779_, "Permission to trigger raids in claim.", "Wont prevent raids (just) outside"));
        BOAT = PermissionRegistry.register(new ClaimPermission("BOAT", () -> new ItemStack((ItemLike)Items.f_42453_), "Permission to use boats"));
        MINECART = PermissionRegistry.register(new ClaimPermission("MINECART", () -> new ItemStack((ItemLike)Items.f_42449_), "Permission to sit in minecarts"));
        BUCKET = PermissionRegistry.register(new ClaimPermission("BUCKET", () -> new ItemStack((ItemLike)Items.f_42446_), "Permission to take liquids with buckets"));
        ENDERPEARL = PermissionRegistry.register(new ClaimPermission("ENDERPEARL", () -> new ItemStack((ItemLike)Items.f_42584_), "Permission to use enderpearls"));
        CHORUSFRUIT = PermissionRegistry.register(new ClaimPermission("CHORUSFRUIT", () -> new ItemStack((ItemLike)Items.f_42730_), "Permission to eat chorus fruits"));
        ANIMALINTERACT = PermissionRegistry.register(new ClaimPermission("ANIMALINTERACT", () -> new ItemStack((ItemLike)Items.f_42552_), "Permission to interact with animals", "(e.g. shearing sheeps)"));
        HURTANIMAL = PermissionRegistry.register(new ClaimPermission("HURTANIMAL", () -> new ItemStack((ItemLike)Items.f_42579_), "Permission to hurt animals"));
        XP = PermissionRegistry.register(new ClaimPermission("XP", () -> new ItemStack((ItemLike)Items.f_42612_), "Permission to pick up xp orbs"));
        TRADING = PermissionRegistry.register(new ClaimPermission("TRADING", () -> new ItemStack((ItemLike)Items.f_42616_), "Permission to trade with villagers"));
        ARMORSTAND = PermissionRegistry.register(new ClaimPermission("ARMORSTAND", () -> new ItemStack((ItemLike)Items.f_42650_), "Permission to interact with armor stands"));
        BREAKNONLIVING = PermissionRegistry.register(new ClaimPermission("BREAKNONLIVING", () -> new ItemStack((ItemLike)Items.f_42657_), "Permission to break things like minecarts or armor stands"));
        DROP = PermissionRegistry.register(new ClaimPermission("DROP", () -> new ItemStack((ItemLike)Items.f_42399_), true, "Allow the drop of items"));
        PICKUP = PermissionRegistry.register(new ClaimPermission("PICKUP", () -> new ItemStack((ItemLike)Items.f_42460_), true, "Allow the pickup of items"));
        FLIGHT = PermissionRegistry.register(new ClaimPermission("FLIGHT", () -> new ItemStack((ItemLike)Items.f_42402_), true, "Allow non creative flight"));
        CANSTAY = PermissionRegistry.register(new ClaimPermission("CANSTAY", () -> new ItemStack((ItemLike)Items.f_42516_), true, "Allow players to enter your claim"));
        TELEPORT = PermissionRegistry.register(new ClaimPermission("TELEPORT", () -> new ItemStack((ItemLike)Items.f_42101_), false, "Allow player to teleport to your claim home position"));
        NOHUNGER = PermissionRegistry.register(new ClaimPermission("NOHUNGER", () -> new ItemStack((ItemLike)Items.f_42580_), false, "Disable hunger"));
        CLAIMMESSAGE = PermissionRegistry.register(new ClaimPermission("CLAIMMESSAGE", () -> new ItemStack((ItemLike)Items.f_42438_), false, "Permission to edit the enter/leave message"));
        HURTPLAYER = PermissionRegistry.global(new ClaimPermission("HURTPLAYER", () -> new ItemStack((ItemLike)Items.f_42388_), "Permission to hurt other players"));
        EXPLOSIONS = PermissionRegistry.global(new ClaimPermission("EXPLOSIONS", () -> new ItemStack((ItemLike)Items.f_41996_), "Toggle explosions in claim"));
        WITHER = PermissionRegistry.global(new ClaimPermission("WITHER", () -> new ItemStack((ItemLike)Items.f_42679_), "Toggle wither breaking blocks in claim"));
        ENDERMAN = PermissionRegistry.global(new ClaimPermission("ENDERMAN", () -> new ItemStack((ItemLike)Items.f_42545_), true, "Allow enderman picking and placing blocks"));
        SNOWGOLEM = PermissionRegistry.global(new ClaimPermission("SNOWGOLEM", () -> new ItemStack((ItemLike)Items.f_41981_), true, "Allow snowgolems snowlayer"));
        FIRESPREAD = PermissionRegistry.global(new ClaimPermission("FIRESPREAD", () -> new ItemStack((ItemLike)Items.f_42593_), "Toggle firespread in claim"));
        WATERBORDER = PermissionRegistry.global(new ClaimPermission("WATERBORDER", () -> new ItemStack((ItemLike)Items.f_42447_), "Toggle water crossing claim borders"));
        PISTONBORDER = PermissionRegistry.global(new ClaimPermission("PISTONBORDER", () -> new ItemStack((ItemLike)Items.f_41869_), "Toggle piston pull/push across claim borders"));
        MOBSPAWN = PermissionRegistry.global(new ClaimPermission("MOBSPAWN", () -> new ItemStack((ItemLike)Items.f_42608_), "Prevent hostile mobspawn in claim"));
        ANIMALSPAWN = PermissionRegistry.global(new ClaimPermission("ANIMALSPAWN", () -> new ItemStack((ItemLike)Items.f_42630_), "Prevent other spawn in claim"));
        LIGHTNING = PermissionRegistry.global(new ClaimPermission("LIGHTNING", () -> new ItemStack((ItemLike)Items.f_42713_), "Allow lightning to affect claims", "e.g. set blocks on fire", "or affect animals (mobs are excluded)"));
        LOCKITEMS = PermissionRegistry.global(new ClaimPermission("LOCKITEMS", () -> new ItemStack((ItemLike)Items.f_42689_), true, "If items should be locked on death"));
        FAKEPLAYER = PermissionRegistry.global(new ClaimPermission("FAKEPLAYER", () -> new ItemStack((ItemLike)Items.f_42684_), false, "Allow fakeplayers to interact in this claim", "Some mods fakeplayer has the users uuid", "For those mods this permission is not needed"));
    }
}

