/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TurtleEggBlock;

public class ObjectToPermissionMap {
    private static final Map<Block, ClaimPermission> blockToPermission = new HashMap<Block, ClaimPermission>();
    private static final Map<Predicate<Block>, Supplier<ClaimPermission>> blockPermissionBuilder = new HashMap<Predicate<Block>, Supplier<ClaimPermission>>();
    private static final Map<Item, ClaimPermission> itemToPermission = new HashMap<Item, ClaimPermission>();
    private static final Map<Predicate<Item>, Supplier<ClaimPermission>> itemPermissionBuilder = new HashMap<Predicate<Item>, Supplier<ClaimPermission>>();
    private static final Map<EntityType<?>, ClaimPermission> entityToPermission = new HashMap();
    private static final Map<Block, ClaimPermission> leftClickBlockPermission = new HashMap<Block, ClaimPermission>();

    public static void reload(MinecraftServer server) {
        blockToPermission.clear();
        itemToPermission.clear();
        entityToPermission.clear();
        leftClickBlockPermission.clear();
        for (Block block : CrossPlatformStuff.INSTANCE.registryBlocks().getIterator()) {
            blockPermissionBuilder.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> blockToPermission.put(block, (ClaimPermission)sub.get()));
        }
        for (Item item : CrossPlatformStuff.INSTANCE.registryItems().getIterator()) {
            itemPermissionBuilder.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(item)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> itemToPermission.put(item, (ClaimPermission)sub.get()));
        }
        ObjectToPermissionMap.process(ConfigHandler.config.itemPermission, Registry.f_122827_, itemToPermission);
        ObjectToPermissionMap.process(ConfigHandler.config.blockPermission, Registry.f_122824_, blockToPermission);
        ObjectToPermissionMap.process(ConfigHandler.config.entityPermission, Registry.f_122826_, entityToPermission);
        ObjectToPermissionMap.process(ConfigHandler.config.leftClickBlockPermission, Registry.f_122824_, leftClickBlockPermission);
    }

    private static <T> void process(List<String> list, Registry<T> registry, Map<T, ClaimPermission> map) {
        for (String s : list) {
            String[] sub = s.split("-");
            boolean remove = sub[1].equals("NONE");
            if (s.startsWith("@")) {
                ResourceLocation res = new ResourceLocation(sub[0].substring(1));
                ObjectToPermissionMap.processTag(res, registry, b -> {
                    if (remove) {
                        map.remove(b);
                    } else {
                        map.put(b, PermissionRegistry.get(sub[1]));
                    }
                });
                continue;
            }
            if (remove) {
                map.remove(registry.m_7745_(new ResourceLocation(sub[0])));
                continue;
            }
            map.put(registry.m_7745_(new ResourceLocation(sub[0])), PermissionRegistry.get(sub[1]));
        }
    }

    private static <T> void processTag(ResourceLocation tag, Registry<T> registry, Consumer<T> action) {
        Optional<HolderSet.Named> t = registry.m_203612_().filter(p -> ((TagKey)p.getFirst()).f_203868_().equals((Object)tag)).map(Pair::getSecond).findFirst();
        t.ifPresent(holders -> holders.forEach(i -> action.accept(i.m_203334_())));
    }

    public static ClaimPermission getFromBlock(Block block) {
        return blockToPermission.get(block);
    }

    public static ClaimPermission getFromItem(Item item) {
        return itemToPermission.get(item);
    }

    public static ClaimPermission getFromEntity(EntityType<?> entity) {
        return entityToPermission.get(entity);
    }

    public static ClaimPermission getForLeftClickBlock(Block block) {
        return leftClickBlockPermission.get(block);
    }

    public static void registerBlockPredicateMap(Predicate<Block> pred, Supplier<ClaimPermission> perm) {
        blockPermissionBuilder.put(pred, perm);
    }

    public static void registerItemPredicateMap(Predicate<Item> pred, Supplier<ClaimPermission> perm) {
        itemPermissionBuilder.put(pred, perm);
    }

    static {
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof AnvilBlock, () -> PermissionRegistry.ANVIL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BedBlock, () -> PermissionRegistry.BED);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BeaconBlock, () -> PermissionRegistry.BEACON);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof DoorBlock, () -> PermissionRegistry.DOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof FenceGateBlock, () -> PermissionRegistry.FENCEGATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TrapDoorBlock, () -> PermissionRegistry.TRAPDOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof LeverBlock || block instanceof ButtonBlock, () -> PermissionRegistry.BUTTONLEVER);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof NoteBlock, () -> PermissionRegistry.NOTEBLOCK);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof DiodeBlock || block instanceof RedStoneWireBlock || block instanceof DaylightDetectorBlock, () -> PermissionRegistry.REDSTONE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof JukeboxBlock, () -> PermissionRegistry.JUKEBOX);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BasePressurePlateBlock, () -> PermissionRegistry.PRESSUREPLATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof NetherPortalBlock, () -> PermissionRegistry.PORTAL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TurtleEggBlock || block instanceof FarmBlock, () -> PermissionRegistry.TRAMPLE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TargetBlock, () -> PermissionRegistry.TARGETBLOCK);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BellBlock || block instanceof CampfireBlock || block instanceof TntBlock || block instanceof ChorusFlowerBlock, () -> PermissionRegistry.PROJECTILES);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof EnderChestBlock, () -> PermissionRegistry.ENDERCHEST);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof EnchantmentTableBlock, () -> PermissionRegistry.ENCHANTMENTTABLE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof EnderpearlItem, () -> PermissionRegistry.ENDERPEARL);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BucketItem, () -> PermissionRegistry.BUCKET);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.f_42729_, () -> PermissionRegistry.ENDCRYSTALPLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.f_42730_, () -> PermissionRegistry.CHORUSFRUIT);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.f_42094_, () -> PermissionRegistry.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BoneMealItem, () -> PermissionRegistry.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof RecordItem, () -> PermissionRegistry.JUKEBOX);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BoatItem, () -> PermissionRegistry.BOAT);
    }
}

