/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.BaseContainerMenu;
import slimeknights.mantle.inventory.WrapperSlot;

public class MultiModuleContainerMenu<TILE extends BlockEntity>
extends BaseContainerMenu<TILE> {
    public List<AbstractContainerMenu> subContainers = Lists.newArrayList();
    protected Map<Integer, AbstractContainerMenu> slotContainerMap = Maps.newHashMap();
    protected Map<AbstractContainerMenu, Pair<Integer, Integer>> subContainerSlotRanges = Maps.newHashMap();
    protected int subContainerSlotStart = -1;
    protected Set<AbstractContainerMenu> shiftClickContainers = Sets.newHashSet();

    public MultiModuleContainerMenu(MenuType<?> containerType, int id, @Nullable Inventory inv, @Nullable TILE tile) {
        super(containerType, id, inv, tile);
    }

    public void addSubContainer(AbstractContainerMenu subcontainer, boolean preferForShiftClick) {
        if (this.subContainers.isEmpty()) {
            this.subContainerSlotStart = this.f_38839_.size();
        }
        this.subContainers.add(subcontainer);
        if (preferForShiftClick) {
            this.shiftClickContainers.add(subcontainer);
        }
        int begin = this.f_38839_.size();
        for (Slot slot : subcontainer.f_38839_) {
            WrapperSlot wrapper = new WrapperSlot(slot);
            this.m_38897_(wrapper);
            this.slotContainerMap.put(wrapper.f_40219_, subcontainer);
        }
        int end = this.f_38839_.size();
        this.subContainerSlotRanges.put(subcontainer, (Pair<Integer, Integer>)Pair.of((Object)begin, (Object)end));
    }

    @Nullable
    public <CONTAINER extends AbstractContainerMenu> CONTAINER getSubContainer(Class<CONTAINER> clazz) {
        return this.getSubContainer(clazz, 0);
    }

    @Nullable
    public <CONTAINER extends AbstractContainerMenu> CONTAINER getSubContainer(Class<CONTAINER> clazz, int index) {
        for (AbstractContainerMenu sub : this.subContainers) {
            if (clazz.isAssignableFrom(sub.getClass())) {
                --index;
            }
            if (index >= 0) continue;
            return (CONTAINER)((AbstractContainerMenu)clazz.cast(sub));
        }
        return null;
    }

    public AbstractContainerMenu getSlotContainer(int slotNumber) {
        if (this.slotContainerMap.containsKey(slotNumber)) {
            return this.slotContainerMap.get(slotNumber);
        }
        return this;
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        for (AbstractContainerMenu sub : this.subContainers) {
            if (sub.m_6875_(playerIn)) continue;
            return false;
        }
        return super.m_6875_(playerIn);
    }

    public void m_6877_(Player playerIn) {
        for (AbstractContainerMenu sub : this.subContainers) {
            sub.m_6877_(playerIn);
        }
        super.m_6877_(playerIn);
    }

    public void m_150399_(int slotId, int dragType, ClickType type, Player player) {
        if (slotId == -999 && type == ClickType.QUICK_CRAFT) {
            for (AbstractContainerMenu container : this.subContainers) {
                container.m_150399_(slotId, dragType, type, player);
            }
        }
        super.m_150399_(slotId, dragType, type, player);
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = slot.m_7993_().m_41777_();
        ItemStack itemstack = slot.m_7993_().m_41777_();
        AbstractContainerMenu container = this.getSlotContainer(index);
        boolean nothingDone = true;
        if (container != this) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToPlayerInventory(itemstack);
        } else if (index < this.subContainerSlotStart || index < this.playerInventoryStart && this.subContainerSlotStart < 0) {
            nothingDone &= this.refillAnyContainer(itemstack, this.subContainers);
            nothingDone &= this.moveToPlayerInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else if (index >= this.playerInventoryStart && this.playerInventoryStart >= 0) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else {
            return ItemStack.f_41583_;
        }
        if (nothingDone) {
            return ItemStack.f_41583_;
        }
        return this.notifySlotAfterTransfer(playerIn, itemstack, ret, slot);
    }

    protected ItemStack notifySlotAfterTransfer(Player player, ItemStack stack, ItemStack original, Slot slot) {
        slot.m_40234_(stack, original);
        if (stack.m_41613_() == original.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_5852_(stack);
        slot.m_142406_(player, stack);
        if (slot.m_6657_() && slot.m_7993_().m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        return original;
    }

    protected boolean moveToTileInventory(ItemStack itemstack) {
        if (itemstack.m_41619_()) {
            return false;
        }
        int end = this.subContainerSlotStart;
        if (end < 0) {
            end = this.playerInventoryStart;
        }
        return !this.m_38903_(itemstack, 0, end, false);
    }

    protected boolean moveToPlayerInventory(ItemStack itemstack) {
        if (itemstack.m_41619_()) {
            return false;
        }
        return this.playerInventoryStart > 0 && !this.m_38903_(itemstack, this.playerInventoryStart, this.f_38839_.size(), true);
    }

    protected boolean moveToAnyContainer(ItemStack itemstack, Collection<AbstractContainerMenu> containers) {
        if (itemstack.m_41619_()) {
            return false;
        }
        for (AbstractContainerMenu submodule : containers) {
            if (!this.moveToContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean moveToContainer(ItemStack itemstack, AbstractContainerMenu container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.m_38903_(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    protected boolean refillAnyContainer(ItemStack itemstack, Collection<AbstractContainerMenu> containers) {
        if (itemstack.m_41619_()) {
            return false;
        }
        for (AbstractContainerMenu submodule : containers) {
            if (!this.refillContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean refillContainer(ItemStack itemstack, AbstractContainerMenu container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.mergeItemStackRefill(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    @Nullable
    public <TE extends BlockEntity> TE detectTE(Class<TE> clazz) {
        if (this.tile == null) {
            return null;
        }
        return (TE)((BlockEntity)ObjectUtils.firstNonNull((Object[])new BlockEntity[]{this.detectChest(this.tile.m_58899_().m_142127_(), clazz), this.detectChest(this.tile.m_58899_().m_142126_(), clazz), this.detectChest(this.tile.m_58899_().m_142128_(), clazz), this.detectChest(this.tile.m_58899_().m_142125_(), clazz)}));
    }

    @Nullable
    private <TE extends BlockEntity> TE detectChest(BlockPos pos, Class<TE> clazz) {
        if (this.tile == null) {
            return null;
        }
        if (this.tile.m_58904_() == null) {
            return null;
        }
        BlockEntity te = this.tile.m_58904_().m_7702_(pos);
        if (clazz.isInstance(te)) {
            return (TE)((BlockEntity)clazz.cast(te));
        }
        return null;
    }
}

