/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.natamus.collective_common_forge.data.GlobalVariables;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class StringFunctions {
    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour) {
        StringFunctions.sendMessage(source, m, colour, false);
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour) {
        StringFunctions.sendMessage(player, m, colour, false);
    }

    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour, boolean emptyline) {
        StringFunctions.sendMessage(source, m, colour, emptyline, "");
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour, boolean emptyline) {
        StringFunctions.sendMessage(player, m, colour, emptyline, "");
    }

    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour, String url) {
        StringFunctions.sendMessage(source, m, colour, false, url);
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour, String url) {
        StringFunctions.sendMessage(player, m, colour, false, url);
    }

    public static void sendMessage(CommandSourceStack source, String m, ChatFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        if (emptyline) {
            source.m_81354_((Component)new TextComponent(""), false);
        }
        TextComponent message = new TextComponent(m);
        message.m_130940_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.m_130948_(clickstyle);
            }
        }
        source.m_81354_((Component)message, false);
    }

    public static void sendMessage(Player player, String m, ChatFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        if (emptyline) {
            player.m_6352_((Component)new TextComponent(""), player.m_142081_());
        }
        TextComponent message = new TextComponent(m);
        message.m_130940_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.m_130948_(clickstyle);
            }
        }
        player.m_6352_((Component)message, player.m_142081_());
    }

    public static void broadcastMessage(Level world, String m, ChatFormatting colour) {
        if (m.isEmpty()) {
            return;
        }
        TextComponent message = new TextComponent(m);
        message.m_130940_(colour);
        MinecraftServer server = world.m_142572_();
        if (server == null) {
            return;
        }
        for (Player player : server.m_6846_().m_11314_()) {
            StringFunctions.sendMessage(player, m, colour);
        }
    }

    public static void sendMessageToPlayersAround(Level world, BlockPos p, int radius, String message, ChatFormatting colour) {
        if (message.isEmpty()) {
            return;
        }
        for (Entity around : world.m_45933_(null, new AABB((double)(p.m_123341_() - radius), (double)(p.m_123342_() - radius), (double)(p.m_123343_() - radius), (double)(p.m_123341_() + radius), (double)(p.m_123342_() + radius), (double)(p.m_123343_() + radius)))) {
            if (!(around instanceof Player)) continue;
            StringFunctions.sendMessage((Player)around, message, colour);
        }
    }

    public static String capitalizeFirst(String string) {
        StringBuilder sb = new StringBuilder(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    public static String capitalizeEveryWord(String text) {
        if (text.length() == 0) {
            return text;
        }
        char[] chars = text.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (Character.isDigit(chars[i]) || Character.isLetter(chars[i])) continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    public static String escapeSpecialRegexChars(String str) {
        return Pattern.compile("[{}()\\[\\].+*?^$\\\\|]").matcher(str).replaceAll("\\\\$0");
    }

    public static String getRandomName(boolean useFemaleNames, boolean useMaleNames) {
        List<String> allnames;
        if (useFemaleNames && useMaleNames) {
            allnames = Stream.concat(GlobalVariables.femaleNames.stream(), GlobalVariables.maleNames.stream()).collect(Collectors.toList());
        } else if (useFemaleNames) {
            allnames = GlobalVariables.femaleNames;
        } else if (useMaleNames) {
            allnames = GlobalVariables.maleNames;
        } else {
            return "";
        }
        String name = allnames.get(GlobalVariables.random.nextInt(allnames.size())).toLowerCase();
        return StringFunctions.capitalizeEveryWord(name);
    }

    public static String getPCLocalTime(boolean twentyfour, boolean showseconds) {
        LocalDateTime now = LocalDateTime.now();
        String time = showseconds ? (twentyfour ? now.format(DateTimeFormatter.ofPattern("HH:mm:ss")) : now.format(DateTimeFormatter.ofPattern("hh:mm:ss a")).replace("&nbsp;", "")) : (twentyfour ? now.format(DateTimeFormatter.ofPattern("HH:mm")) : now.format(DateTimeFormatter.ofPattern("hh:mm a")).replace("&nbsp;", ""));
        return time;
    }

    public static int sequenceCount(String text, String sequence) {
        Pattern pattern = Pattern.compile(sequence);
        Matcher matcher = pattern.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static String joinListWithCommaAnd(List<String> inputlist) {
        if (inputlist.size() == 0) {
            return "";
        }
        if (inputlist.size() == 1) {
            return inputlist.get(0);
        }
        ArrayList<String> list = new ArrayList<String>(inputlist);
        String lastelement = (String)list.get(list.size() - 1);
        list.remove(list.size() - 1);
        String initial = String.join((CharSequence)", ", list);
        return initial + " and " + lastelement;
    }
}

