/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import twilightforest.world.components.chunkgenerators.warp.TerrainPoint;
import twilightforest.world.components.layer.GenLayerTFBiomeStabilize;
import twilightforest.world.components.layer.GenLayerTFBiomes;
import twilightforest.world.components.layer.GenLayerTFCompanionBiomes;
import twilightforest.world.components.layer.GenLayerTFKeyBiomes;
import twilightforest.world.components.layer.GenLayerTFRiverMix;
import twilightforest.world.components.layer.GenLayerTFStream;
import twilightforest.world.components.layer.GenLayerTFThornBorder;
import twilightforest.world.components.layer.vanillalegacy.Layer;
import twilightforest.world.components.layer.vanillalegacy.SmoothLayer;
import twilightforest.world.components.layer.vanillalegacy.ZoomLayer;
import twilightforest.world.components.layer.vanillalegacy.area.Area;
import twilightforest.world.components.layer.vanillalegacy.area.AreaFactory;
import twilightforest.world.components.layer.vanillalegacy.context.BigContext;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.registration.TwilightFeatures;
import twilightforest.world.registration.biomes.BiomeKeys;

@Deprecated
public class TFBiomeProvider
extends BiomeSource {
    public static final Codec<TFBiomeProvider> TF_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().orElseGet(() -> TwilightFeatures.seed).forGetter(obj -> obj.seed), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(provider -> provider.registry), (App)RecordCodecBuilder.create(pair -> pair.group((App)TerrainPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.f_47431_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)pair, Pair::of)).listOf().fieldOf("biomes").forGetter(obj -> obj.biomeList), (App)Codec.FLOAT.fieldOf("base_offset").forGetter(obj -> Float.valueOf(obj.baseOffset)), (App)Codec.FLOAT.fieldOf("base_factor").forGetter(obj -> Float.valueOf(obj.baseFactor))).apply((Applicative)instance, instance.stable(TFBiomeProvider::new)));
    private static final List<ResourceKey<Biome>> BIOMES = ImmutableList.of(BiomeKeys.LAKE, BiomeKeys.FOREST, BiomeKeys.DENSE_FOREST, BiomeKeys.HIGHLANDS, BiomeKeys.MUSHROOM_FOREST, BiomeKeys.SWAMP, BiomeKeys.STREAM, BiomeKeys.SNOWY_FOREST, BiomeKeys.GLACIER, BiomeKeys.CLEARING, BiomeKeys.OAK_SAVANNAH, BiomeKeys.FIREFLY_FOREST, (Object[])new ResourceKey[]{BiomeKeys.DENSE_MUSHROOM_FOREST, BiomeKeys.DARK_FOREST, BiomeKeys.ENCHANTED_FOREST, BiomeKeys.FIRE_SWAMP, BiomeKeys.DARK_FOREST_CENTER, BiomeKeys.FINAL_PLATEAU, BiomeKeys.THORNLANDS, BiomeKeys.SPOOKY_FOREST});
    private final Registry<Biome> registry;
    private final List<Pair<TerrainPoint, Holder<Biome>>> biomeList;
    private final Layer genBiomes;
    private final long seed;
    private final float baseOffset;
    private final float baseFactor;

    public TFBiomeProvider(long seed, Registry<Biome> registryIn, List<Pair<TerrainPoint, Holder<Biome>>> list, float offset, float factor) {
        super(BIOMES.stream().map(arg_0 -> registryIn.m_203636_(arg_0)).filter(Optional::isPresent).map(Optional::get));
        this.seed = seed;
        this.baseOffset = offset;
        this.baseFactor = factor;
        this.registry = registryIn;
        this.biomeList = list;
        this.genBiomes = TFBiomeProvider.makeLayers(seed, registryIn);
    }

    public static int getBiomeId(ResourceKey<Biome> biome, Registry<Biome> registry) {
        return registry.m_7447_((Object)((Biome)registry.m_6246_(biome)));
    }

    private static <T extends Area, C extends BigContext<T>> AreaFactory<T> makeLayers(LongFunction<C> seed, Registry<Biome> registry, long rawSeed) {
        AreaFactory biomes = GenLayerTFBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1L));
        biomes = GenLayerTFKeyBiomes.INSTANCE.setup(registry, rawSeed).run((BigContext)seed.apply(1000L), biomes);
        biomes = GenLayerTFCompanionBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1001L), biomes);
        biomes = GenLayerTFBiomeStabilize.INSTANCE.run((BigContext)seed.apply(700L), biomes);
        biomes = GenLayerTFThornBorder.INSTANCE.setup(registry).run((BigContext)seed.apply(500L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1005L), biomes);
        AreaFactory riverLayer = GenLayerTFStream.INSTANCE.setup(registry).run((BigContext)seed.apply(1L), biomes);
        riverLayer = SmoothLayer.INSTANCE.run((BigContext)seed.apply(7000L), riverLayer);
        biomes = GenLayerTFRiverMix.INSTANCE.setup(registry).run((BigContext)seed.apply(100L), biomes, riverLayer);
        return biomes;
    }

    public static Layer makeLayers(long seed, Registry<Biome> registry) {
        AreaFactory areaFactory = TFBiomeProvider.makeLayers(context -> new LazyAreaContext(25, seed, context), registry, seed);
        return new Layer(areaFactory){

            @Override
            public Holder<Biome> get(Registry<Biome> registry, int p_242936_2_, int p_242936_3_) {
                int i = this.area.get(p_242936_2_, p_242936_3_);
                Optional biome = registry.m_203300_(i);
                if (biome.isEmpty()) {
                    throw new IllegalStateException("Unknown biome id emitted by layers: " + i);
                }
                return (Holder)biome.get();
            }
        };
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return TF_CODEC;
    }

    public BiomeSource m_7206_(long l) {
        return new TFBiomeProvider(l, this.registry, this.biomeList, this.baseOffset, this.baseFactor);
    }

    public float getBaseOffset() {
        return this.baseOffset;
    }

    public float getBaseFactor() {
        return this.baseFactor;
    }

    public float getBiomeDepth(int x, int y, int z, Climate.Sampler sampler) {
        Biome biome = (Biome)this.m_203407_(x, y, z, sampler).m_203334_();
        return this.getBiomeDepth(biome);
    }

    public float getBiomeDepth(Biome biome) {
        return this.getBiomeValue(biome, TerrainPoint::depth);
    }

    public float getBiomeScale(int x, int y, int z, Climate.Sampler sampler) {
        Biome biome = (Biome)this.m_203407_(x, y, z, sampler).m_203334_();
        return this.getBiomeScale(biome);
    }

    public float getBiomeScale(Biome biome) {
        return this.getBiomeValue(biome, TerrainPoint::scale);
    }

    private float getBiomeValue(Biome biome, Function<? super TerrainPoint, Float> function) {
        return this.biomeList.stream().filter(p -> ((Biome)((Holder)p.getSecond()).m_203334_()).equals(biome)).map(Pair::getFirst).map(function).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return this.genBiomes.get(this.registry, x, z);
    }
}

