/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twilightforest.TFMagicMapData;
import twilightforest.item.TFItems;
import twilightforest.network.MagicMapPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;
import twilightforest.world.registration.biomes.BiomeKeys;

public class MagicMapItem
extends MapItem {
    public static final String STR_ID = "magicmap";
    private static final Map<ResourceLocation, MapColorBrightness> BIOME_COLORS = new HashMap<ResourceLocation, MapColorBrightness>();
    private static final Map<ChunkPos, Biome[]> CACHE = new HashMap<ChunkPos, Biome[]>();

    protected MagicMapItem(Item.Properties props) {
        super(props);
    }

    public static ItemStack setupNewMap(Level world, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack((ItemLike)TFItems.FILLED_MAGIC_MAP.get());
        MagicMapItem.createMapData(itemstack, world, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (ResourceKey<Level>)world.m_46472_());
        return itemstack;
    }

    @Nullable
    public static TFMagicMapData getData(ItemStack stack, Level world) {
        Integer id = MagicMapItem.m_151131_((ItemStack)stack);
        return id == null ? null : TFMagicMapData.getMagicMapData(world, MagicMapItem.getMapName(id));
    }

    @Nullable
    protected TFMagicMapData getCustomMapData(ItemStack stack, Level world) {
        TFMagicMapData mapdata = MagicMapItem.getData(stack, world);
        if (mapdata == null && !world.f_46443_) {
            mapdata = MagicMapItem.createMapData(stack, world, world.m_6106_().m_6789_(), world.m_6106_().m_6526_(), 3, false, false, (ResourceKey<Level>)world.m_46472_());
        }
        return mapdata;
    }

    private static TFMagicMapData createMapData(ItemStack stack, Level world, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<Level> dimension) {
        int i = world.m_7354_();
        int mapSize = 2048;
        int roundX = (int)Math.round((double)(x - 1024) / (double)mapSize);
        int roundZ = (int)Math.round((double)(z - 1024) / (double)mapSize);
        int scaledX = roundX * mapSize + 1024;
        int scaledZ = roundZ * mapSize + 1024;
        TFMagicMapData mapdata = new TFMagicMapData(scaledX, scaledZ, (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        TFMagicMapData.registerMagicMapData(world, mapdata, MagicMapItem.getMapName(i));
        stack.m_41784_().m_128405_("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "magicmap_" + id;
    }

    public void m_42893_(Level world, Entity viewer, MapItemSavedData data) {
        ServerLevel serverLevel;
        if (world.m_46472_() == data.f_77887_ && viewer instanceof Player && world instanceof ServerLevel && TFGenerationSettings.usesTwilightChunkGenerator(serverLevel = (ServerLevel)world)) {
            int biomesPerPixel = 4;
            int blocksPerPixel = 16;
            int centerX = data.f_77885_;
            int centerZ = data.f_77886_;
            int viewerX = Mth.m_14107_((double)(viewer.m_20185_() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = Mth.m_14107_((double)(viewer.m_20189_() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 512 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            Biome[] biomes = CACHE.computeIfAbsent(new ChunkPos(startX, startZ), pos -> {
                Biome[] array = new Biome[128 * biomesPerPixel * 128 * biomesPerPixel];
                for (int l = 0; l < 128 * biomesPerPixel; ++l) {
                    for (int i1 = 0; i1 < 128 * biomesPerPixel; ++i1) {
                        array[l * 128 * biomesPerPixel + i1] = (Biome)world.m_204166_(new BlockPos(startX * biomesPerPixel + i1 * biomesPerPixel, 0, startZ * biomesPerPixel + l * biomesPerPixel)).m_203334_();
                    }
                }
                return array;
            });
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    int worldZ;
                    int worldX;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    Biome biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    Biome overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    Biome downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    biome = overBiome != null && BiomeKeys.STREAM.m_135782_().equals((Object)overBiome.getRegistryName()) ? overBiome : (downBiome != null && BiomeKeys.STREAM.m_135782_().equals((Object)downBiome.getRegistryName()) ? downBiome : biome);
                    MapColorBrightness colorBrightness = this.getMapColorPerBiome(world, biome);
                    MaterialColor mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.f_77891_[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.f_76397_ * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.m_164803_(xPixel, zPixel, ourPixel);
                        data.m_77762_();
                    }
                    if (!TFFeature.isInFeatureChunk(worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel, worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel)) continue;
                    byte mapX = (byte)((float)(worldX - centerX) / (float)blocksPerPixel * 2.0f);
                    byte mapZ = (byte)((float)(worldZ - centerZ) / (float)blocksPerPixel * 2.0f);
                    TFFeature feature = TFFeature.getFeatureAt(worldX, worldZ, (WorldGenLevel)((ServerLevel)world));
                    TFMagicMapData tfData = (TFMagicMapData)data;
                    tfData.tfDecorations.add(new TFMagicMapData.TFMapDecoration(feature, mapX, mapZ, 8));
                }
            }
        }
    }

    private MapColorBrightness getMapColorPerBiome(Level world, Biome biome) {
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        if (biome == null) {
            return new MapColorBrightness(MaterialColor.f_76365_);
        }
        ResourceLocation key = biome.getRegistryName();
        MapColorBrightness color = BIOME_COLORS.get(key);
        if (color != null) {
            return color;
        }
        return new MapColorBrightness(MaterialColor.f_76365_);
    }

    private static void setupBiomeColors() {
        MagicMapItem.putBiomeColor(BiomeKeys.FOREST, new MapColorBrightness(MaterialColor.f_76405_, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.DENSE_FOREST, new MapColorBrightness(MaterialColor.f_76405_, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.LAKE, new MapColorBrightness(MaterialColor.f_76410_, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.STREAM, new MapColorBrightness(MaterialColor.f_76410_, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.SWAMP, new MapColorBrightness(MaterialColor.f_76367_, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.FIRE_SWAMP, new MapColorBrightness(MaterialColor.f_76371_, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.CLEARING, new MapColorBrightness(MaterialColor.f_76399_, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.OAK_SAVANNAH, new MapColorBrightness(MaterialColor.f_76399_, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.HIGHLANDS, new MapColorBrightness(MaterialColor.f_76408_, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.THORNLANDS, new MapColorBrightness(MaterialColor.f_76411_, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.FINAL_PLATEAU, new MapColorBrightness(MaterialColor.f_76420_, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.FIREFLY_FOREST, new MapColorBrightness(MaterialColor.f_76369_, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.DARK_FOREST, new MapColorBrightness(MaterialColor.f_76363_, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.DARK_FOREST_CENTER, new MapColorBrightness(MaterialColor.f_76413_, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.SNOWY_FOREST, new MapColorBrightness(MaterialColor.f_76406_, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.GLACIER, new MapColorBrightness(MaterialColor.f_76403_, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.MUSHROOM_FOREST, new MapColorBrightness(MaterialColor.f_76413_, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.DENSE_MUSHROOM_FOREST, new MapColorBrightness(MaterialColor.f_76418_, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.ENCHANTED_FOREST, new MapColorBrightness(MaterialColor.f_76421_, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.SPOOKY_FOREST, new MapColorBrightness(MaterialColor.f_76422_, 0));
    }

    private static void putBiomeColor(ResourceKey<Biome> biome, MapColorBrightness color) {
        BIOME_COLORS.put(biome.m_135782_(), color);
    }

    public static int getBiomeColor(Biome biome) {
        MapColorBrightness c;
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        return (c = BIOME_COLORS.get(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome))) != null ? MagicMapItem.getMapColor(c) : -16777216;
    }

    public static int getMapColor(MapColorBrightness mcb) {
        int i = switch (mcb.color.f_76397_) {
            case 3 -> 135;
            case 2 -> 255;
            case 0 -> 180;
            default -> 220;
        };
        int j = (mcb.color.f_76396_ >> 16 & 0xFF) * i / 255;
        int k = (mcb.color.f_76396_ >> 8 & 0xFF) * i / 255;
        int l = (mcb.color.f_76396_ & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
    }

    @Nullable
    public Packet<?> m_7233_(ItemStack stack, Level world, Player player) {
        Integer id = MagicMapItem.m_151131_((ItemStack)stack);
        TFMagicMapData mapdata = this.getCustomMapData(stack, world);
        Packet p = id == null || mapdata == null ? null : mapdata.m_164796_(id, player);
        return p instanceof ClientboundMapItemDataPacket ? TFPacketHandler.CHANNEL.toVanillaPacket((Object)new MagicMapPacket(mapdata, (ClientboundMapItemDataPacket)p), NetworkDirection.PLAY_TO_CLIENT) : p;
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        TFMagicMapData mapitemsaveddata;
        Integer integer = MagicMapItem.m_151131_((ItemStack)stack);
        TFMagicMapData tFMagicMapData = mapitemsaveddata = pLevel == null ? null : MagicMapItem.getData(stack, pLevel);
        if (pFlag.m_7050_()) {
            if (mapitemsaveddata != null) {
                pTooltip.add((Component)new TranslatableComponent("filled_map.id", new Object[]{integer}).m_130940_(ChatFormatting.GRAY));
                pTooltip.add((Component)new TranslatableComponent("filled_map.scale", new Object[]{1 << mapitemsaveddata.f_77890_}).m_130940_(ChatFormatting.GRAY));
                pTooltip.add((Component)new TranslatableComponent("filled_map.level", new Object[]{mapitemsaveddata.f_77890_, 4}).m_130940_(ChatFormatting.GRAY));
            } else {
                pTooltip.add((Component)new TranslatableComponent("filled_map.unknown").m_130940_(ChatFormatting.GRAY));
            }
        } else if (integer != null) {
            pTooltip.add((Component)new TextComponent("#" + integer).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static class MapColorBrightness {
        public MaterialColor color;
        public int brightness;

        public MapColorBrightness(MaterialColor color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public MapColorBrightness(MaterialColor color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

