/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.IShapedRecipe;
import twilightforest.TFConfig;
import twilightforest.block.TFBlocks;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.inventory.TFContainers;
import twilightforest.inventory.UncraftingInputInventory;
import twilightforest.inventory.UncraftingInventory;
import twilightforest.inventory.slot.AssemblySlot;
import twilightforest.inventory.slot.UncraftingResultSlot;
import twilightforest.inventory.slot.UncraftingSlot;
import twilightforest.item.recipe.TFRecipes;
import twilightforest.item.recipe.UncraftingRecipe;
import twilightforest.util.TFItemStackUtils;

public class UncraftingContainer
extends AbstractContainerMenu {
    private static final String TAG_MARKER = "TwilightForestMarker";
    private final UncraftingInventory uncraftingMatrix = new UncraftingInventory();
    public final CraftingContainer assemblyMatrix = new CraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final CraftingContainer combineMatrix = new CraftingContainer((AbstractContainerMenu)this, 3, 3);
    public final Container tinkerInput = new UncraftingInputInventory(this);
    private final ResultContainer tinkerResult = new ResultContainer();
    private final ContainerLevelAccess positionData;
    private final Level world;
    private final Player player;
    public int unrecipeInCycle = 0;
    public int ingredientsInCycle = 0;
    public int recipeInCycle = 0;
    private int customCost;

    public static UncraftingContainer fromNetwork(int id, Inventory inventory) {
        return new UncraftingContainer(id, inventory, inventory.f_35978_.f_19853_, ContainerLevelAccess.f_39287_);
    }

    public UncraftingContainer(int id, Inventory inventory, Level world, ContainerLevelAccess positionData) {
        super((MenuType)TFContainers.UNCRAFTING.get(), id);
        int invY;
        int invX;
        this.positionData = positionData;
        this.world = world;
        this.player = inventory.f_35978_;
        this.m_38897_(new Slot(this.tinkerInput, 0, 13, 35));
        this.m_38897_((Slot)new UncraftingResultSlot(inventory.f_35978_, this.tinkerInput, this.uncraftingMatrix, (Container)this.assemblyMatrix, (Container)this.tinkerResult, 0, 147, 35));
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.m_38897_(new UncraftingSlot(inventory.f_35978_, this.tinkerInput, this.uncraftingMatrix, (Container)this.assemblyMatrix, invY + invX * 3, 300000 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 3; ++invY) {
                this.m_38897_(new AssemblySlot((Container)this.assemblyMatrix, invY + invX * 3, 62 + invY * 18, 17 + invX * 18));
            }
        }
        for (invX = 0; invX < 3; ++invX) {
            for (invY = 0; invY < 9; ++invY) {
                this.m_38897_(new Slot((Container)inventory, invY + invX * 9 + 9, 8 + invY * 18, 84 + invX * 18));
            }
        }
        for (invX = 0; invX < 9; ++invX) {
            this.m_38897_(new Slot((Container)inventory, invX, 8 + invX * 18, 142));
        }
        this.m_6199_((Container)this.assemblyMatrix);
    }

    public void m_6199_(Container inventory) {
        if (inventory == this.tinkerInput) {
            this.uncraftingMatrix.m_6211_();
            ItemStack inputStack = this.tinkerInput.m_8020_(0);
            CraftingRecipe[] recipes = UncraftingContainer.getRecipesFor(inputStack, this.world);
            int size = recipes.length;
            if (size > 0 && !inputStack.m_204117_(ItemTagGenerator.BANNED_UNCRAFTABLES)) {
                int n;
                int i;
                int n2;
                CraftingRecipe recipe = recipes[Math.floorMod(this.unrecipeInCycle, size)];
                if (recipe instanceof UncraftingRecipe) {
                    UncraftingRecipe uncraftingRecipe = (UncraftingRecipe)recipe;
                    n2 = uncraftingRecipe.getCost();
                } else {
                    n2 = -1;
                }
                this.customCost = n2;
                ItemStack[] recipeItems = this.getIngredients(recipe);
                if (recipe instanceof IShapedRecipe) {
                    IShapedRecipe rec = (IShapedRecipe)recipe;
                    int recipeWidth = rec.getRecipeWidth();
                    int recipeHeight = rec.getRecipeHeight();
                    for (int invY = 0; invY < recipeHeight; ++invY) {
                        for (int invX = 0; invX < recipeWidth; ++invX) {
                            int index = invX + invY * recipeWidth;
                            if (index >= recipeItems.length) continue;
                            ItemStack ingredient = UncraftingContainer.normalizeIngredient(recipeItems[index].m_41777_());
                            this.uncraftingMatrix.m_6836_(invX + invY * 3, ingredient);
                        }
                    }
                } else {
                    for (i = 0; i < this.uncraftingMatrix.m_6643_(); ++i) {
                        if (i >= recipeItems.length) continue;
                        ItemStack ingredient = UncraftingContainer.normalizeIngredient(recipeItems[i].m_41777_());
                        this.uncraftingMatrix.m_6836_(i, ingredient);
                    }
                }
                if (inputStack.m_41768_()) {
                    int damagedParts = this.countDamagedParts(inputStack);
                    for (i = 0; i < 9 && damagedParts > 0; ++i) {
                        ItemStack stack = this.uncraftingMatrix.m_8020_(i);
                        if (!UncraftingContainer.isDamageableComponent(stack)) continue;
                        UncraftingContainer.markStack(stack);
                        --damagedParts;
                    }
                }
                for (int i2 = 0; i2 < 9; ++i2) {
                    ItemStack ingredient = this.uncraftingMatrix.m_8020_(i2);
                    if (!UncraftingContainer.isIngredientProblematic(ingredient)) continue;
                    UncraftingContainer.markStack(ingredient);
                }
                if (recipe instanceof UncraftingRecipe) {
                    UncraftingRecipe uncraftingRecipe = (UncraftingRecipe)recipe;
                    n = uncraftingRecipe.getCount();
                } else {
                    n = recipe.m_8043_().m_41613_();
                }
                this.uncraftingMatrix.numberOfInputItems = n;
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                this.customCost = -1;
                this.uncraftingMatrix.numberOfInputItems = 0;
                this.uncraftingMatrix.uncraftingCost = 0;
            }
        }
        if (inventory == this.assemblyMatrix || inventory == this.tinkerInput) {
            if (this.tinkerInput.m_7983_()) {
                this.chooseRecipe(this.assemblyMatrix);
                this.uncraftingMatrix.recraftingCost = 0;
            } else {
                this.tinkerResult.m_6836_(0, ItemStack.f_41583_);
                this.uncraftingMatrix.uncraftingCost = this.calculateUncraftingCost();
                this.uncraftingMatrix.recraftingCost = 0;
            }
        }
        if (inventory != this.combineMatrix && !this.uncraftingMatrix.m_7983_() && !this.assemblyMatrix.m_7983_()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack assembly = this.assemblyMatrix.m_8020_(i);
                ItemStack uncrafting = this.uncraftingMatrix.m_8020_(i);
                if (!assembly.m_41619_()) {
                    this.combineMatrix.m_6836_(i, assembly);
                    continue;
                }
                if (!uncrafting.m_41619_() && !UncraftingContainer.isMarked(uncrafting)) {
                    this.combineMatrix.m_6836_(i, uncrafting);
                    continue;
                }
                this.combineMatrix.m_6836_(i, ItemStack.f_41583_);
            }
            this.chooseRecipe(this.combineMatrix);
            ItemStack input = this.tinkerInput.m_8020_(0);
            ItemStack result = this.tinkerResult.m_8020_(0);
            if (!result.m_41619_() && UncraftingContainer.isValidMatchForInput(input, result)) {
                CompoundTag inputTags = null;
                if (input.m_41783_() != null) {
                    inputTags = input.m_41783_().m_6426_();
                }
                Map resultInnateEnchantments = EnchantmentHelper.m_44831_((ItemStack)result);
                Map inputEnchantments = EnchantmentHelper.m_44831_((ItemStack)input);
                inputEnchantments.keySet().removeIf(enchantment -> enchantment == null || !enchantment.m_6081_(result));
                if (inputTags != null) {
                    inputTags.m_128473_("ench");
                    result.m_41751_(inputTags);
                    EnchantmentHelper.m_44865_((Map)inputEnchantments, (ItemStack)result);
                }
                for (Map.Entry entry : resultInnateEnchantments.entrySet()) {
                    Enchantment ench = (Enchantment)entry.getKey();
                    int level = (Integer)entry.getValue();
                    if (EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)result) >= level) continue;
                    result.m_41663_(ench, level);
                }
                this.tinkerResult.m_6836_(0, result);
                this.uncraftingMatrix.uncraftingCost = 0;
                this.uncraftingMatrix.recraftingCost = this.calculateRecraftingCost();
                if (this.uncraftingMatrix.recraftingCost > 0 && !result.m_41788_()) {
                    result.m_41742_(input.m_41610_() + 2);
                }
            }
        }
    }

    public static void markStack(ItemStack stack) {
        stack.m_41700_(TAG_MARKER, (Tag)ByteTag.m_128266_((byte)1));
    }

    public static boolean isMarked(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        return stackTag != null && stackTag.m_128471_(TAG_MARKER);
    }

    public static void unmarkStack(ItemStack stack) {
        TFItemStackUtils.clearInfoTag(stack, TAG_MARKER);
    }

    private static boolean isIngredientProblematic(ItemStack ingredient) {
        return !ingredient.m_41619_() && ingredient.m_41720_().hasContainerItem(ingredient);
    }

    private static ItemStack normalizeIngredient(ItemStack ingredient) {
        if (ingredient.m_41613_() > 1) {
            ingredient.m_41764_(1);
        }
        return ingredient;
    }

    private static CraftingRecipe[] getRecipesFor(ItemStack inputStack, Level world) {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        if (!inputStack.m_41619_()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof CraftingRecipe)) continue;
                CraftingRecipe rec = (CraftingRecipe)recipe;
                if (!recipe.m_8004_(3, 3) || recipe.m_7527_().isEmpty() || !UncraftingContainer.matches(inputStack, recipe.m_8043_()) || ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncraftingRecipes.get()).contains(recipe.m_6423_().toString()) || ((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.flipUncraftingModIdList.get()).booleanValue() != ((List)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get()).contains(recipe.m_6423_().m_135827_())) continue;
                recipes.add(rec);
            }
            for (UncraftingRecipe uncraftingRecipe : world.m_7465_().m_44013_((RecipeType)TFRecipes.UNCRAFTING_RECIPE.get())) {
                if (!uncraftingRecipe.isItemStackAnIngredient(inputStack)) continue;
                recipes.add(uncraftingRecipe);
            }
        }
        return recipes.toArray(new CraftingRecipe[0]);
    }

    private static boolean matches(ItemStack input, ItemStack output) {
        return input.m_41720_() == output.m_41720_() && input.m_41613_() >= output.m_41613_();
    }

    private static CraftingRecipe[] getRecipesFor(CraftingContainer matrix, Level world) {
        return world.m_7465_().m_44056_(RecipeType.f_44107_, (Container)matrix, world).toArray(new CraftingRecipe[0]);
    }

    private void chooseRecipe(CraftingContainer inventory) {
        CraftingRecipe[] recipes = UncraftingContainer.getRecipesFor(inventory, this.world);
        if (recipes.length == 0) {
            this.tinkerResult.m_6836_(0, ItemStack.f_41583_);
            return;
        }
        CraftingRecipe recipe = recipes[Math.floorMod(this.recipeInCycle, recipes.length)];
        if (recipe != null && (recipe.m_5598_() || !this.world.m_46469_().m_46207_(GameRules.f_46151_) || ((ServerPlayer)this.player).m_8952_().m_12709_((Recipe)recipe))) {
            this.tinkerResult.m_6029_((Recipe)recipe);
            this.tinkerResult.m_6836_(0, recipe.m_5874_((Container)inventory));
        } else {
            this.tinkerResult.m_6836_(0, ItemStack.f_41583_);
        }
    }

    private static boolean isValidMatchForInput(ItemStack inputStack, ItemStack resultStack) {
        if (inputStack.m_41720_() instanceof PickaxeItem && resultStack.m_41720_() instanceof PickaxeItem) {
            return true;
        }
        if (inputStack.m_41720_() instanceof AxeItem && resultStack.m_41720_() instanceof AxeItem) {
            return true;
        }
        if (inputStack.m_41720_() instanceof ShovelItem && resultStack.m_41720_() instanceof ShovelItem) {
            return true;
        }
        if (inputStack.m_41720_() instanceof HoeItem && resultStack.m_41720_() instanceof HoeItem) {
            return true;
        }
        if (inputStack.m_41720_() instanceof SwordItem && resultStack.m_41720_() instanceof SwordItem) {
            return true;
        }
        if (inputStack.m_41720_() instanceof BowItem && resultStack.m_41720_() instanceof BowItem) {
            return true;
        }
        Item item = inputStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem inputArmor = (ArmorItem)item;
            item = resultStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem resultArmor = (ArmorItem)item;
                return inputArmor.m_40402_() == resultArmor.m_40402_();
            }
        }
        return false;
    }

    public int getUncraftingCost() {
        return this.uncraftingMatrix.uncraftingCost;
    }

    public int getRecraftingCost() {
        return this.uncraftingMatrix.recraftingCost;
    }

    private int calculateUncraftingCost() {
        if (this.assemblyMatrix.m_7983_()) {
            return this.customCost >= 0 ? this.customCost : UncraftingContainer.countDamageableParts(this.uncraftingMatrix);
        }
        return 0;
    }

    private int calculateRecraftingCost() {
        ItemStack input = this.tinkerInput.m_8020_(0);
        ItemStack output = this.tinkerResult.m_8020_(0);
        if (input.m_41619_() || !input.m_41793_() || output.m_41619_()) {
            return 0;
        }
        int cost = 0;
        cost += input.m_41610_();
        int enchantCost = UncraftingContainer.countTotalEnchantmentCost(input);
        cost += enchantCost;
        int damagedCost = (1 + this.countDamagedParts(input)) * EnchantmentHelper.m_44831_((ItemStack)output).size();
        cost += damagedCost;
        int enchantabilityDifference = input.m_41720_().m_6473_() - output.m_41720_().m_6473_();
        cost += enchantabilityDifference;
        cost = Math.max(1, cost);
        return cost;
    }

    private static int countTotalEnchantmentCost(ItemStack stack) {
        int count = 0;
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (ench == null || level <= 0) continue;
            count += UncraftingContainer.getWeightModifier(ench) * level;
            ++count;
        }
        return count;
    }

    private static int getWeightModifier(Enchantment ench) {
        return switch (ench.m_44699_().m_44716_()) {
            case 1 -> 8;
            case 2 -> 4;
            case 3, 4, 5 -> 2;
            default -> 1;
        };
    }

    public void m_150399_(int slotNum, int mouseButton, ClickType clickType, Player player) {
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.assemblyMatrix && player.f_36096_.m_142621_().m_41619_() && !((Slot)this.f_38839_.get(slotNum)).m_6657_() && this.assemblyMatrix.m_7983_()) {
            slotNum -= 9;
        }
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.tinkerResult && this.calculateRecraftingCost() > player.f_36078_ && !player.m_150110_().f_35937_) {
            return;
        }
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.uncraftingMatrix) {
            if (this.calculateUncraftingCost() > player.f_36078_ && !player.m_150110_().f_35937_) {
                return;
            }
            if (((Boolean)TFConfig.COMMON_CONFIG.UNCRAFTING_STUFFS.disableUncrafting.get()).booleanValue()) {
                return;
            }
            ItemStack stackInSlot = ((Slot)this.f_38839_.get(slotNum)).m_7993_();
            if (stackInSlot.m_41619_() || UncraftingContainer.isMarked(stackInSlot)) {
                return;
            }
        }
        super.m_150399_(slotNum, mouseButton, clickType, player);
        if (slotNum > 0 && ((Slot)this.f_38839_.get((int)slotNum)).f_40218_ == this.tinkerInput) {
            this.m_6199_(this.tinkerInput);
        }
    }

    private static boolean isDamageableComponent(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() != Items.f_42398_;
    }

    private static int countDamageableParts(Container matrix) {
        int count = 0;
        for (int i = 0; i < matrix.m_6643_(); ++i) {
            if (!matrix.m_8020_(i).m_41619_()) {
                ++count;
            }
            if (!UncraftingContainer.isIngredientProblematic(matrix.m_8020_(i)) && !UncraftingContainer.isMarked(matrix.m_8020_(i))) continue;
            --count;
        }
        return count;
    }

    private int countDamagedParts(ItemStack input) {
        int totalMax4 = Math.max(4, UncraftingContainer.countDamageableParts(this.uncraftingMatrix));
        float damage = (float)input.m_41773_() / (float)input.m_41776_();
        return (int)Math.ceil((float)totalMax4 * damage);
    }

    public ItemStack m_7648_(Player player, int slotNum) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotNum);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotNum == 0) {
                if (!this.m_38903_(itemstack1, 20, 56, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotNum == 1) {
                this.positionData.m_39292_((p_39378_, p_39379_) -> itemstack1.m_41720_().m_7836_(itemstack1, p_39378_, player));
                if (!this.m_38903_(itemstack1, 20, 56, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotNum >= 20 && slotNum < 56) {
                if (!this.m_38903_(itemstack1, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (slot.f_40218_ == this.assemblyMatrix) {
                if (!this.m_38903_(itemstack1, 20, 56, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.m_38903_(itemstack1, 20, 56, false)) {
                slot.m_142406_(player, itemstack1);
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
            if (slotNum == 1) {
                player.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.positionData.m_39292_((world, pos) -> {
            this.m_150411_(player, (Container)this.assemblyMatrix);
            this.m_150411_(player, this.tinkerInput);
        });
    }

    private ItemStack[] getIngredients(CraftingRecipe recipe) {
        ItemStack[] stacks = new ItemStack[recipe.m_7527_().size()];
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            ItemStack[] matchingStacks = (ItemStack[])Arrays.stream(((Ingredient)recipe.m_7527_().get(i)).m_43908_()).filter(s -> !s.m_204117_(ItemTagGenerator.BANNED_UNCRAFTING_INGREDIENTS)).toArray(ItemStack[]::new);
            stacks[i] = matchingStacks.length > 0 ? matchingStacks[Math.floorMod(this.ingredientsInCycle, matchingStacks.length)] : ItemStack.f_41583_;
        }
        return stacks;
    }

    public boolean m_6875_(Player player) {
        return UncraftingContainer.m_38889_((ContainerLevelAccess)this.positionData, (Player)player, (Block)((Block)TFBlocks.UNCRAFTING_TABLE.get()));
    }
}

