/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import twilightforest.TFSounds;
import twilightforest.client.particle.TFParticleType;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.item.TFItems;
import twilightforest.util.WorldUtil;

public class CubeOfAnnihilation
extends ThrowableProjectile {
    private boolean hasHitObstacle = false;

    public CubeOfAnnihilation(EntityType<? extends CubeOfAnnihilation> type, Level world) {
        super(type, world);
        this.m_5825_();
    }

    public CubeOfAnnihilation(EntityType<? extends CubeOfAnnihilation> type, Level world, LivingEntity thrower) {
        super(type, thrower, world);
        this.m_5825_();
        this.m_37251_((Entity)thrower, thrower.m_146909_(), thrower.m_146908_(), 0.0f, 1.5f, 1.0f);
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8097_() {
    }

    protected float m_7139_() {
        return 0.0f;
    }

    protected void m_6532_(HitResult ray) {
        BlockHitResult raytrace;
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (ray instanceof EntityHitResult && ((EntityHitResult)ray).m_82443_() instanceof LivingEntity && ((EntityHitResult)ray).m_82443_().m_6469_(this.getDamageSource(), 10.0f)) {
            this.f_19797_ += 60;
        }
        if (ray instanceof BlockHitResult && (raytrace = (BlockHitResult)ray).m_82425_() != null && !this.f_19853_.m_46859_(raytrace.m_82425_())) {
            this.affectBlocksInAABB(this.m_142469_().m_82377_((double)0.2f, (double)0.2f, (double)0.2f));
        }
    }

    private DamageSource getDamageSource() {
        LivingEntity thrower = (LivingEntity)this.m_37282_();
        if (thrower instanceof Player) {
            return DamageSource.m_19344_((Player)((Player)thrower));
        }
        if (thrower != null) {
            return DamageSource.m_19370_((LivingEntity)thrower);
        }
        return DamageSource.m_19361_((Entity)this, null);
    }

    private void affectBlocksInAABB(AABB box) {
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            Entity entity;
            BlockState state = this.f_19853_.m_8055_(pos);
            if (state.m_60795_() || !((entity = this.m_37282_()) instanceof Player)) continue;
            Player player = (Player)entity;
            if (!MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.f_19853_, pos, state, player))) {
                if (this.canAnnihilate(pos, state)) {
                    this.f_19853_.m_7471_(pos, false);
                    this.m_5496_(TFSounds.BLOCK_ANNIHILATED, 0.125f, this.f_19796_.nextFloat() * 0.25f + 0.75f);
                    this.annihilateParticles(this.f_19853_, pos);
                    continue;
                }
                this.hasHitObstacle = true;
                continue;
            }
            this.hasHitObstacle = true;
        }
    }

    private boolean canAnnihilate(BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        return state.m_204336_(BlockTagGenerator.ANNIHILATION_INCLUSIONS) || block.m_7325_() < 8.0f && state.m_60800_((BlockGetter)this.f_19853_, pos) >= 0.0f;
    }

    private void annihilateParticles(Level world, BlockPos pos) {
        Random rand = world.m_5822_();
        if (world instanceof ServerLevel) {
            for (int dx = 0; dx < 3; ++dx) {
                for (int dy = 0; dy < 3; ++dy) {
                    for (int dz = 0; dz < 3; ++dz) {
                        double x = (double)pos.m_123341_() + ((double)dx + 0.5) / 4.0;
                        double y = (double)pos.m_123342_() + ((double)dy + 0.5) / 4.0;
                        double z = (double)pos.m_123343_() + ((double)dz + 0.5) / 4.0;
                        double speed = rand.nextGaussian() * 0.2;
                        ((ServerLevel)world).m_8767_((ParticleOptions)((SimpleParticleType)TFParticleType.ANNIHILATE.get()), x, y, z, 1, 0.0, 0.0, 0.0, speed);
                    }
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_37282_() == null) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            Vec3 destPoint = new Vec3(this.m_37282_().m_20185_(), this.m_37282_().m_20186_() + (double)this.m_37282_().m_20192_(), this.m_37282_().m_20189_());
            double distToPlayer = this.m_20270_(this.m_37282_());
            if (this.isReturning()) {
                if (distToPlayer < 2.0) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            } else {
                destPoint = destPoint.m_82549_(this.m_37282_().m_20154_().m_82490_(16.0));
            }
            Vec3 velocity = new Vec3(this.m_20185_() - destPoint.m_7096_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f) - destPoint.m_7098_(), this.m_20189_() - destPoint.m_7094_());
            this.m_20334_(-velocity.m_7096_(), -velocity.m_7098_(), -velocity.m_7094_());
            float currentSpeed = Mth.m_14116_((float)((float)(this.m_20184_().m_7096_() * this.m_20184_().m_7096_() + this.m_20184_().m_7098_() * this.m_20184_().m_7098_() + this.m_20184_().m_7094_() * this.m_20184_().m_7094_())));
            float maxSpeed = 0.5f;
            if (currentSpeed > maxSpeed) {
                this.m_20256_(new Vec3(this.m_20184_().m_7096_() / (double)(currentSpeed / maxSpeed), this.m_20184_().m_7098_() / (double)(currentSpeed / maxSpeed), this.m_20184_().m_7094_() / (double)(currentSpeed / maxSpeed)));
            } else {
                float slow = 0.5f;
                this.m_20184_().m_82542_((double)slow, (double)slow, (double)slow);
            }
            this.affectBlocksInAABB(this.m_142469_().m_82377_((double)0.2f, (double)0.2f, (double)0.2f));
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        LivingEntity thrower = (LivingEntity)this.m_37282_();
        if (thrower != null && thrower.m_21211_().m_41720_() == TFItems.CUBE_OF_ANNIHILATION.get()) {
            thrower.m_5810_();
        }
    }

    private boolean isReturning() {
        Entity entity;
        if (this.hasHitObstacle || this.m_37282_() == null || !((entity = this.m_37282_()) instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        return !player.m_6117_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

