/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FireflyParticle
extends TextureSheetParticle {
    private final int halfLife;

    FireflyParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.f_107215_ *= 2.1;
        this.f_107216_ *= 2.1;
        this.f_107217_ *= 2.1;
        this.f_107227_ = 0.9f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 0.0f;
        this.f_107663_ = 0.2f + this.f_107223_.nextFloat() * 0.1f;
        this.f_107225_ = 10 + this.f_107223_.nextInt(21);
        this.halfLife = this.f_107225_ / 2;
        this.f_107219_ = true;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer buffer, Camera entity, float partialTicks) {
        this.f_107230_ = this.getGlowBrightness();
        super.m_5744_(buffer, entity, partialTicks);
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public float getGlowBrightness() {
        int lifeTime = this.f_107225_ - this.f_107224_;
        if (lifeTime <= this.halfLife) {
            return (float)lifeTime / (float)this.halfLife;
        }
        return Math.max(1.0f - ((float)lifeTime - (float)this.halfLife) / (float)this.halfLife, 0.0f);
    }

    public int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

