/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.entity.monster.DeathTome;

public class DeathTomeModel
extends HierarchicalModel<DeathTome> {
    private final ModelPart root;
    private final ModelPart book;
    private final ModelPart paperStorm;
    private final ModelPart pagesRight;
    private final ModelPart pagesLeft;
    private final ModelPart flippingPageRight;
    private final ModelPart flippingPageLeft;
    private final ModelPart coverRight;
    private final ModelPart coverLeft;
    private final ModelPart loosePage0;
    private final ModelPart loosePage1;
    private final ModelPart loosePage2;
    private final ModelPart loosePage3;

    public DeathTomeModel(ModelPart root) {
        this.root = root;
        this.book = root.m_171324_("book");
        this.pagesRight = this.book.m_171324_("pages_right");
        this.pagesLeft = this.book.m_171324_("pages_left");
        this.flippingPageRight = this.book.m_171324_("flipping_page_right");
        this.flippingPageLeft = this.book.m_171324_("flipping_page_left");
        this.coverRight = this.book.m_171324_("cover_right");
        this.coverLeft = this.book.m_171324_("cover_left");
        this.paperStorm = this.root.m_171324_("paper_storm");
        this.loosePage0 = this.paperStorm.m_171324_("loose_page_0");
        this.loosePage1 = this.paperStorm.m_171324_("loose_page_1");
        this.loosePage2 = this.paperStorm.m_171324_("loose_page_2");
        this.loosePage3 = this.paperStorm.m_171324_("loose_page_3");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        PartDefinition book = partRoot.m_171599_("book", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        book.m_171599_("pages_right", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(0.0f, -4.0f, -0.99f, 5.0f, 8.0f, 1.0f), PartPose.f_171404_);
        book.m_171599_("pages_left", CubeListBuilder.m_171558_().m_171514_(12, 10).m_171481_(0.0f, -4.0f, -0.01f, 5.0f, 8.0f, 1.0f), PartPose.f_171404_);
        book.m_171599_("flipping_page_right", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171481_(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.005f), PartPose.f_171404_);
        book.m_171599_("flipping_page_left", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171481_(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.005f), PartPose.f_171404_);
        book.m_171599_("cover_right", CubeListBuilder.m_171558_().m_171481_(-6.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        book.m_171599_("cover_left", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(0.0f, -5.0f, -0.005f, 6.0f, 10.0f, 0.005f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        book.m_171599_("book_spine", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(-1.0f, -5.0f, 0.0f, 2.0f, 10.0f, 0.005f), PartPose.m_171430_((float)0.0f, (float)1.5707964f, (float)0.0f));
        PartDefinition paperStorm = partRoot.m_171599_("paper_storm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        paperStorm.m_171599_("loose_page_0", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171481_(0.0f, -4.0f, -8.0f, 5.0f, 8.0f, 0.005f), PartPose.f_171404_);
        paperStorm.m_171599_("loose_page_1", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171481_(0.0f, -4.0f, 9.0f, 5.0f, 8.0f, 0.005f), PartPose.f_171404_);
        paperStorm.m_171599_("loose_page_2", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171481_(0.0f, -4.0f, 11.0f, 5.0f, 8.0f, 0.005f), PartPose.f_171404_);
        paperStorm.m_171599_("loose_page_3", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171481_(0.0f, -4.0f, 7.0f, 5.0f, 8.0f, 0.005f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(DeathTome entity, float limbAngle, float limbDistance, float customAngle, float headYaw, float headPitch) {
        this.root.f_104204_ = 1.5707964f;
        this.book.f_104205_ = -0.87266463f;
        this.paperStorm.f_104204_ = customAngle * ((float)Math.PI / 180) + 1.5707964f;
        this.paperStorm.f_104205_ = 0.87266463f;
    }

    public void prepareMobModel(DeathTome entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        float bounce = (float)entity.f_19797_ + partialTicks;
        float open = 0.9f;
        float flipRight = 0.4f;
        float flipLeft = 0.6f;
        this.book.m_104227_(0.0f, 8.0f + Mth.m_14031_((float)(bounce * 0.3f)) * 2.0f, 0.0f);
        float openAngle = (Mth.m_14031_((float)(bounce * 0.4f)) * 0.3f + 1.25f) * open;
        this.coverRight.f_104204_ = (float)Math.PI + openAngle;
        this.coverLeft.f_104204_ = -openAngle;
        this.pagesRight.f_104204_ = openAngle;
        this.pagesLeft.f_104204_ = -openAngle;
        this.flippingPageRight.f_104204_ = openAngle - openAngle * 2.0f * flipRight;
        this.flippingPageLeft.f_104204_ = openAngle - openAngle * 2.0f * flipLeft;
        this.pagesRight.f_104200_ = Mth.m_14031_((float)openAngle);
        this.pagesLeft.f_104200_ = Mth.m_14031_((float)openAngle);
        this.flippingPageRight.f_104200_ = Mth.m_14031_((float)openAngle);
        this.flippingPageLeft.f_104200_ = Mth.m_14031_((float)openAngle);
        this.loosePage0.f_104204_ = bounce / 4.0f;
        this.loosePage0.f_104203_ = Mth.m_14031_((float)(bounce / 5.0f)) / 3.0f;
        this.loosePage0.f_104205_ = Mth.m_14089_((float)(bounce / 5.0f)) / 5.0f;
        this.loosePage1.f_104204_ = bounce / 3.0f;
        this.loosePage1.f_104203_ = Mth.m_14031_((float)(bounce / 5.0f)) / 3.0f;
        this.loosePage1.f_104205_ = Mth.m_14089_((float)(bounce / 5.0f)) / 4.0f + 2.0f;
        this.loosePage2.f_104204_ = bounce / 4.0f;
        this.loosePage2.f_104203_ = -Mth.m_14031_((float)(bounce / 5.0f)) / 3.0f;
        this.loosePage2.f_104205_ = Mth.m_14089_((float)(bounce / 5.0f)) / 5.0f - 1.0f;
        this.loosePage3.f_104204_ = bounce / 4.0f;
        this.loosePage3.f_104203_ = -Mth.m_14031_((float)(bounce / 2.0f)) / 4.0f;
        this.loosePage3.f_104205_ = Mth.m_14089_((float)(bounce / 7.0f)) / 5.0f;
    }
}

