/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import twilightforest.block.entity.FireJetBlockEntity;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.FluidTagGenerator;
import twilightforest.enums.FireJetVariant;

public class FireJetBlock
extends BaseEntityBlock {
    public static final EnumProperty<FireJetVariant> STATE = EnumProperty.m_61587_((String)"state", FireJetVariant.class);

    protected FireJetBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)FireJetVariant.IDLE)));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE});
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return state.m_61143_(STATE) == FireJetVariant.IDLE ? null : BlockPathTypes.DAMAGE_FIRE;
    }

    @Deprecated
    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        BlockPos lavaPos;
        if (!world.f_46443_ && state.m_61143_(STATE) == FireJetVariant.IDLE && this.isLava((Level)world, lavaPos = this.findLavaAround((Level)world, pos.m_7495_()))) {
            world.m_46597_(lavaPos, Blocks.f_50016_.m_49966_());
            world.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)FireJetVariant.POPPING)));
        }
    }

    private BlockPos findLavaAround(Level world, BlockPos pos) {
        if (this.isLava(world, pos)) {
            return pos;
        }
        for (int i = 0; i < 3; ++i) {
            BlockPos randPos = pos.m_142082_(world.f_46441_.nextInt(3) - 1, 0, world.f_46441_.nextInt(3) - 1);
            if (!this.isLava(world, randPos)) continue;
            return randPos;
        }
        return pos;
    }

    private boolean isLava(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_204336_(BlockTagGenerator.FIRE_JET_FUEL) || state.m_60734_().m_5888_(state).m_205070_(FluidTagGenerator.FIRE_JET_FUEL);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FireJetBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return FireJetBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.FLAME_JET.get()), FireJetBlockEntity::tick);
    }
}

