/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ConnectableRotatedPillarBlock
extends RotatedPillarBlock {
    private static final BooleanProperty NORTH = PipeBlock.f_55148_;
    private static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    private static final BooleanProperty WEST = PipeBlock.f_55151_;
    private static final BooleanProperty EAST = PipeBlock.f_55149_;
    private static final BooleanProperty UP = PipeBlock.f_55152_;
    private static final BooleanProperty DOWN = PipeBlock.f_55153_;
    final double boundingBoxWidthLower;
    final double boundingBoxWidthUpper;
    private final double boundingBoxHeightLower;
    private final double boundingBoxHeightUpper;

    ConnectableRotatedPillarBlock(BlockBehaviour.Properties props, double size) {
        this(props, size, size);
    }

    ConnectableRotatedPillarBlock(BlockBehaviour.Properties props, double width, double height) {
        super(props.m_60955_());
        if (width >= 16.0) {
            this.boundingBoxWidthLower = 0.0;
            this.boundingBoxWidthUpper = 16.0;
        } else {
            this.boundingBoxWidthLower = 8.0 - width / 2.0;
            this.boundingBoxWidthUpper = 16.0 - this.boundingBoxWidthLower;
        }
        if (height >= 16.0) {
            this.boundingBoxHeightLower = 0.0;
            this.boundingBoxHeightUpper = 16.0;
        } else {
            this.boundingBoxHeightLower = 8.0 - height / 2.0;
            this.boundingBoxHeightUpper = 16.0 - this.boundingBoxHeightLower;
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(this.canConnectTo(facingState, facingState.m_60783_((BlockGetter)world, facingPos, facing.m_122424_()))));
    }

    public boolean canConnectTo(BlockState state, boolean solidSide) {
        return !ConnectableRotatedPillarBlock.m_152463_((BlockState)state) && solidSide;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos blockpos1 = blockpos.m_142127_();
        BlockPos blockpos2 = blockpos.m_142128_();
        BlockPos blockpos3 = blockpos.m_142125_();
        BlockPos blockpos4 = blockpos.m_142126_();
        BlockState blockstate = iblockreader.m_8055_(blockpos1);
        BlockState blockstate1 = iblockreader.m_8055_(blockpos2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos3);
        BlockState blockstate3 = iblockreader.m_8055_(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)context.m_43719_().m_122434_())).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate, blockstate.m_60783_((BlockGetter)iblockreader, blockpos1, Direction.SOUTH))))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate1, blockstate1.m_60783_((BlockGetter)iblockreader, blockpos2, Direction.NORTH))))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate2, blockstate2.m_60783_((BlockGetter)iblockreader, blockpos3, Direction.EAST))))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate3, blockstate3.m_60783_((BlockGetter)iblockreader, blockpos4, Direction.WEST))));
    }

    protected AABB getSidedAABBStraight(Direction facing, Direction.Axis axis) {
        return this.makeQuickAABB(facing == Direction.EAST ? 16.0 : (axis == Direction.Axis.X ? this.boundingBoxHeightLower : this.boundingBoxWidthLower), facing == Direction.UP ? 16.0 : (axis == Direction.Axis.Y ? this.boundingBoxHeightLower : this.boundingBoxWidthLower), facing == Direction.SOUTH ? 16.0 : (axis == Direction.Axis.Z ? this.boundingBoxHeightLower : this.boundingBoxWidthLower), facing == Direction.WEST ? 0.0 : (axis == Direction.Axis.X ? this.boundingBoxHeightUpper : this.boundingBoxWidthUpper), facing == Direction.DOWN ? 0.0 : (axis == Direction.Axis.Y ? this.boundingBoxHeightUpper : this.boundingBoxWidthUpper), facing == Direction.NORTH ? 0.0 : (axis == Direction.Axis.Z ? this.boundingBoxHeightUpper : this.boundingBoxWidthUpper));
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            case Direction.Axis.X -> ConnectableRotatedPillarBlock.m_49796_((double)0.0, (double)((Boolean)state.m_61143_((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.m_61143_((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)16.0, (double)((Boolean)state.m_61143_((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.m_61143_((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper));
            case Direction.Axis.Z -> ConnectableRotatedPillarBlock.m_49796_((double)((Boolean)state.m_61143_((Property)EAST) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.m_61143_((Property)SOUTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.m_61143_((Property)WEST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)((Boolean)state.m_61143_((Property)NORTH) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0);
            default -> ConnectableRotatedPillarBlock.m_49796_((double)((Boolean)state.m_61143_((Property)WEST) != false ? 0.0 : this.boundingBoxWidthLower), (double)0.0, (double)((Boolean)state.m_61143_((Property)NORTH) != false ? 0.0 : this.boundingBoxWidthLower), (double)((Boolean)state.m_61143_((Property)EAST) != false ? 16.0 : this.boundingBoxWidthUpper), (double)16.0, (double)((Boolean)state.m_61143_((Property)SOUTH) != false ? 16.0 : this.boundingBoxWidthUpper));
        };
    }

    protected AABB makeQuickAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new AABB(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
    }
}

