/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.common;

import cofh.core.config.world.OreConfig;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.config.ThermalWorldConfig;
import cofh.thermal.core.init.TCoreEntities;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.lib.world.DimensionPlacement;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="thermal")
public class ThermalFeatures {
    public static final DeferredRegister<ConfiguredFeature<?, ?>> FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"thermal");
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"thermal");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"thermal");
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIERS = DeferredRegister.create((ResourceKey)Registry.f_194569_, (String)"thermal");
    public static final DeferredRegister<RuleTestType<?>> RULE_TESTS = DeferredRegister.create((ResourceKey)Registry.f_122911_, (String)"thermal");
    public static final RegistryObject<PlacementModifierType<?>> DIMENSION_PLACEMENT = PLACEMENT_MODIFIERS.register("dimension_placement", DimensionPlacement.Type::new);
    public static List<Pair<String, RegistryObject<PlacedFeature>>> oreFeatures = new ArrayList<Pair<String, RegistryObject<PlacedFeature>>>();
    public static List<Holder<PlacedFeature>> oresToGenerate = null;
    private static RegistryObject<PlacedFeature> placedOilSand;
    public static final RuleTest SAND;
    public static final RuleTest RED_SAND;

    public static void register(IEventBus bus) {
        FEATURES.register(bus);
        CONFIGURED_FEATURES.register(bus);
        PLACED_FEATURES.register(bus);
        PLACEMENT_MODIFIERS.register(bus);
        RULE_TESTS.register(bus);
    }

    public static void register() {
        ThermalFeatures.registerDefaultTriangleOreFeature("niter_ore");
        ThermalFeatures.registerDefaultTriangleOreFeature("sulfur_ore");
        ThermalFeatures.registerDefaultTriangleOreFeature("tin_ore");
        ThermalFeatures.registerDefaultTriangleOreFeature("lead_ore");
        ThermalFeatures.registerDefaultTriangleOreFeature("silver_ore");
        ThermalFeatures.registerDefaultTriangleOreFeature("nickel_ore");
        ThermalFeatures.registerDefaultTriangleOreFeature("apatite_ore");
        ThermalFeatures.registerDefaultTriangleOreFeature("cinnabar_ore");
        OreConfig oilSandConfig = ThermalWorldConfig.getOreConfig("oil_sand");
        RegistryObject configuredOilSand = CONFIGURED_FEATURES.register("oil_sand", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ThermalFeatures.getOilSandReplacements(), oilSandConfig.getSize())));
        placedOilSand = PLACED_FEATURES.register("oil_sand", () -> new PlacedFeature((Holder)configuredOilSand.getHolder().get(), List.of(CountPlacement.m_191628_((int)oilSandConfig.getCount()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)oilSandConfig.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)oilSandConfig.getMaxY())))));
    }

    public static void registerDefaultTriangleOreFeature(String oreName) {
        ThermalFeatures.registerDefaultOreFeature(oreName, true);
    }

    public static void registerDefaultUniformOreFeature(String oreName) {
        ThermalFeatures.registerDefaultOreFeature(oreName, false);
    }

    public static void registerDefaultOreFeature(String oreName, boolean triangle) {
        OreConfig oreConfig = ThermalWorldConfig.getOreConfig(oreName);
        RegistryObject configuredOre = CONFIGURED_FEATURES.register(oreName, () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ThermalFeatures.getOreReplacements(oreName), oreConfig.getSize())));
        oreFeatures.add((Pair<String, RegistryObject<PlacedFeature>>)Pair.of((Object)oreName, (Object)PLACED_FEATURES.register(oreName, () -> new PlacedFeature((Holder)configuredOre.getHolder().get(), List.of(CountPlacement.m_191628_((int)oreConfig.getCount()), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_(), triangle ? HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)oreConfig.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)oreConfig.getMaxY())) : HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)oreConfig.getMinY()), (VerticalAnchor)VerticalAnchor.m_158922_((int)oreConfig.getMaxY())))))));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (ThermalFeatures.isOverworldBiome(event.getCategory())) {
            if (oresToGenerate == null) {
                oresToGenerate = new ArrayList<Holder<PlacedFeature>>();
                for (Pair<String, RegistryObject<PlacedFeature>> entry : oreFeatures) {
                    OreConfig config = ThermalWorldConfig.getOreConfig((String)entry.left());
                    if (config == null || !config.shouldGenerate()) continue;
                    oresToGenerate.add((Holder<PlacedFeature>)((Holder)((RegistryObject)entry.right()).getHolder().get()));
                }
            }
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).addAll(oresToGenerate);
            Biome.BiomeCategory category = event.getCategory();
            if (category == Biome.BiomeCategory.DESERT || category == Biome.BiomeCategory.MESA) {
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add((Holder)placedOilSand.getHolder().get());
            }
        }
        ThermalFeatures.addHostileSpawns(event);
    }

    public static void addHostileSpawns(BiomeLoadingEvent event) {
        MobSpawnSettingsBuilder builder = event.getSpawns();
        if (builder.getSpawner(MobCategory.MONSTER).isEmpty()) {
            return;
        }
        ResourceLocation name = event.getName();
        Biome.BiomeCategory category = event.getCategory();
        Biome.ClimateSettings climate = event.getClimate();
        if (ThermalFeatures.isOverworldBiome(category)) {
            if (category == Biome.BiomeCategory.EXTREME_HILLS || category == Biome.BiomeCategory.MESA) {
                builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TCoreEntities.BASALZ.get(), 10, 1, 3));
            }
            if (category == Biome.BiomeCategory.DESERT || category == Biome.BiomeCategory.MESA || category == Biome.BiomeCategory.SAVANNA) {
                builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TCoreEntities.BLITZ.get(), 10, 1, 3));
            }
            if (climate.f_47680_ == Biome.Precipitation.SNOW & climate.f_47681_ <= 0.3f) {
                builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TCoreEntities.BLIZZ.get(), 10, 1, 3));
            }
        } else if (ThermalFeatures.isNetherBiome(category) && name != null && name.toString().equals("minecraft:basalt_deltas")) {
            builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TCoreEntities.BASALZ.get(), 10, 1, 3));
        }
    }

    public static List<OreConfiguration.TargetBlockState> getOreReplacements(String oreName) {
        ArrayList<OreConfiguration.TargetBlockState> oreReplacements = new ArrayList<OreConfiguration.TargetBlockState>();
        if (ThermalCore.BLOCKS.get(oreName) != null) {
            oreReplacements.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)ThermalCore.BLOCKS.get(oreName)).m_49966_()));
        }
        if (ThermalCore.BLOCKS.get(RegistrationHelper.deepslate(oreName)) != null) {
            oreReplacements.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate(oreName))).m_49966_()));
        }
        if (ThermalCore.BLOCKS.get(RegistrationHelper.netherrack(oreName)) != null) {
            oreReplacements.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195074_, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.netherrack(oreName))).m_49966_()));
        }
        return oreReplacements;
    }

    private static List<OreConfiguration.TargetBlockState> getOilSandReplacements() {
        return List.of(OreConfiguration.m_161021_((RuleTest)SAND, (BlockState)((Block)ThermalCore.BLOCKS.get("oil_sand")).m_49966_()), OreConfiguration.m_161021_((RuleTest)RED_SAND, (BlockState)((Block)ThermalCore.BLOCKS.get("oil_red_sand")).m_49966_()));
    }

    public static boolean isOverworldBiome(Biome.BiomeCategory category) {
        return category != Biome.BiomeCategory.NONE && category != Biome.BiomeCategory.THEEND && category != Biome.BiomeCategory.NETHER;
    }

    public static boolean isNetherBiome(Biome.BiomeCategory category) {
        return category == Biome.BiomeCategory.NETHER;
    }

    static {
        SAND = new BlockMatchTest(Blocks.f_49992_);
        RED_SAND = new BlockMatchTest(Blocks.f_49993_);
    }
}

