/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.block.entity;

import cofh.core.block.entity.TileCoFH;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IAugmentableItem;
import cofh.core.network.packet.client.TileControlPacket;
import cofh.core.network.packet.client.TileRedstonePacket;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.IRedstoneControllableTile;
import cofh.core.util.control.ISecurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.core.util.control.RedstoneControlModule;
import cofh.core.util.control.SecurityControlModule;
import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FilterRegistry;
import cofh.core.util.filter.IFilter;
import cofh.core.util.filter.IFilterableTile;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FilterHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.IStorageCallback;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.block.entity.ITileCallback;
import cofh.lib.energy.EmptyEnergyStorage;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.fluid.ManagedTankInv;
import cofh.lib.fluid.SimpleTankInv;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.ManagedItemInv;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.xp.EmptyXpStorage;
import cofh.lib.xp.XpStorage;
import cofh.thermal.core.config.ThermalClientConfig;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public abstract class AugmentableBlockEntity
extends TileCoFH
implements MenuProvider,
ISecurableTile,
IRedstoneControllableTile,
IFilterableTile {
    protected static final int BASE_ENERGY = 50000;
    protected static final int BASE_PROCESS_TICK = 20;
    protected static final int BASE_XP_STORAGE = 2500;
    protected ManagedItemInv inventory = new ManagedItemInv((IStorageCallback)this, "ItemInv");
    protected ManagedTankInv tankInv = new ManagedTankInv((ITileCallback)this, "TankInv");
    protected EnergyStorageCoFH energyStorage = EmptyEnergyStorage.INSTANCE;
    protected XpStorage xpStorage = EmptyXpStorage.INSTANCE;
    protected IFilter filter = EmptyFilter.INSTANCE;
    protected SecurityControlModule securityControl = new SecurityControlModule((ISecurableTile)this);
    protected RedstoneControlModule redstoneControl = new RedstoneControlModule((IRedstoneControllableTile)this);
    protected List<ItemStorageCoFH> augments = Collections.emptyList();
    protected ListTag enchantments = new ListTag();
    public boolean isActive;
    protected FluidStack renderFluid = FluidStack.EMPTY;
    protected boolean redstoneControlFeature = this.defaultRedstoneControlState();
    protected boolean xpStorageFeature = this.defaultXpStorageState();
    protected boolean creativeEnergy = false;
    protected boolean creativeTanks = false;
    protected CompoundTag augmentNBT;
    protected LazyOptional<?> energyCap = LazyOptional.empty();
    protected LazyOptional<?> itemCap = LazyOptional.empty();
    protected LazyOptional<?> fluidCap = LazyOptional.empty();

    public AugmentableBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.redstoneControl.setEnabled(() -> this.redstoneControlFeature);
    }

    protected int getBaseEnergyStorage() {
        return 50000;
    }

    protected int getBaseEnergyXfer() {
        return this.getBaseProcessTick() * 10;
    }

    protected int getBaseProcessTick() {
        return 20;
    }

    protected int getBaseXpStorage() {
        return 2500;
    }

    public void m_7651_() {
        super.m_7651_();
        this.energyCap.invalidate();
        this.itemCap.invalidate();
        this.fluidCap.invalidate();
    }

    public int invSize() {
        return this.inventory.getSlots();
    }

    public int augSize() {
        return this.augments.size();
    }

    public SimpleItemInv getItemInv() {
        return this.inventory;
    }

    public SimpleTankInv getTankInv() {
        return this.tankInv;
    }

    protected void initHandlers() {
        this.inventory.initHandlers();
        this.tankInv.initHandlers();
    }

    protected void updateActiveState(boolean prevActive) {
        if (prevActive != this.isActive) {
            if (this.m_58900_().m_61138_((Property)BlockStatePropertiesCoFH.ACTIVE)) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStatePropertiesCoFH.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            }
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
    }

    protected boolean cacheRenderFluid() {
        return false;
    }

    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        if (this.f_58857_ != null && this.redstoneControl.isControllable()) {
            this.redstoneControl.setPower(this.f_58857_.m_46755_(this.f_58858_));
            TileRedstonePacket.sendToClient((IPacketHandlerTile)this);
        }
    }

    public void onPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(worldIn, pos, state, placer, stack);
        this.enchantments = stack.m_41785_();
        this.updateAugmentState();
        if (this.redstoneControl.isControllable()) {
            this.redstoneControl.setPower(worldIn.m_46755_(this.f_58858_));
        }
        this.onControlUpdate();
    }

    public void onReplaced(BlockState state, Level worldIn, BlockPos pos, BlockState newState) {
        int i;
        if (!this.keepItems()) {
            for (i = 0; i < this.invSize() - this.augSize(); ++i) {
                Utils.dropItemStackIntoWorldWithRandomness((ItemStack)this.inventory.getStackInSlot(i), (Level)worldIn, (BlockPos)pos);
            }
        }
        if (!ThermalCoreConfig.keepAugments.get().booleanValue()) {
            for (i = this.invSize() - this.augSize(); i < this.invSize(); ++i) {
                Utils.dropItemStackIntoWorldWithRandomness((ItemStack)this.inventory.getStackInSlot(i), (Level)worldIn, (BlockPos)pos);
            }
        }
        if (this.xpStorage.getStored() > 0) {
            this.spawnXpOrbs(this.f_58857_, this.xpStorage.getStored(), Vec3.m_82539_((Vec3i)pos));
        }
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41698_("BlockEntityTag");
        if (this.keepEnergy()) {
            this.getEnergyStorage().writeWithParams(nbt);
        }
        if (this.keepItems()) {
            this.getItemInv().writeSlotsToNBT(nbt, 0, this.invSize() - this.augSize());
        }
        if (ThermalCoreConfig.keepAugments.get().booleanValue() && this.augSize() > 0) {
            this.getItemInv().writeSlotsToNBTUnordered(nbt, "Augments", this.invSize() - this.augSize());
            if (stack.m_41720_() instanceof IAugmentableItem) {
                List<ItemStack> items = this.getAugmentsAsList();
                ((IAugmentableItem)stack.m_41720_()).updateAugmentState(stack, items);
            }
            this.filter.write(nbt);
        }
        if (this.keepFluids()) {
            this.getTankInv().write(nbt);
        }
        if (ThermalCoreConfig.keepRSControl.get().booleanValue() && this.redstoneControlFeature) {
            this.redstoneControl().writeSettings(nbt);
        }
        if (ThermalCoreConfig.keepSideConfig.get().booleanValue() && this instanceof IReconfigurableTile) {
            ((IReconfigurableTile)this).reconfigControl().writeSettings(nbt);
        }
        if (ThermalCoreConfig.keepTransferControl.get().booleanValue() && this instanceof ITransferControllableTile) {
            ((ITransferControllableTile)this).transferControl().writeSettings(nbt);
        }
        if (this.hasSecurity()) {
            this.securityControl().write(nbt);
        }
        if (!nbt.m_128456_()) {
            stack.m_41700_("BlockEntityTag", (Tag)nbt);
        }
        if (!this.enchantments.isEmpty()) {
            stack.m_41784_().m_128365_("Enchantments", (Tag)this.enchantments);
        }
        return super.createItemStackTag(stack);
    }

    public boolean onActivatedDelegate(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_36341_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.openFilterGui(serverPlayer);
        }
        ItemStack stack = player.m_21120_(hand);
        if (this.augValidator().test(stack)) {
            if (this.attemptAugmentInstall(stack)) {
                if (!player.m_150110_().f_35937_) {
                    player.m_21008_(hand, ItemHelper.consumeItem((ItemStack)stack, (int)1));
                }
                player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)TCoreSounds.SOUND_TINKER.get(), SoundSource.PLAYERS, 0.1f, (MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.35f + 0.9f);
            } else {
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12490_, SoundSource.PLAYERS, 0.1f, 0.25f);
            }
            return true;
        }
        return super.onActivatedDelegate(world, pos, state, player, hand, result);
    }

    protected boolean keepEnergy() {
        return ThermalCoreConfig.keepEnergy.get();
    }

    protected boolean keepFluids() {
        return ThermalCoreConfig.keepFluids.get();
    }

    protected boolean keepItems() {
        return ThermalCoreConfig.keepItems.get();
    }

    public ItemStorageCoFH getSlot(int slot) {
        return this.inventory.getSlot(slot);
    }

    public FluidStorageCoFH getTank(int tank) {
        return this.tankInv.getTank(tank);
    }

    public EnergyStorageCoFH getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    public int getScaledDuration() {
        return this.getScaledDuration(16);
    }

    public int getScaledDuration(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getScaledProgress() {
        return this.getScaledProgress(24);
    }

    public int getScaledProgress(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getScaledSpeed() {
        return this.getScaledSpeed(16);
    }

    public int getScaledSpeed(int scale) {
        return this.isActive ? scale : 0;
    }

    public int getCurSpeed() {
        return -1;
    }

    public int getMaxSpeed() {
        return -1;
    }

    public double getEfficiency() {
        return -1.0;
    }

    public boolean clearEnergy(int coil) {
        return this.energyStorage.clear();
    }

    public boolean clearSlot(int slot) {
        if (slot >= this.inventory.getSlots()) {
            return false;
        }
        if (this.inventory.getSlot(slot).clear()) {
            this.onInventoryChanged(slot);
            return true;
        }
        return false;
    }

    public boolean clearTank(int tank) {
        if (tank >= this.tankInv.getTanks()) {
            return false;
        }
        if (this.tankInv.getTank(tank).clear()) {
            this.onTankChanged(tank);
            return true;
        }
        return false;
    }

    public FriendlyByteBuf getControlPacket(FriendlyByteBuf buffer) {
        super.getControlPacket(buffer);
        this.securityControl.writeToBuffer(buffer);
        this.redstoneControl.writeToBuffer(buffer);
        buffer.writeFluidStack(this.renderFluid);
        return buffer;
    }

    public void handleControlPacket(FriendlyByteBuf buffer) {
        super.handleControlPacket(buffer);
        this.securityControl.readFromBuffer(buffer);
        this.redstoneControl.readFromBuffer(buffer);
        this.renderFluid = buffer.readFluidStack();
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeBoolean(this.isActive);
        buffer.writeFluidStack(this.renderFluid);
        this.energyStorage.writeToBuffer(buffer);
        this.xpStorage.writeToBuffer(buffer);
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            buffer.writeFluidStack(this.tankInv.get(i));
        }
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.isActive = buffer.readBoolean();
        this.renderFluid = buffer.readFluidStack();
        this.energyStorage.readFromBuffer(buffer);
        this.xpStorage.readFromBuffer(buffer);
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            this.tankInv.set(i, buffer.readFluidStack());
        }
    }

    public FriendlyByteBuf getRedstonePacket(FriendlyByteBuf buffer) {
        super.getRedstonePacket(buffer);
        buffer.writeInt(this.redstoneControl.getPower());
        return buffer;
    }

    public void handleRedstonePacket(FriendlyByteBuf buffer) {
        super.handleRedstonePacket(buffer);
        this.redstoneControl.setPower(buffer.readInt());
    }

    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        super.getStatePacket(buffer);
        buffer.writeBoolean(this.isActive);
        buffer.writeFluidStack(this.renderFluid);
        return buffer;
    }

    public void handleStatePacket(FriendlyByteBuf buffer) {
        super.handleStatePacket(buffer);
        boolean prevActive = this.isActive;
        this.isActive = buffer.readBoolean();
        this.renderFluid = buffer.readFluidStack();
        if (ThermalClientConfig.blockAmbientSounds.get().booleanValue() && this.isActive && !prevActive) {
            SoundHelper.playSound((Object)this.getSound());
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isActive = nbt.m_128471_("Active");
        this.enchantments = nbt.m_128437_("Enchantments", 10);
        this.inventory.read(nbt);
        if (nbt.m_128441_("Augments")) {
            this.inventory.readSlotsUnordered(nbt.m_128437_("Augments", 10), this.invSize() - this.augSize());
        }
        this.updateAugmentState();
        this.tankInv.read(nbt);
        this.energyStorage.read(nbt);
        this.xpStorage.read(nbt);
        this.filter.read(nbt);
        this.securityControl.read(nbt);
        this.redstoneControl.read(nbt);
        this.renderFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("RenderFluid"));
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Active", this.isActive);
        nbt.m_128365_("Enchantments", (Tag)this.enchantments);
        this.inventory.write(nbt);
        this.tankInv.write(nbt);
        this.getEnergyStorage().write(nbt);
        this.getXpStorage().write(nbt);
        this.filter.write(nbt);
        this.securityControl.write(nbt);
        this.redstoneControl.write(nbt);
        if (!this.renderFluid.isEmpty()) {
            nbt.m_128365_("RenderFluid", (Tag)this.renderFluid.writeToNBT(new CompoundTag()));
        }
    }

    protected final boolean attemptAugmentInstall(ItemStack stack) {
        for (ItemStorageCoFH augSlot : this.augments) {
            if (!augSlot.isEmpty() || !augSlot.isItemValid(stack)) continue;
            augSlot.setItemStack(ItemHelper.cloneStack((ItemStack)stack, (int)1));
            this.updateAugmentState();
            return true;
        }
        return false;
    }

    protected final void addAugmentSlots(int numAugments) {
        this.augments = new ArrayList<ItemStorageCoFH>(numAugments);
        for (int i = 0; i < numAugments; ++i) {
            ItemStorageCoFH slot = new ItemStorageCoFH(1, this.augValidator());
            this.augments.add(slot);
            this.inventory.addSlot(slot, StorageGroup.INTERNAL);
        }
        ((ArrayList)this.augments).trimToSize();
    }

    protected final void updateAugmentState() {
        this.resetAttributes();
        for (ItemStorageCoFH slot : this.augments) {
            ItemStack augment = slot.getItemStack();
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(augmentData);
        }
        this.finalizeAttributes(EnchantmentHelper.m_44882_((ListTag)this.enchantments));
        this.augmentNBT = null;
    }

    protected final List<ItemStack> getAugmentsAsList() {
        return this.augments.stream().map(ItemStorageCoFH::getItemStack).collect(Collectors.toList());
    }

    protected Predicate<ItemStack> augValidator() {
        return AugmentDataHelper::hasAugmentData;
    }

    protected void resetAttributes() {
        this.augmentNBT = new CompoundTag();
        this.redstoneControlFeature = this.defaultRedstoneControlState();
        this.xpStorageFeature = this.defaultXpStorageState();
        this.creativeEnergy = false;
        this.creativeTanks = false;
    }

    protected void setAttributesFromAugment(CompoundTag augmentData) {
        this.redstoneControlFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"RSCtl") > 0.0f;
        this.xpStorageFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"XpStr") > 0.0f;
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"RFXfer");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"RFMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"FluidMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"ItemMax");
        AugmentableHelper.setAttributeFromAugmentString((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"FilterType");
        this.creativeEnergy |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"RFCre") > 0.0f;
        this.creativeTanks |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"FluidCre") > 0.0f;
    }

    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        float holdingMod = this.getHoldingMod(enchantmentMap);
        float baseMod = AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f);
        float energyStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"RFMax", (float)1.0f);
        float fluidStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"FluidMax", (float)1.0f);
        float itemStorageMod = holdingMod * baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"ItemMax", (float)1.0f);
        float xpStorageMod = holdingMod * baseMod;
        float energyXferMod = baseMod * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"RFXfer", (float)1.0f);
        this.energyStorage.applyModifiers(energyStorageMod, energyXferMod).setCreative(() -> this.creativeEnergy);
        for (int i = 0; i < this.tankInv.getTanks(); ++i) {
            this.tankInv.getTank(i).applyModifiers(fluidStorageMod).setCreative(() -> this.creativeTanks);
        }
        int storedXp = this.xpStorage.getStored();
        this.xpStorage.applyModifiers(xpStorageMod * (float)(this.xpStorageFeature ? 1 : 0));
        if (storedXp > 0 && this.xpStorage.getStored() < storedXp) {
            this.spawnXpOrbs(this.f_58857_, storedXp - this.xpStorage.getStored(), Vec3.m_82539_((Vec3i)this.f_58858_));
        }
        CompoundTag filterNBT = this.filter.write(new CompoundTag());
        this.filter = FilterRegistry.getTileFilter((String)AugmentableHelper.getAttributeModString((CompoundTag)this.augmentNBT, (String)"FilterType"), (CompoundTag)filterNBT, (IFilterableTile)this);
    }

    protected boolean defaultReconfigState() {
        return ThermalCoreConfig.defaultReconfigSides.get();
    }

    protected boolean defaultRedstoneControlState() {
        return ThermalCoreConfig.defaultRSControl.get();
    }

    protected boolean defaultXpStorageState() {
        return ThermalCoreConfig.defaultXPStorage.get();
    }

    protected float getHoldingMod(Map<Enchantment, Integer> enchantmentMap) {
        int holding = enchantmentMap.getOrDefault(CoreEnchantments.HOLDING.get(), 0);
        return 1.0f + (float)holding / 2.0f;
    }

    public SecurityControlModule securityControl() {
        return this.securityControl;
    }

    public RedstoneControlModule redstoneControl() {
        return this.redstoneControl;
    }

    protected void updateHandlers() {
        LazyOptional<?> prevEnergyCap = this.energyCap;
        this.energyCap = this.energyStorage.getCapacity() > 0 ? LazyOptional.of(() -> this.energyStorage) : LazyOptional.empty();
        prevEnergyCap.invalidate();
        LazyOptional<?> prevItemCap = this.itemCap;
        IItemHandler invHandler = this.inventory.getHandler(StorageGroup.ACCESSIBLE);
        this.itemCap = this.inventory.hasAccessibleSlots() ? LazyOptional.of(() -> invHandler) : LazyOptional.empty();
        prevItemCap.invalidate();
        LazyOptional<?> prevFluidCap = this.fluidCap;
        IFluidHandler fluidHandler = this.tankInv.getHandler(StorageGroup.ACCESSIBLE);
        this.fluidCap = this.tankInv.hasAccessibleTanks() ? LazyOptional.of(() -> fluidHandler) : LazyOptional.empty();
        prevFluidCap.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem() && this.energyStorage.getMaxEnergyStored() > 0) {
            return this.getEnergyCapability(side);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory.hasAccessibleSlots()) {
            return this.getItemHandlerCapability(side);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.tankInv.hasAccessibleTanks()) {
            return this.getFluidHandlerCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getEnergyCapability(@Nullable Direction side) {
        if (!this.energyCap.isPresent() && this.energyStorage.getCapacity() > 0) {
            this.energyCap = LazyOptional.of(() -> this.energyStorage);
        }
        return this.energyCap.cast();
    }

    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (!this.itemCap.isPresent() && this.inventory.hasAccessibleSlots()) {
            IItemHandler handler = this.inventory.getHandler(StorageGroup.ACCESSIBLE);
            this.itemCap = LazyOptional.of(() -> handler);
        }
        return this.itemCap.cast();
    }

    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (!this.fluidCap.isPresent() && this.tankInv.hasAccessibleTanks()) {
            IFluidHandler handler = this.tankInv.getHandler(StorageGroup.ACCESSIBLE);
            this.fluidCap = LazyOptional.of(() -> handler);
        }
        return this.fluidCap.cast();
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public void onFilterChanged() {
    }

    public boolean openGui(ServerPlayer player) {
        if (this.canOpenGui()) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)this, (BlockPos)this.f_58858_);
            return true;
        }
        return false;
    }

    public boolean openFilterGui(ServerPlayer player) {
        IFilter iFilter = this.filter;
        if (iFilter instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)iFilter;
            FilterHelper.openTileScreen((ServerPlayer)player, (MenuProvider)provider, (BlockPos)this.f_58858_);
            return true;
        }
        return false;
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    public void onInventoryChanged(int slot) {
        if (slot >= this.invSize() - this.augSize()) {
            this.updateAugmentState();
        }
        this.markChunkUnsaved();
    }

    public void onControlUpdate() {
        this.updateHandlers();
        this.callNeighborStateChange();
        TileControlPacket.sendToClient((IPacketHandlerTile)this);
        this.markChunkUnsaved();
    }

    public XpStorage getXpStorage() {
        return this.xpStorage;
    }

    public void readConveyableData(Player player, CompoundTag tag) {
        this.redstoneControl.readSettings(tag);
        this.onControlUpdate();
    }

    public void writeConveyableData(Player player, CompoundTag tag) {
        this.redstoneControl.writeSettings(tag);
    }
}

