/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.machine;

import cofh.lib.fluid.FluidIngredient;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.managers.machine.FurnaceRecipeManager;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class FurnaceRecipe
extends ThermalRecipe {
    public FurnaceRecipe(ResourceLocation recipeId, int energy, float experience, @Nullable List<Ingredient> inputItems, @Nullable List<FluidIngredient> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> outputItemChances, @Nullable List<FluidStack> outputFluids) {
        super(recipeId, energy, experience, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
        if (this.energy <= 0) {
            int defaultEnergy = FurnaceRecipeManager.instance().getDefaultEnergy();
            ThermalCore.LOG.warn("Energy value for " + recipeId + " was out of allowable range and has been set to a default value of " + defaultEnergy + ".");
            this.energy = defaultEnergy;
        }
    }

    public FurnaceRecipe(ResourceLocation recipeId, int energy, float experience, AbstractCookingRecipe recipe) {
        this(recipeId, energy, experience, (List<Ingredient>)recipe.m_7527_(), Collections.emptyList(), Collections.singletonList(recipe.m_8043_()), Collections.singletonList(Float.valueOf(-1.0f)), Collections.emptyList());
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ThermalCore.RECIPE_SERIALIZERS.get(TCoreRecipeTypes.ID_RECIPE_FURNACE);
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return TCoreRecipeTypes.RECIPE_FURNACE;
    }
}

