/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.explosive;

import cofh.core.entity.AbstractGrenade;
import cofh.core.entity.AbstractTNTMinecart;
import cofh.core.entity.ElectricField;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.network.packet.client.PlayerMotionPacket;
import cofh.core.util.AreaUtils;
import cofh.lib.entity.PrimedTntCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.item.FertilizerItem;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class DetonateUtils {
    public static List<RegistryObject<EntityType<? extends AbstractGrenade>>> GRENADES = new LinkedList<RegistryObject<EntityType<? extends AbstractGrenade>>>();
    public static List<RegistryObject<EntityType<? extends PrimedTntCoFH>>> TNT = new LinkedList<RegistryObject<EntityType<? extends PrimedTntCoFH>>>();
    public static List<RegistryObject<EntityType<? extends AbstractTNTMinecart>>> CARTS = new LinkedList<RegistryObject<EntityType<? extends AbstractTNTMinecart>>>();

    public static void makeAreaOfEffectCloud(Level level, ParticleOptions particle, Vec3 pos, float radius, int duration) {
        AreaEffectCloud cloud = new AreaEffectCloud(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        cloud.m_19712_(1.0f);
        cloud.m_19724_(particle);
        cloud.m_19734_(duration);
        cloud.m_19740_(0);
        cloud.m_19738_((radius - cloud.m_19743_()) / (float)cloud.m_19748_());
        level.m_7967_((Entity)cloud);
    }

    public static void makeAreaOfEffectCloud(Level level, ParticleOptions particle, Vec3 pos, float radius) {
        DetonateUtils.makeAreaOfEffectCloud(level, particle, pos, radius, 20);
    }

    public static void fire(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        if (!explosive.m_20069_()) {
            AreaUtils.IGNITE_ENTITIES.applyEffectNearby(level, pos, radius, duration, amplifier);
            AreaUtils.FIRE_TRANSFORM_SPECIAL.transformSphere(level, pos, radius, 0.6f, owner);
            AreaUtils.FIRE_TRANSFORM.transformSphere(level, pos, radius, 0.2f, owner);
            DetonateUtils.makeAreaOfEffectCloud(level, (ParticleOptions)ParticleTypes.f_123744_, pos, radius);
        }
    }

    public static void ice(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        AreaUtils.ICE_TRANSFORM.transformSphere(level, pos, radius, owner);
        AreaUtils.CHILL_ENTITIES.applyEffectNearby(level, pos, radius, duration, amplifier);
        DetonateUtils.makeAreaOfEffectCloud(level, (ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()), pos, radius);
    }

    public static void earth(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        AreaUtils.EARTH_TRANSFORM.transformSphere(level, pos, radius, owner);
        AreaUtils.SUNDER_ENTITIES.applyEffectNearby(level, pos, radius, duration, amplifier);
        List items = level.m_6443_(ItemEntity.class, new AABB(pos.m_82492_((double)radius, (double)radius, (double)radius), pos.m_82520_((double)radius, (double)radius, (double)radius)).m_82400_(1.0), EntitySelector.f_20402_);
        for (ItemEntity item : items) {
            if (item.m_32059_() >= 10) continue;
            item.m_20343_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public static void lightning(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        BlockPos blockPos = new BlockPos(pos);
        if (level.m_45527_(blockPos)) {
            Utils.spawnLightningBolt((Level)level, (BlockPos)blockPos, (Entity)owner);
        }
        AreaUtils.SHOCK_ENTITIES.applyEffectNearby(level, pos, radius, duration, amplifier);
        level.m_7967_((Entity)new ElectricField(level, pos, radius, 100).setOwner(owner instanceof LivingEntity ? (LivingEntity)owner : null));
    }

    public static void ender(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        if (!explosive.m_20069_()) {
            AreaUtils.ENDER_AIR_TRANSFORM.transformSphere(level, pos, radius, owner);
            AreaUtils.ENDERFERE_ENTITIES.applyEffectNearby(level, pos, radius, duration, amplifier);
            DetonateUtils.makeAreaOfEffectCloud(level, (ParticleOptions)ParticleTypes.f_123760_, pos, radius);
        }
    }

    public static void glow(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        AreaUtils.GLOW_AIR_TRANSFORM.transformSphere(level, pos, radius, explosive);
        AreaUtils.GLOW_ENTITIES.applyEffectNearby(level, pos, radius, duration, amplifier);
        DetonateUtils.makeAreaOfEffectCloud(level, (ParticleOptions)ParticleTypes.f_123751_, pos, radius);
    }

    public static void redstone(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        AreaUtils.SIGNAL_AIR_TRANSFORM.transformSphere(level, pos, radius, owner);
        DetonateUtils.makeAreaOfEffectCloud(level, (ParticleOptions)DustParticleOptions.f_123656_, pos, radius);
    }

    public static void slime(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        BlockPos blockPos = new BlockPos(pos);
        AABB area = new AABB(blockPos.m_142022_((double)(-radius), (double)(-radius), (double)(-radius)), blockPos.m_142022_((double)(1.0f + radius), (double)(1.0f + radius), (double)(1.0f + radius)));
        for (LivingEntity mob : level.m_6443_(LivingEntity.class, area, EntitySelector.f_20402_)) {
            double d9;
            double d7;
            mob.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SLIMED.get(), duration, amplifier, false, true));
            double d5 = mob.m_20185_() - explosive.m_20185_();
            double d13 = Math.sqrt(d5 * d5 + (d7 = mob.m_20186_() - explosive.m_20186_()) * d7 + (d9 = mob.m_20189_() - explosive.m_20189_()) * d9);
            if (d13 == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d12 = Math.sqrt(explosive.m_20280_((Entity)mob) / 32.0);
            double d14 = Explosion.m_46064_((Vec3)explosive.m_20182_(), (Entity)mob);
            double d11 = ((double)radius - d12) * d14;
            d11 *= 1.0 - mob.m_21133_(Attributes.f_22278_);
            if (mob instanceof ServerPlayer) {
                PlayerMotionPacket.sendToClient((double)(d5 * (d11 /= 4.0)), (double)(d7 * d11), (double)(d9 * d11), (ServerPlayer)((ServerPlayer)mob));
                continue;
            }
            mob.m_20256_(mob.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
        }
        DetonateUtils.makeAreaOfEffectCloud(level, (ParticleOptions)ParticleTypes.f_123753_, pos, radius);
    }

    public static void phyto(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        AreaUtils.GROW_PLANTS.transformSphere(level, pos, radius, owner);
        for (int i = 0; i < 2; ++i) {
            FertilizerItem.growWaterPlant(level, explosive.m_142538_(), null);
        }
        DetonateUtils.makeAreaOfEffectCloud(level, (ParticleOptions)ParticleTypes.f_123748_, pos, radius);
    }

    public static void explosive(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        boolean explosionsBreakBlocks = true;
        level.m_46518_(explosive, explosive.m_20185_(), explosive.m_20186_(), explosive.m_20189_(), 1.9f, false, explosionsBreakBlocks ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
    }

    public static void nuke(Level level, Entity explosive, @Nullable Entity owner, Vec3 pos, float radius, int duration, int amplifier) {
        boolean explosionsBreakBlocks = true;
        level.m_46597_(explosive.m_142538_(), Blocks.f_50016_.m_49966_());
        if (radius <= 0.0f) {
            return;
        }
        float entityRadius = radius * 3.0f;
        BlockPos blockPos = new BlockPos(pos);
        AABB area = new AABB(blockPos.m_142022_((double)(-entityRadius), (double)(-entityRadius), (double)(-entityRadius)), blockPos.m_142022_((double)(1.0f + entityRadius), (double)(1.0f + entityRadius), (double)(1.0f + entityRadius)));
        double entityRadiusSqr = entityRadius * entityRadius;
        level.m_6443_(LivingEntity.class, area, EntitySelector.f_20402_).forEach(target -> {
            double distSqr = pos.m_82557_(target.m_20182_());
            if (distSqr < entityRadiusSqr) {
                float damage = (float)MathHelper.clamp((double)(entityRadiusSqr - distSqr), (double)entityRadius, (double)entityRadiusSqr);
                target.m_6469_(DamageSource.m_19373_((LivingEntity)(owner instanceof LivingEntity ? (LivingEntity)owner : null)), damage);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, duration, amplifier, false, false));
            }
        });
        float blockRadius = radius * 2.0f;
        float f = Math.min(32.0f, blockRadius);
        float maxResistance = 400.0f * blockRadius * blockRadius;
        float f2 = f * f;
        Explosion explosion = new Explosion(level, explosive, null, null, explosive.m_20185_(), explosive.m_20186_(), explosive.m_20189_(), radius * 0.38f, true, explosionsBreakBlocks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        for (BlockPos iterPos : BlockPos.m_121940_((BlockPos)blockPos.m_142022_((double)(-f), (double)(-f / 2.0f), (double)(-f)), (BlockPos)blockPos.m_142022_((double)f, (double)f, (double)f))) {
            BlockState state;
            double distance = iterPos.m_203193_((Position)explosive.m_20182_());
            if (!(distance < (double)f2) || (state = level.m_8055_(iterPos)).m_60795_() || !((double)state.m_60734_().getExplosionResistance(state, (BlockGetter)level, iterPos, explosion) < (double)maxResistance - (double)maxResistance * distance / (double)f2)) continue;
            level.m_46597_(iterPos, Blocks.f_50016_.m_49966_());
        }
        level.m_46518_(explosive, explosive.m_20185_(), explosive.m_20186_(), explosive.m_20189_(), radius * 0.38f, true, explosionsBreakBlocks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
    }
}

