/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.ModRoomPools;

public class DungeonDoor {
    public BlockPos doorPos;
    public Direction doorDir;
    public String doorType;
    private List<String> roomList;
    public AreaDescriptor descriptor;

    public DungeonDoor(BlockPos doorPos, Direction doorDir, String doorType, List<String> roomList, AreaDescriptor desc) {
        this.doorPos = doorPos;
        this.doorDir = doorDir;
        this.doorType = doorType;
        this.roomList = roomList;
        this.descriptor = desc;
    }

    public List<ResourceLocation> getRoomList() {
        ArrayList<ResourceLocation> rlRoomList = new ArrayList<ResourceLocation>();
        for (String room : this.roomList) {
            if (room.startsWith("#") || room.startsWith("$")) continue;
            rlRoomList.add(new ResourceLocation(room));
        }
        return rlRoomList;
    }

    public List<ResourceLocation> getSpecialRoomList() {
        ArrayList<ResourceLocation> rlRoomList = new ArrayList<ResourceLocation>();
        for (String room : this.roomList) {
            if (!room.startsWith("#")) continue;
            String[] splitString = room.split("#");
            rlRoomList.add(new ResourceLocation(splitString[1]));
        }
        return rlRoomList;
    }

    public List<ResourceLocation> getDeadendRoomList() {
        ArrayList<ResourceLocation> rlRoomList = new ArrayList<ResourceLocation>();
        for (String room : this.roomList) {
            if (!room.startsWith("$")) continue;
            String[] splitString = room.split("$");
            rlRoomList.add(new ResourceLocation(splitString[1]));
        }
        if (rlRoomList.isEmpty()) {
            rlRoomList.add(ModRoomPools.DEFAULT_DEADEND);
        }
        return rlRoomList;
    }

    public boolean isDeadend(int roomDepth, int maxRoomDepth) {
        return roomDepth < maxRoomDepth - 2;
    }
}

