/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.ConfigHandler;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.network.SetClientHealthPacket;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.helper.PlayerSacrificeHelper;

@RitualRegister(value="feathered_knife")
public class RitualFeatheredKnife
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String DAMAGE_RANGE = "damage";
    public static double rawWillDrain = 0.05;
    public static double destructiveWillDrain = 0.05;
    public static double corrosiveWillThreshold = 10.0;
    public static double steadfastWillThreshold = 10.0;
    public static double vengefulWillThreshold = 10.0;
    public static int defaultRefreshTime = 20;
    public int refreshTime = 20;
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);

    public RitualFeatheredKnife() {
        super("ritualFeatheredKnife", 0, 25000, "ritual.bloodmagic.featheredKnifeRitual");
        this.addBlockRange(ALTAR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-15, -20, -15), 31, 41, 31));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(DAMAGE_RANGE, 0, 25, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        boolean useIncense;
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        boolean consumeRawWill = rawWill >= rawWillDrain && this.refreshTime != defaultRefreshTime;
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        BlockPos altarPos = pos.m_141952_((Vec3i)this.altarOffsetPos);
        BlockEntity tile = world.m_7702_(altarPos);
        AreaDescriptor altarRange = masterRitualStone.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof IBloodAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                BlockEntity nextTile = world.m_7702_(newPos);
                if (!(nextTile instanceof IBloodAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.m_141950_((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        boolean bl = useIncense = corrosiveWill >= corrosiveWillThreshold;
        if (tile instanceof IBloodAltar) {
            IBloodAltar tileAltar = (IBloodAltar)tile;
            AreaDescriptor damageRange = masterRitualStone.getBlockRange(DAMAGE_RANGE);
            AABB range = damageRange.getAABB(pos);
            double destructiveDrain = 0.0;
            List entities = world.m_45976_(Player.class, range);
            for (Player player : entities) {
                float healthThreshold;
                float f = healthThreshold = steadfastWill >= steadfastWillThreshold ? 0.7f : 0.3f;
                if (vengefulWill >= vengefulWillThreshold && !player.m_36316_().getId().equals(masterRitualStone.getOwner())) {
                    healthThreshold = 0.1f;
                }
                float health = player.m_21223_();
                float maxHealth = player.m_21233_();
                float sacrificedHealth = 1.0f;
                double lpModifier = 1.0;
                if (!(health / player.m_21233_() > healthThreshold) || useIncense && player.m_21023_(BloodMagicPotions.SOUL_FRAY)) continue;
                if (useIncense) {
                    double incenseAmount = PlayerSacrificeHelper.getPlayerIncense(player);
                    sacrificedHealth = health - maxHealth * healthThreshold;
                    lpModifier *= PlayerSacrificeHelper.getModifier(incenseAmount);
                    PlayerSacrificeHelper.setPlayerIncense(player, 0.0);
                    player.m_7292_(new MobEffectInstance(BloodMagicPotions.SOUL_FRAY, PlayerSacrificeHelper.soulFrayDuration));
                }
                if (destructiveWill >= destructiveWillDrain * (double)sacrificedHealth) {
                    lpModifier *= this.getLPModifierForWill(destructiveWill);
                    destructiveWill -= destructiveWillDrain * (double)sacrificedHealth;
                    destructiveDrain += destructiveWillDrain * (double)sacrificedHealth;
                }
                player.m_21153_(health - sacrificedHealth);
                BloodMagic.packetHandler.sendTo(new SetClientHealthPacket(health - sacrificedHealth), (ServerPlayer)player);
                tileAltar.sacrificialDaggerCall((int)((double)ConfigHandler.values.sacrificialDaggerConversion * lpModifier * (double)sacrificedHealth), false);
                if (++totalEffects < maxEffects) continue;
                break;
            }
            if (destructiveDrain > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, destructiveDrain, true);
            }
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
        if (totalEffects > 0 && consumeRawWill) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawWillDrain, true);
        }
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public int getRefreshCost() {
        return 20;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, -1, EnumRuneType.WATER);
        this.addCornerRunes(components, 1, -1, EnumRuneType.AIR);
        this.addOffsetRunes(components, 2, 4, -1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 2, 4, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFeatheredKnife();
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{new TranslatableComponent(this.getTranslationKey() + ".info"), new TranslatableComponent(this.getTranslationKey() + ".default.info"), new TranslatableComponent(this.getTranslationKey() + ".corrosive.info"), new TranslatableComponent(this.getTranslationKey() + ".steadfast.info"), new TranslatableComponent(this.getTranslationKey() + ".destructive.info"), new TranslatableComponent(this.getTranslationKey() + ".vengeful.info")};
    }

    public double getLPModifierForWill(double destructiveWill) {
        return 1.0 + destructiveWill * 0.2 / 100.0;
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill >= rawWillDrain) {
            return 10;
        }
        return defaultRefreshTime;
    }
}

