/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="animal_growth")
public class RitualAnimalGrowth
extends Ritual {
    public static final double rawWillDrain = 0.05;
    public static final double vengefulWillDrain = 0.02;
    public static final double steadfastWillDrain = 0.1;
    public static final double destructiveWillDrain = 1.0;
    public static final String GROWTH_RANGE = "growing";
    public static final String CHEST_RANGE = "chest";
    public static int defaultRefreshTime = 20;
    public int refreshTime = 20;

    public RitualAnimalGrowth() {
        super("ritualAnimalGrowth", 0, 10000, "ritual.bloodmagic.animalGrowthRitual");
        this.addBlockRange(GROWTH_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 1, -2), 5, 2, 5));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(GROWTH_RANGE, 0, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxGrowths = currentEssence / this.getRefreshCost();
        int totalGrowths = 0;
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        BlockEntity chest = world.m_7702_(chestRange.getContainedPositions(pos).get(0));
        IItemHandler itemHandler = null;
        if (chest != null) {
            itemHandler = Utils.getInventory(chest, null);
        }
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        boolean consumeRawWill = rawWill >= 0.05 && this.refreshTime != defaultRefreshTime;
        double vengefulDrain = 0.0;
        double steadfastDrain = 0.0;
        double destructiveDrain = 0.0;
        boolean decreaseBreedTimer = vengefulWill >= 0.02;
        boolean breedAnimals = steadfastWill >= 0.1 && itemHandler != null;
        boolean kamikaze = destructiveWill >= 1.0;
        AreaDescriptor growingRange = masterRitualStone.getBlockRange(GROWTH_RANGE);
        AABB axis = growingRange.getAABB(masterRitualStone.getMasterBlockPos());
        List animalList = world.m_45976_(Animal.class, axis);
        boolean performedEffect = false;
        for (Animal animal : animalList) {
            if (animal.m_146764_() < 0) {
                animal.m_146758_(5);
                ++totalGrowths;
                performedEffect = true;
            } else if (animal.m_146764_() > 0) {
                if (decreaseBreedTimer) {
                    if (vengefulWill >= 0.02) {
                        animal.m_146762_(Math.max(0, animal.m_146764_() - this.getBreedingDecreaseForWill(vengefulWill)));
                        vengefulDrain += 0.02;
                        vengefulWill -= 0.02;
                        performedEffect = true;
                    } else {
                        decreaseBreedTimer = false;
                    }
                }
            } else {
                if (kamikaze) {
                    if (destructiveWill >= 1.0) {
                        if (!animal.m_21023_(BloodMagicPotions.SACRIFICIAL_LAMB)) {
                            animal.m_7292_(new MobEffectInstance(BloodMagicPotions.SACRIFICIAL_LAMB, 1200));
                            destructiveDrain += 1.0;
                            destructiveWill -= 1.0;
                            performedEffect = true;
                        }
                    } else {
                        kamikaze = false;
                    }
                }
                if (breedAnimals) {
                    if (steadfastWill >= 0.1) {
                        if (!animal.m_27593_()) {
                            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                                ItemStack foodStack = itemHandler.getStackInSlot(slot);
                                if (foodStack == null || !animal.m_6898_(foodStack) || itemHandler.extractItem(slot, 1, true) == null) continue;
                                animal.m_27595_(null);
                                itemHandler.extractItem(slot, 1, false);
                                steadfastDrain += 0.1;
                                steadfastWill -= 0.1;
                                performedEffect = true;
                                break;
                            }
                        }
                    } else {
                        breedAnimals = false;
                    }
                }
            }
            if (totalGrowths < maxGrowths) continue;
            break;
        }
        if (performedEffect && consumeRawWill) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, 0.05, true);
        }
        if (vengefulDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrain, true);
        }
        if (steadfastDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrain, true);
        }
        if (destructiveDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveDrain, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(totalGrowths * this.getRefreshCost()));
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 1, 0, EnumRuneType.WATER);
        components.accept(new RitualComponent(new BlockPos(1, 0, 2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(1, 0, -2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(2, 0, 1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(2, 0, -1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-2, 0, 1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-2, 0, -1), EnumRuneType.AIR));
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualAnimalGrowth();
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{new TranslatableComponent(this.getTranslationKey() + ".info"), new TranslatableComponent(this.getTranslationKey() + ".default.info"), new TranslatableComponent(this.getTranslationKey() + ".corrosive.info"), new TranslatableComponent(this.getTranslationKey() + ".steadfast.info"), new TranslatableComponent(this.getTranslationKey() + ".destructive.info"), new TranslatableComponent(this.getTranslationKey() + ".vengeful.info")};
    }

    public int getBreedingDecreaseForWill(double vengefulWill) {
        return (int)(10.0 + vengefulWill / 5.0);
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill >= 0.05) {
            return (int)Math.max((double)defaultRefreshTime - rawWill / 10.0, 1.0);
        }
        return defaultRefreshTime;
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }
}

