/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.potion;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wayoftime.bloodmagic.potion.PotionBloodMagic;
import wayoftime.bloodmagic.potion.PotionFireFuse;
import wayoftime.bloodmagic.potion.PotionHeavyHeart;
import wayoftime.bloodmagic.potion.PotionPassivity;
import wayoftime.bloodmagic.potion.PotionPlantLeech;
import wayoftime.bloodmagic.potion.PotionSacrificialLamb;
import wayoftime.bloodmagic.potion.PotionSoftFall;
import wayoftime.bloodmagic.potion.PotionSoulSnare;
import wayoftime.bloodmagic.potion.PotionSuspended;

public class BloodMagicPotions {
    public static final MobEffect SOUL_SNARE = new PotionSoulSnare();
    public static final MobEffect FIRE_FUSE = new PotionFireFuse();
    public static final MobEffect SOUL_FRAY = new PotionBloodMagic(MobEffectCategory.HARMFUL, -1);
    public static final MobEffect PLANT_LEECH = new PotionPlantLeech();
    public static final MobEffect SACRIFICIAL_LAMB = new PotionSacrificialLamb();
    public static final MobEffect FLIGHT = new PotionBloodMagic(MobEffectCategory.BENEFICIAL, 2350561);
    public static final MobEffect SPECTRAL_SIGHT = new PotionBloodMagic(MobEffectCategory.BENEFICIAL, 3127315);
    public static final MobEffect GRAVITY = new PotionBloodMagic(MobEffectCategory.HARMFUL, 0x800080);
    public static final MobEffect HEAVY_HEART = new PotionHeavyHeart();
    public static final MobEffect GROUNDED = new PotionBloodMagic(MobEffectCategory.HARMFUL, 12223835);
    public static final MobEffect SUSPENDED = new PotionSuspended();
    public static final MobEffect PASSIVITY = new PotionPassivity();
    public static final MobEffect BOUNCE = new PotionBloodMagic(MobEffectCategory.BENEFICIAL, 5766958);
    public static final MobEffect OBSIDIAN_CLOAK = new PotionBloodMagic(MobEffectCategory.BENEFICIAL, 3938957);
    public static final MobEffect HARD_CLOAK = new PotionBloodMagic(MobEffectCategory.BENEFICIAL, 3938957);
    public static final MobEffect SOFT_FALL = new PotionSoftFall();

    public static void registerPotions(RegistryEvent.Register<MobEffect> evt) {
        IForgeRegistry reg = evt.getRegistry();
        reg.register((IForgeRegistryEntry)((MobEffect)SOUL_SNARE.setRegistryName("soulsnare")));
        reg.register((IForgeRegistryEntry)((MobEffect)FIRE_FUSE.setRegistryName("firefuse")));
        reg.register((IForgeRegistryEntry)((MobEffect)SOUL_FRAY.setRegistryName("soulfray")));
        reg.register((IForgeRegistryEntry)((MobEffect)PLANT_LEECH.setRegistryName("plantleech")));
        reg.register((IForgeRegistryEntry)((MobEffect)SACRIFICIAL_LAMB.setRegistryName("sacrificiallamb")));
        reg.register((IForgeRegistryEntry)((MobEffect)FLIGHT.setRegistryName("flight")));
        reg.register((IForgeRegistryEntry)((MobEffect)SPECTRAL_SIGHT.setRegistryName("spectral_sight")));
        reg.register((IForgeRegistryEntry)((MobEffect)GRAVITY.m_19472_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), "AF8B6E3F-3328-4C0A-AA66-6BA6BB6DBEF6", 0.5, AttributeModifier.Operation.MULTIPLY_BASE).setRegistryName("gravity")));
        reg.register((IForgeRegistryEntry)((MobEffect)HEAVY_HEART.setRegistryName("heavy_heart")));
        reg.register((IForgeRegistryEntry)((MobEffect)GROUNDED.setRegistryName("grounded")));
        reg.register((IForgeRegistryEntry)((MobEffect)SUSPENDED.setRegistryName("suspended")));
        reg.register((IForgeRegistryEntry)((MobEffect)PASSIVITY.setRegistryName("passivity")));
        reg.register((IForgeRegistryEntry)((MobEffect)BOUNCE.setRegistryName("bounce")));
        reg.register((IForgeRegistryEntry)((MobEffect)OBSIDIAN_CLOAK.setRegistryName("obsidian_cloak")));
        reg.register((IForgeRegistryEntry)((MobEffect)HARD_CLOAK.m_19472_(Attributes.f_22285_, "BF8B6E3F-3328-4C0A-AA66-3BA6BB6DBEF6", 3.0, AttributeModifier.Operation.ADDITION).setRegistryName("hard_cloak")));
        reg.register((IForgeRegistryEntry)((MobEffect)SOFT_FALL.setRegistryName("soft_fall")));
    }

    public static MobEffect getEffect(ResourceLocation rl) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(rl);
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)effect);
    }
}

