/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.data;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.core.data.BMWorldSavedData;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.event.SoulNetworkEvent;
import wayoftime.bloodmagic.util.BMLog;
import wayoftime.bloodmagic.util.BooleanResult;
import wayoftime.bloodmagic.util.DamageSourceBloodMagic;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class SoulNetwork
implements INBTSerializable<CompoundTag> {
    private final Queue<SoulTicket> ticketHistory = EvictingQueue.create((int)16);
    private BMWorldSavedData parent;
    private Player cachedPlayer;
    private UUID playerId;
    private int currentEssence;
    private int orbTier;

    private SoulNetwork() {
    }

    public void clear() {
        this.ticketHistory.clear();
    }

    public int add(SoulTicket ticket, int maximum) {
        SoulNetworkEvent.Fill event = new SoulNetworkEvent.Fill(this, ticket, maximum);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        int currEss = this.getCurrentEssence();
        if (currEss >= event.getMaximum()) {
            return 0;
        }
        int newEss = Math.min(event.getMaximum(), currEss + event.getTicket().getAmount());
        this.setCurrentEssence(newEss);
        if (this.ticketHistory.contains(ticket)) {
            this.ticketHistory.remove(ticket);
        }
        this.ticketHistory.add(ticket);
        return newEss - currEss;
    }

    @Deprecated
    public int add(int toAdd, int maximum) {
        return this.add(new SoulTicket(toAdd), maximum);
    }

    @Deprecated
    public int addLifeEssence(int toAdd, int maximum) {
        return this.add(toAdd, maximum);
    }

    public int syphon(SoulTicket ticket) {
        return this.syphon(ticket, false);
    }

    public int syphon(SoulTicket ticket, boolean skipEvent) {
        SoulNetworkEvent.Syphon event = new SoulNetworkEvent.Syphon(this, ticket);
        if (!skipEvent && MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        int syphon = event.getTicket().getAmount();
        if (this.getCurrentEssence() >= syphon) {
            this.setCurrentEssence(this.getCurrentEssence() - syphon);
            if (this.ticketHistory.contains(ticket)) {
                this.ticketHistory.remove(ticket);
            }
            this.ticketHistory.add(ticket);
            return syphon;
        }
        return 0;
    }

    @Deprecated
    public int syphon(int amount) {
        return this.syphon(new SoulTicket(amount));
    }

    public BooleanResult<Integer> syphonAndDamage(Player user, SoulTicket ticket) {
        if (user.m_20193_().f_46443_) {
            return BooleanResult.newResult(false, 0);
        }
        SoulNetworkEvent.Syphon.User event = new SoulNetworkEvent.Syphon.User(this, ticket, user);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return BooleanResult.newResult(false, 0);
        }
        int drainAmount = this.syphon(event.getTicket(), true);
        if (drainAmount <= 0 || event.shouldDamage()) {
            this.hurtPlayer(user, event.getTicket().getAmount());
        }
        if (this.ticketHistory.contains(ticket)) {
            this.ticketHistory.remove(ticket);
        }
        this.ticketHistory.add(ticket);
        return BooleanResult.newResult(true, event.getTicket().getAmount());
    }

    @Deprecated
    public boolean syphonAndDamage(Player user, int amount) {
        return this.syphonAndDamage(user, new SoulTicket(amount)).isSuccess();
    }

    public void causeNausea() {
        if (this.getPlayer() != null) {
            this.getPlayer().m_7292_(new MobEffectInstance(MobEffects.f_19604_, 99));
        }
    }

    @Deprecated
    public void causeNauseaToPlayer() {
        this.causeNausea();
    }

    public void hurtPlayer(Player user, float syphon) {
        if (user != null) {
            if (syphon < 100.0f && syphon > 0.0f) {
                if (!user.m_7500_()) {
                    user.f_19802_ = 0;
                    user.m_6469_((DamageSource)DamageSourceBloodMagic.INSTANCE, 1.0f);
                }
            } else if (syphon >= 100.0f && !user.m_7500_()) {
                int i = 0;
                while ((float)i < (syphon + 99.0f) / 100.0f) {
                    user.f_19802_ = 0;
                    user.m_6469_((DamageSource)DamageSourceBloodMagic.INSTANCE, 1.0f);
                    ++i;
                }
            }
        }
    }

    private void markDirty() {
        if (this.getParent() != null) {
            this.getParent().m_77762_();
        } else {
            BMLog.DEFAULT.error("A SoulNetwork was created, but a parent was not set to allow saving.", new Object[0]);
        }
    }

    @Nullable
    public Player getPlayer() {
        if (this.cachedPlayer == null) {
            this.cachedPlayer = PlayerHelper.getPlayerFromUUID(this.playerId);
        }
        return this.cachedPlayer;
    }

    public BMWorldSavedData getParent() {
        return this.parent;
    }

    public SoulNetwork setParent(BMWorldSavedData parent) {
        this.parent = parent;
        this.markDirty();
        return this;
    }

    public Player getCachedPlayer() {
        return this.cachedPlayer;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public int getCurrentEssence() {
        return this.currentEssence;
    }

    public SoulNetwork setCurrentEssence(int currentEssence) {
        this.currentEssence = currentEssence;
        this.markDirty();
        return this;
    }

    public int getOrbTier() {
        return this.orbTier;
    }

    public SoulNetwork setOrbTier(int orbTier) {
        this.orbTier = orbTier;
        this.markDirty();
        return this;
    }

    public List<SoulTicket> getTicketHistory() {
        return ImmutableList.copyOf(this.ticketHistory);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128359_("playerId", this.getPlayerId().toString());
        tagCompound.m_128405_("currentEssence", this.getCurrentEssence());
        tagCompound.m_128405_("orbTier", this.getOrbTier());
        return tagCompound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.playerId = UUID.fromString(nbt.m_128461_("playerId"));
        this.currentEssence = nbt.m_128451_("currentEssence");
        this.orbTier = nbt.m_128451_("orbTier");
    }

    public static SoulNetwork fromNBT(CompoundTag tagCompound) {
        SoulNetwork soulNetwork = new SoulNetwork();
        soulNetwork.deserializeNBT(tagCompound);
        return soulNetwork;
    }

    public static SoulNetwork newEmpty(UUID uuid) {
        SoulNetwork network = new SoulNetwork();
        network.playerId = uuid;
        return network;
    }
}

