/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileDungeonController;
import wayoftime.bloodmagic.common.tile.base.TileBase;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;

public class TileDungeonSeal
extends TileBase {
    public BlockPos controllerPos = BlockPos.f_121853_;
    public BlockPos doorPos = BlockPos.f_121853_;
    public Direction doorDirection = Direction.NORTH;
    public String doorType = "";
    public int activatedRoomDepth;
    public int highestBranchRoomDepth;
    public List<ResourceLocation> potentialRoomTypes = new ArrayList<ResourceLocation>();

    public TileDungeonSeal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileDungeonSeal(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.DUNGEON_SEAL_TYPE.get(), pos, state);
    }

    public int requestRoomFromController(ItemStack heldStack) {
        TileDungeonController tileController;
        int state;
        BlockEntity tile;
        if (DungeonSynthesizer.displayDetailedInformation) {
            System.out.println("Potential rooms: " + this.potentialRoomTypes);
        }
        if (!this.f_58857_.f_46443_ && !this.potentialRoomTypes.isEmpty() && (tile = this.f_58857_.m_7702_(this.controllerPos)) instanceof TileDungeonController && (state = (tileController = (TileDungeonController)tile).handleRequestForRoomPlacement(heldStack, this.doorPos, this.doorDirection, this.doorType, this.activatedRoomDepth, this.highestBranchRoomDepth, this.potentialRoomTypes)) == -1) {
            return -1;
        }
        return 3;
    }

    public void acceptDoorInformation(BlockPos controllerPos, BlockPos doorPos, Direction doorDirection, String doorType, int activatedRoomDepth, int highestBranchRoomDepth, List<ResourceLocation> potentialRoomTypes) {
        this.controllerPos = controllerPos;
        this.doorPos = doorPos;
        this.doorDirection = doorDirection;
        this.doorType = doorType;
        this.potentialRoomTypes = potentialRoomTypes;
        this.activatedRoomDepth = activatedRoomDepth;
        this.highestBranchRoomDepth = highestBranchRoomDepth;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        CompoundTag masterTag = tag.m_128469_("dungeon_controller");
        this.controllerPos = new BlockPos(masterTag.m_128451_("xCoord"), masterTag.m_128451_("yCoord"), masterTag.m_128451_("zCoord"));
        CompoundTag doorTag = tag.m_128469_("dungeon_door");
        this.doorPos = new BlockPos(doorTag.m_128451_("xCoord"), doorTag.m_128451_("yCoord"), doorTag.m_128451_("zCoord"));
        int dir = tag.m_128451_("direction");
        if (dir == 0) {
            this.doorDirection = Direction.NORTH;
        }
        this.doorDirection = Direction.values()[tag.m_128451_("direction")];
        ListTag listnbt = tag.m_128437_("door_types", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            String str = compoundnbt.m_128461_("door");
            this.potentialRoomTypes.add(new ResourceLocation(str));
        }
        this.doorType = tag.m_128461_("type");
        this.activatedRoomDepth = tag.m_128451_("room_depth");
        this.highestBranchRoomDepth = tag.m_128451_("max_room_depth");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        CompoundTag masterTag = new CompoundTag();
        masterTag.m_128405_("xCoord", this.controllerPos.m_123341_());
        masterTag.m_128405_("yCoord", this.controllerPos.m_123342_());
        masterTag.m_128405_("zCoord", this.controllerPos.m_123343_());
        tag.m_128365_("dungeon_controller", (Tag)masterTag);
        CompoundTag doorTag = new CompoundTag();
        doorTag.m_128405_("xCoord", this.doorPos.m_123341_());
        doorTag.m_128405_("yCoord", this.doorPos.m_123342_());
        doorTag.m_128405_("zCoord", this.doorPos.m_123343_());
        tag.m_128365_("dungeon_door", (Tag)doorTag);
        tag.m_128405_("direction", this.doorDirection.m_122411_());
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.potentialRoomTypes.size(); ++i) {
            String str = this.potentialRoomTypes.get(i).toString();
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128359_("door", str);
            listnbt.add((Object)compoundnbt);
        }
        if (!listnbt.isEmpty()) {
            tag.m_128365_("door_types", (Tag)listnbt);
        }
        tag.m_128359_("type", this.doorType);
        tag.m_128405_("room_depth", this.activatedRoomDepth);
        tag.m_128405_("max_room_depth", this.highestBranchRoomDepth);
        return tag;
    }
}

