/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.altar.BloodAltar;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.common.block.BlockAltar;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;

public class TileAltar
extends TileInventory
implements IBloodAltar {
    private BloodAltar bloodAltar = new BloodAltar(this);
    private LazyOptional fluidOptional;
    private boolean isOutputOn = false;

    public TileAltar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 1, "altar", pos, state);
    }

    public TileAltar(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.ALTAR_TYPE.get(), pos, state);
    }

    public boolean getOutputState() {
        return this.isOutputOn;
    }

    public void setOutputState(boolean state) {
        BlockAltar altar = (BlockAltar)this.m_58904_().m_8055_(this.f_58858_).m_60734_();
        this.isOutputOn = state;
        this.f_58857_.m_46672_(this.f_58858_, (Block)altar);
    }

    @Override
    public void deserialize(CompoundTag tagCompound) {
        super.deserialize(tagCompound);
        CompoundTag altarTag = tagCompound.m_128469_("bloodAltar");
        this.bloodAltar.readFromNBT(altarTag);
    }

    @Override
    public CompoundTag serialize(CompoundTag tagCompound) {
        super.serialize(tagCompound);
        CompoundTag altarTag = new CompoundTag();
        this.bloodAltar.writeToNBT(altarTag);
        tagCompound.m_128365_("bloodAltar", (Tag)altarTag);
        return tagCompound;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        TileAltar tile = (TileAltar)te;
        tile.bloodAltar.update();
    }

    @Override
    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        this.bloodAltar.sacrificialDaggerCall(amount, isSacrifice);
    }

    @Override
    public boolean m_7013_(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    @Override
    public int getCapacity() {
        return this.bloodAltar.getCapacity();
    }

    @Override
    public int getCurrentBlood() {
        return this.bloodAltar.getCurrentBlood();
    }

    @Override
    public int getTier() {
        return this.bloodAltar.getTier().toInt();
    }

    @Override
    public int getProgress() {
        return this.bloodAltar.getProgress();
    }

    @Override
    public float getSacrificeMultiplier() {
        return this.bloodAltar.getSacrificeMultiplier();
    }

    @Override
    public float getSelfSacrificeMultiplier() {
        return this.bloodAltar.getSelfSacrificeMultiplier();
    }

    @Override
    public float getOrbMultiplier() {
        return this.bloodAltar.getOrbMultiplier();
    }

    @Override
    public float getDislocationMultiplier() {
        return this.bloodAltar.getDislocationMultiplier();
    }

    @Override
    public float getConsumptionMultiplier() {
        return this.bloodAltar.getConsumptionMultiplier();
    }

    @Override
    public float getConsumptionRate() {
        return this.bloodAltar.getConsumptionRate();
    }

    @Override
    public int getLiquidRequired() {
        return this.bloodAltar.getLiquidRequired();
    }

    @Override
    public int getBufferCapacity() {
        return this.bloodAltar.getBufferCapacity();
    }

    @Override
    public void startCycle() {
        this.bloodAltar.startCycle();
    }

    @Override
    public void checkTier() {
        this.bloodAltar.checkTier();
    }

    @Override
    public void requestPauseAfterCrafting(int cooldown) {
        this.bloodAltar.requestPauseAfterCrafting(cooldown);
    }

    @Override
    public boolean isActive() {
        return this.bloodAltar.isActive();
    }

    @Override
    public int fillMainTank(int amount) {
        return this.bloodAltar.fillMainTank(amount);
    }

    @Override
    public void setActive() {
        this.bloodAltar.setActive();
    }

    @Override
    public int getChargingRate() {
        return this.bloodAltar.getChargingRate();
    }

    @Override
    public int getTotalCharge() {
        return this.bloodAltar.getTotalCharge();
    }

    @Override
    public int getChargingFrequency() {
        return this.bloodAltar.getChargingFrequency();
    }

    public AltarTier getCurrentTierDisplayed() {
        return this.bloodAltar.getCurrentTierDisplayed();
    }

    public boolean setCurrentTierDisplayed(AltarTier altarTier) {
        return this.bloodAltar.setCurrentTierDisplayed(altarTier);
    }

    public int getAnalogSignalStrength(int redstoneMode) {
        return this.bloodAltar.getAnalogSignalStrength(redstoneMode);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
            this.fluidOptional = null;
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidOptional == null) {
                this.fluidOptional = LazyOptional.of(() -> new BloodAltar.VariableSizeFluidHandler(this.bloodAltar));
            }
            return this.fluidOptional.cast();
        }
        return super.getCapability(capability, facing);
    }
}

